/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporePickaxeItems;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class InfectedPickaxe
extends SporePickaxeItems {
    private static final TagKey<Block> ORE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"c:ores"));

    public InfectedPickaxe() {
        super(((Integer)SConfig.SERVER.inf_pickaxe_damage.get()).intValue(), 2.5, 3.0, (Integer)SConfig.SERVER.inf_pickaxe_durability.get(), 7);
    }

    private List<StoreDouble> getBlockChange() {
        ArrayList<StoreDouble> blocks = new ArrayList<StoreDouble>();
        for (String str : (List)SConfig.DATAGEN.block_infection.get()) {
            String[] string = str.split("\\|");
            Block blockCon1 = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)string[0]));
            Block blockCon2 = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)string[1]));
            if (blockCon1 == Blocks.AIR || blockCon2 == Blocks.AIR) continue;
            blocks.add(new StoreDouble(blockCon1, blockCon2));
        }
        return blocks;
    }

    public void changeBlock(Level level, BlockPos pos) {
        List<StoreDouble> values = this.getBlockChange();
        if (!values.isEmpty()) {
            BlockState state = level.getBlockState(pos);
            for (StoreDouble storeDouble : values) {
                if (!storeDouble.value1.equals(state.getBlock()) || storeDouble.value1.defaultBlockState().isAir()) continue;
                level.setBlock(pos, storeDouble.value2.defaultBlockState(), 2);
                level.sendBlockUpdated(pos, storeDouble.value1.defaultBlockState(), storeDouble.value2.defaultBlockState(), 2);
                level.addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0, (double)0.2f, 0.0);
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.tooHurt(context.getItemInHand())) {
                serverPlayer.playNotifySound(Ssounds.INFECTED_PICKAXE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                this.lookForOres(pos, level, serverPlayer);
                this.hurtTool(context.getItemInHand(), (LivingEntity)serverPlayer, 1);
            }
        }
        return super.useOn(context);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity living, LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 200, 1));
        return super.hurtEnemy(stack, living, entity);
    }

    private void lookForOres(BlockPos start, Level level, ServerPlayer player) {
        AABB searchArea = AABB.ofSize((Vec3)new Vec3((double)start.getX(), (double)start.getY(), (double)start.getZ()), (double)35.0, (double)35.0, (double)35.0);
        BlockPos targetOrePos = null;
        for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)searchArea.minX), (int)Mth.floor((double)searchArea.minY), (int)Mth.floor((double)searchArea.minZ), (int)Mth.floor((double)searchArea.maxX), (int)Mth.floor((double)searchArea.maxY), (int)Mth.floor((double)searchArea.maxZ))) {
            if (!level.getBlockState(pos).is(ORE_TAG) || !(player.getRandom().nextFloat() < 0.3f)) continue;
            targetOrePos = pos;
            break;
        }
        if (targetOrePos == null) {
            player.displayClientMessage((Component)Component.translatable((String)"inf_pickaxe_no_ores"), true);
            return;
        }
        MutableComponent component = Component.translatable((String)level.getBlockState(targetOrePos).getBlock().getDescriptionId());
        MutableComponent component1 = Component.translatable((String)"inf_pickaxe_found_ores");
        String string = component1.getString() + component.getString();
        player.displayClientMessage((Component)Component.literal((String)string), true);
        Vec3 startVec = new Vec3((double)start.getX(), (double)start.getY(), (double)start.getZ());
        Vec3 endVec = new Vec3((double)targetOrePos.getX(), (double)targetOrePos.getY(), (double)targetOrePos.getZ());
        Vec3 direction = endVec.subtract(startVec).normalize();
        double distance = startVec.distanceTo(endVec);
        int i = 0;
        while ((double)i <= distance) {
            Vec3 current = startVec.add(direction.scale((double)i));
            BlockPos pos = new BlockPos((int)current.x, (int)current.y, (int)current.z);
            this.changeBlock(level, pos);
            ++i;
        }
        player.getCooldowns().addCooldown((Item)this, 40);
    }

    record StoreDouble(Block value1, Block value2) {
    }
}

