/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporeDiggerTools;
import com.Harbinger.Spore.core.SConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;

public class InfectedScythe
extends SporeDiggerTools {
    protected static final Map<Block, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>> TILLABLES = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.GRASS_BLOCK, (Object)Pair.of(HoeItem::onlyIfAirAbove, InfectedScythe.changeIntoState(Blocks.FARMLAND.defaultBlockState())), (Object)Blocks.DIRT_PATH, (Object)Pair.of(HoeItem::onlyIfAirAbove, InfectedScythe.changeIntoState(Blocks.FARMLAND.defaultBlockState())), (Object)Blocks.DIRT, (Object)Pair.of(HoeItem::onlyIfAirAbove, InfectedScythe.changeIntoState(Blocks.FARMLAND.defaultBlockState())), (Object)Blocks.COARSE_DIRT, (Object)Pair.of(HoeItem::onlyIfAirAbove, InfectedScythe.changeIntoState(Blocks.DIRT.defaultBlockState())), (Object)Blocks.ROOTED_DIRT, (Object)Pair.of(context -> true, InfectedScythe.changeIntoStateAndDropItem(Blocks.DIRT.defaultBlockState(), (ItemLike)Items.HANGING_ROOTS))));

    public InfectedScythe() {
        super((double)((Integer)SConfig.SERVER.scythe_damage.get()).intValue(), 2.5, 3.0, (int)((Integer)SConfig.SERVER.scythe_durability.get()), 3, (TagKey<Block>)BlockTags.MINEABLE_WITH_HOE);
    }

    public InteractionResult useOn(UseOnContext context) {
        Pair pair;
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState toolModifiedState = level.getBlockState(blockpos).getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, InfectedScythe.changeIntoState(toolModifiedState));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            level.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                consumer.accept(context);
                if (player != null) {
                    this.hurtTool(context.getItemInHand(), (LivingEntity)player, 1);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return itemAbility == ItemAbilities.SWORD_SWEEP || ItemAbilities.DEFAULT_HOE_ACTIONS.contains(itemAbility) || itemAbility == ItemAbilities.SHEARS_DIG;
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        return new AABB(target.getX() - 4.0, target.getY(), target.getZ() - 4.0, target.getX() + 4.0, target.getY() + 4.0, target.getZ() + 4.0);
    }

    public static Consumer<UseOnContext> changeIntoState(BlockState state) {
        return context -> {
            context.getLevel().setBlock(context.getClickedPos(), state, 11);
            context.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, context.getClickedPos(), GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)state));
        };
    }

    public static Consumer<UseOnContext> changeIntoStateAndDropItem(BlockState state, ItemLike item) {
        return context -> {
            context.getLevel().setBlock(context.getClickedPos(), state, 11);
            context.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, context.getClickedPos(), GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)state));
            Block.popResourceFromFace((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)context.getClickedFace(), (ItemStack)new ItemStack(item));
        };
    }
}

