/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sentities.Projectile.ThrownSickle;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeSwordBase;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SdataComponents;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class InfectedSickle
extends SporeSwordBase {
    public InfectedSickle() {
        super(((Integer)SConfig.SERVER.sickle_damage.get()).intValue(), 2.0, 2.0, (Integer)SConfig.SERVER.sickle_durability.get());
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity living, LivingEntity entity) {
        if (this.getThrownSickle(stack)) {
            return false;
        }
        return super.hurtEnemy(stack, living, entity);
    }

    @Override
    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return state.is(BlockTags.MINEABLE_WITH_HOE) ? 2.0f : 1.0f;
    }

    @Override
    public ItemAttributeModifiers getDynamicAttributeModifiers(ItemStack stack) {
        return super.getDynamicAttributeModifiers(stack);
    }

    @Override
    public boolean reversedKnockback() {
        return true;
    }

    public void setThrownSickle(ItemStack stack, boolean value) {
        stack.set(SdataComponents.SICKLE_THROW, (Object)value);
    }

    public boolean getThrownSickle(ItemStack stack) {
        return (Boolean)stack.getOrDefault(SdataComponents.SICKLE_THROW.get(), (Object)false);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        ItemStack itemstack = player.getMainHandItem();
        if (!level.isClientSide && this.tooHurt(itemstack)) {
            List projectiles = level.getEntitiesOfClass(ThrownSickle.class, player.getBoundingBox().inflate(32.0), s -> s.getOwner() == player && !s.isRemoved());
            this.setThrownSickle(itemstack, false);
            if (!projectiles.isEmpty()) {
                ThrownSickle sickle = (ThrownSickle)((Object)projectiles.getFirst());
                if (sickle.getHookState() == ThrownSickle.SickelState.HOOKED_IN_ENTITY && sickle.getHookedEntity() != null) {
                    LivingEntity le;
                    Entity hooked = sickle.getHookedEntity();
                    if (hooked instanceof LivingEntity && (le = (LivingEntity)hooked).getAttribute(Attributes.KNOCKBACK_RESISTANCE).getValue() > 0.5) {
                        this.pullEntityToward((Entity)player, hooked.position());
                    } else {
                        this.pullEntityToward(hooked, player.position());
                    }
                } else if (sickle.getHookState() == ThrownSickle.SickelState.HOOKED_BLOCK && sickle.getHookedBlockPos() != null) {
                    this.pullEntityToward((Entity)player, sickle.getHookedBlockPos());
                }
                sickle.discard();
            } else {
                player.startUsingItem(hand);
                return InteractionResultHolder.success((Object)itemstack);
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    private void pullEntityToward(Entity toMove, Vec3 targetPos) {
        Vec3 direction = targetPos.subtract(toMove.position()).normalize();
        double strength = 4.0;
        Vec3 velocity = direction.multiply(strength, strength / 2.0, strength);
        toMove.setDeltaMovement(velocity);
        toMove.hurtMarked = true;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int T) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.getThrownSickle(stack)) {
                int i = this.getUseDuration(stack, entity) - T;
                if (i >= 10 && !level.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    ThrownSickle thrownSpear = new ThrownSickle(level, (LivingEntity)player, stack, this.getVariant(stack).getColor());
                    thrownSpear.setPos(player.getEyePosition());
                    thrownSpear.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.75f);
                    level.addFreshEntity((Entity)thrownSpear);
                    this.setThrownSickle(stack, true);
                    level.playSound(null, (Entity)thrownSpear, Ssounds.INFECTED_WEAPON_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }
}

