/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.ExtremelySusThings.ClientAdvancementTracker;
import com.Harbinger.Spore.ExtremelySusThings.Package.RequestAdvancementPacket;
import com.Harbinger.Spore.ExtremelySusThings.SporePacketHandler;
import com.Harbinger.Spore.Sitems.BaseItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class OrganItem
extends BaseItem {
    private final String info;
    private final String advancementIds;

    public OrganItem(String value, String advancementId) {
        super(new Item.Properties());
        this.info = value;
        this.advancementIds = advancementId;
    }

    public String getAdvancementIds() {
        return this.advancementIds;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (ClientAdvancementTracker.hasAdvancement(this.advancementIds)) {
                tooltipComponents.add((Component)Component.translatable((String)this.info).withStyle(ChatFormatting.GOLD));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"spore.scanner.organ.default").withStyle(ChatFormatting.RED));
            }
            SporePacketHandler.sendToServer(new RequestAdvancementPacket(this.advancementIds, player.getId()));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"spore.scanner.organ.default").withStyle(ChatFormatting.RED));
        }
    }
}

