/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Client.AnimationTrackers.PCIAnimationTracker;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sitems.BaseItem2;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SdataComponents;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public class PCI
extends BaseItem2
implements CustomModelArmorData {
    protected final ResourceLocation BONUS_DAMAGE_MODIFIER_UUID = ResourceLocation.parse((String)"pci_damage");
    protected final ResourceLocation BONUS_REACH_MODIFIER_UUID = ResourceLocation.parse((String)"pci_reach");
    protected final ResourceLocation ATTACK_SPEED_MODIFIER_UUID = ResourceLocation.parse((String)"pci_speed");
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"spore:textures/item/pci.png");
    private static final int RELOAD_TICKS = 60;

    public PCI() {
        super(new Item.Properties().stacksTo(1).durability(((Integer)SConfig.SERVER.pci_durability.get()).intValue()));
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack itemStack) {
        return itemStack.is((Item)Sitems.CIRCUIT_BOARD.get());
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(this.BONUS_DAMAGE_MODIFIER_UUID, (double)((Integer)SConfig.SERVER.pci_damage.get() - 1), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(this.BONUS_REACH_MODIFIER_UUID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(this.ATTACK_SPEED_MODIFIER_UUID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return TEXTURE;
    }

    public void setCharge(ItemStack stack, int value) {
        stack.set(SdataComponents.PCI_AMMO, (Object)value);
    }

    public int getCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault(SdataComponents.PCI_AMMO, (Object)0);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Player player;
        if (entity.level().isClientSide && entity instanceof Player && !(player = (Player)entity).getCooldowns().isOnCooldown((Item)this)) {
            PCIAnimationTracker.trigger(player);
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Infected infected;
        Player player;
        if (attacker instanceof Player && (player = (Player)attacker).getCooldowns().isOnCooldown((Item)this)) {
            return false;
        }
        if (this.getCharge(stack) > 0 && target instanceof Infected && (infected = (Infected)target).getLinked()) {
            infected.setLinked(false);
        }
        if (attacker instanceof Player) {
            player = (Player)attacker;
            this.playSound(player);
        }
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public void playSound(Player player) {
        player.playNotifySound(Ssounds.PCI_INJECT.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.getCharge(stack) < (Integer)SConfig.SERVER.pci_max_charge.get() / 2) {
            this.lookForAmmo(player, stack);
        }
        return super.use(level, player, hand);
    }

    private boolean lookForAmmo(Player player, ItemStack itemStack) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != Sitems.ICE_CANISTER.get() || stack.getCount() <= 0) continue;
            stack.shrink(1);
            this.setCharge(itemStack, (Integer)SConfig.SERVER.pci_max_charge.get());
            player.getCooldowns().addCooldown((Item)this, 60);
            player.playNotifySound(Ssounds.CDU_INSERT.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"pci.line.normal").withStyle(ChatFormatting.BLUE));
        tooltipComponents.add((Component)Component.literal((String)(this.getCharge(stack) + "/" + String.valueOf(SConfig.SERVER.pci_max_charge.get()))).withStyle(ChatFormatting.DARK_BLUE));
    }
}

