/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sitems.BaseWeapons.LootModifierWeapon;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class Reaver
extends SwordItem
implements LootModifierWeapon {
    private final List<ComboValues> basicInfectedList;
    private final List<ComboValues> evolvedList;
    private final List<ComboValues> hyperList;
    private final List<ComboValues> organoidList;
    private final List<ComboValues> calamityList;
    private static final Tier PCI_TIER = new Tier(){

        public int getUses() {
            return (Integer)SConfig.SERVER.reaver_durability.get();
        }

        public float getSpeed() {
            return -1.0f;
        }

        public float getAttackDamageBonus() {
            return (Integer)SConfig.SERVER.reaver_damage.get() - 1;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
        }

        public int getEnchantmentValue() {
            return 3;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Sitems.COMPOUND_PLATE.get()});
        }
    };

    public Reaver() {
        super(PCI_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)PCI_TIER, (int)0, (float)-1.0f)));
        Sitems.TECHNOLOGICAL_ITEMS.add((Item)this);
        this.basicInfectedList = this.calculateMap((List)SConfig.SERVER.reaver_loot.get());
        this.evolvedList = this.calculateMap((List)SConfig.SERVER.reaver_loot1.get());
        this.hyperList = this.calculateMap((List)SConfig.SERVER.reaver_loot2.get());
        this.organoidList = this.calculateMap((List)SConfig.SERVER.reaver_loot3.get());
        this.calamityList = this.calculateMap((List)SConfig.SERVER.reaver_loot4.get());
    }

    public List<ComboValues> calculateMap(List<? extends String> list) {
        ArrayList<ComboValues> values = new ArrayList<ComboValues>();
        for (String string : list) {
            String[] s = string.split("\\|");
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)s[0]));
            int value = Integer.parseInt(s[1]);
            if (value == 0) continue;
            ItemStack stack = new ItemStack((ItemLike)item);
            ComboValues comboValues = new ComboValues(stack, value);
            values.add(comboValues);
        }
        return values;
    }

    @Override
    public int getLootingLevel() {
        return 3;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity livingEntity, LivingEntity victim) {
        LivingEntity livingEntity2 = livingEntity;
        Objects.requireNonNull(livingEntity2);
        LivingEntity livingEntity3 = livingEntity2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Calamity.class, Organoid.class, Hyper.class, EvolvedInfected.class, Infected.class}, (Object)livingEntity3, n)) {
            case 0 -> {
                Calamity calamity = (Calamity)livingEntity3;
                yield this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.calamityList));
            }
            case 1 -> {
                Organoid organoid = (Organoid)livingEntity3;
                yield this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.organoidList));
            }
            case 2 -> {
                Hyper hyper = (Hyper)livingEntity3;
                yield this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.hyperList));
            }
            case 3 -> {
                EvolvedInfected evolvedInfected = (EvolvedInfected)livingEntity3;
                yield this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.evolvedList));
            }
            case 4 -> {
                Infected infected = (Infected)livingEntity3;
                yield this.shaveLoot(stack, livingEntity, victim, this.getRandomFromList(this.basicInfectedList));
            }
            default -> super.hurtEnemy(stack, livingEntity, victim);
        };
    }

    public ComboValues getRandomFromList(List<ComboValues> values) {
        RandomSource source = RandomSource.create();
        return values.get(source.nextInt(values.size()));
    }

    public boolean shaveLoot(ItemStack stack, LivingEntity livingEntity, LivingEntity victim, ComboValues values) {
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.getOnPos();
        if (!level.isClientSide && values != null && Math.random() < (double)values.value.intValue() * 0.01) {
            ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), values.stack);
            level.addFreshEntity((Entity)item);
            livingEntity.playSound(Ssounds.REAVER_REAVE.get());
        }
        return super.hurtEnemy(stack, livingEntity, victim);
    }

    public record ComboValues(ItemStack stack, Integer value) {
    }
}

