/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.ExtremelySusThings.Package.AdvancementGivingPackage;
import com.Harbinger.Spore.ExtremelySusThings.SporePacketHandler;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Experiment;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.Utility.Illusion;
import com.Harbinger.Spore.Sitems.BaseItem2;
import com.Harbinger.Spore.Sitems.OrganItem;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ScannerItem
extends BaseItem2 {
    public ScannerItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack tool = player.getItemInHand(hand);
        if (!level.isClientSide) {
            LivingEntity victim = this.getScannedEntity(player, level);
            if (victim != null) {
                player.playNotifySound(Ssounds.SCANNER_MOB.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                this.showInfo(tool, victim, player);
            } else {
                player.playNotifySound(Ssounds.SCANNER_EMPTY.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            player.getCooldowns().addCooldown((Item)this, 20);
        }
        return InteractionResultHolder.success((Object)tool);
    }

    @Nullable
    public LivingEntity getScannedEntity(Player player, Level level) {
        AABB hitbox1 = this.getScannerHitBox(player, 32.0);
        List list = level.getEntities((Entity)player, hitbox1, entity -> entity instanceof LivingEntity);
        Iterator var5 = list.iterator();
        double value = Double.MAX_VALUE;
        LivingEntity entity2 = null;
        while (var5.hasNext()) {
            LivingEntity $$3 = (LivingEntity)var5.next();
            if (!(player.distanceToSqr((Entity)$$3) < value)) continue;
            entity2 = $$3;
            value = player.distanceToSqr((Entity)$$3);
        }
        return entity2;
    }

    @Nullable
    public AABB getScannerHitBox(Player player, double range) {
        Vec3 lookVec = player.getLookAngle();
        Vec3 endVec = player.position().add(lookVec.scale(range));
        return new AABB(player.position(), endVec).inflate(1.0);
    }

    public void showInfo(ItemStack stack, LivingEntity entity, Player player) {
        if (!(stack.getItem() instanceof ScannerItem)) {
            return;
        }
        ItemStack offhand = player.getOffhandItem();
        boolean writeToBook = offhand.is(Items.WRITABLE_BOOK);
        ArrayList<String> lines = new ArrayList<String>();
        if (entity instanceof Illusion) {
            this.sendScanMessage(player, lines, "spore.scanner.line.15");
            return;
        }
        entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 40));
        String name = entity.getCustomName() != null ? entity.getCustomName().getString() : Component.translatable((String)"spore.scanner.line.1").getString();
        lines.add("------------------");
        lines.add(Component.translatable((String)"spore.scanner.line.2").getString() + name);
        lines.add(Component.translatable((String)"spore.scanner.line.3").getString() + Component.translatable((String)entity.getType().getDescriptionId()).getString());
        lines.add(Component.translatable((String)"spore.scanner.line.4").getString() + entity.getHealth() + "/" + entity.getMaxHealth());
        this.addExtraInfo(entity, lines);
        String danger = this.showThreatLevel(entity);
        if (danger != null) {
            lines.add("------------------");
            lines.add(Component.translatable((String)"spore.scanner.line.5").getString() + Component.translatable((String)danger).getString());
        }
        this.addDrops(entity, lines);
        if (writeToBook) {
            this.writeLinesToBook(offhand, lines);
        } else {
            for (String line : lines) {
                player.displayClientMessage((Component)Component.literal((String)line), false);
            }
        }
    }

    public String showThreatLevel(LivingEntity living) {
        if (living instanceof Calamity) {
            return "spore.scanner.danger.calamity";
        }
        if (living instanceof Hyper) {
            return "spore.scanner.danger.hyper";
        }
        if (living instanceof EvolvedInfected) {
            return "spore.scanner.danger.evolved";
        }
        if (living instanceof Experiment) {
            return "spore.scanner.danger.experiment";
        }
        if (living instanceof Infected) {
            return "spore.scanner.danger.infected";
        }
        if (living instanceof Organoid) {
            return "spore.scanner.danger.organoid";
        }
        if (living instanceof UtilityEntity) {
            return "spore.scanner.danger.utility";
        }
        return null;
    }

    private void sendScanMessage(Player player, List<String> lines, String key) {
        String msg = Component.translatable((String)key).getString();
        lines.add(msg);
        player.displayClientMessage((Component)Component.literal((String)msg), false);
    }

    private void addExtraInfo(LivingEntity entity, List<String> lines) {
        if (entity instanceof UtilityEntity) {
            UtilityEntity utility = (UtilityEntity)entity;
            if (utility instanceof Infected) {
                Infected infected = (Infected)utility;
                lines.add(Component.translatable((String)"spore.scanner.line.6").getString() + infected.getKills());
                lines.add(Component.translatable((String)"spore.scanner.line.7").getString() + infected.getEvoPoints());
                if (infected.getEvolutionCoolDown() > 0) {
                    lines.add(Component.translatable((String)"spore.scanner.line.8").getString() + infected.getEvolutionCoolDown() + "/" + String.valueOf(SConfig.SERVER.evolution_age_human.get()));
                }
                if (infected.getHunger() > 0) {
                    lines.add(Component.translatable((String)"spore.scanner.line.9").getString() + infected.getHunger() + "/" + String.valueOf(SConfig.SERVER.hunger.get()));
                }
                lines.add(Component.translatable((String)"spore.scanner.line.10").getString() + infected.getLinked());
            }
            if (utility.getMutation() != null) {
                lines.add(Component.translatable((String)utility.getMutation()).getString());
            }
            if (utility instanceof Scamper) {
                Scamper scamper = (Scamper)utility;
                lines.add(Component.translatable((String)"spore.scanner.line.scamper").getString() + scamper.getAge() + "/" + String.valueOf(SConfig.SERVER.scamper_age.get()));
            }
        }
    }

    private void addDrops(LivingEntity living, List<String> lines) {
        List<? extends String> itemDrops = null;
        if (living instanceof UtilityEntity) {
            UtilityEntity infected = (UtilityEntity)living;
            itemDrops = infected.getDropList();
        }
        if (itemDrops == null || itemDrops.isEmpty()) {
            lines.add(Component.translatable((String)"spore.scanner.line.13").getString());
        } else {
            lines.add("------------------");
            lines.add(Component.translatable((String)"spore.scanner.line.14").getString());
            for (String string : itemDrops) {
                String[] split = string.split("\\|");
                Item item = Utilities.tryToCreateStack(ResourceLocation.parse((String)split[0])).getItem();
                lines.add(Component.translatable((String)item.getDescriptionId()).getString());
            }
        }
    }

    private void writeLinesToBook(ItemStack bookStack, List<String> lines) {
        if (!bookStack.is(Items.WRITABLE_BOOK)) {
            return;
        }
        List<String> pages = new ArrayList<String>();
        StringBuilder currentPage = new StringBuilder();
        for (String line : lines) {
            if (currentPage.length() + line.length() + 1 > 256) {
                pages.add(currentPage.toString());
                currentPage = new StringBuilder();
            }
            currentPage.append(line).append("\n");
        }
        if (!currentPage.isEmpty()) {
            pages.add(currentPage.toString());
        }
        if (pages.size() > 50) {
            pages = pages.subList(pages.size() - 50, pages.size());
        }
        WritableBookContent content = new WritableBookContent(pages.stream().map(Filterable::passThrough).toList());
        bookStack.set(DataComponents.WRITABLE_BOOK_CONTENT, (Object)content);
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        ItemStack itemStack = slot.getItem();
        Item item = itemStack.getItem();
        if (item instanceof OrganItem) {
            OrganItem organItem = (OrganItem)item;
            if (clickAction == ClickAction.SECONDARY) {
                player.playNotifySound(Ssounds.SCANNER_ITEM.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                SporePacketHandler.sendToServer(new AdvancementGivingPackage(organItem.getAdvancementIds(), player.getId()));
                return true;
            }
        }
        return false;
    }
}

