/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Client.AnimationTrackers.SGAnimationTracker;
import com.Harbinger.Spore.Client.AnimationTrackers.SGReloadAnimationTracker;
import com.Harbinger.Spore.Sentities.Projectile.SyringeProjectile;
import com.Harbinger.Spore.Sitems.Agents.ArmorSyringe;
import com.Harbinger.Spore.Sitems.Agents.WeaponSyringe;
import com.Harbinger.Spore.Sitems.BaseItem2;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SdataComponents;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class SyringeGun
extends BaseItem2
implements CustomModelArmorData {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"spore:textures/item/syringe_gun.png");
    public static final List<Item> AMMO = List.of((Item)Sitems.SYRINGE.get(), (Item)Sitems.VAMPIRIC_SYRINGE.get(), (Item)Sitems.CALCIFIED_SYRINGE.get(), (Item)Sitems.BEZERK_SYRINGE.get(), (Item)Sitems.TOXIC_SYRINGE.get(), (Item)Sitems.ROTTEN_SYRINGE.get(), (Item)Sitems.REINFORCED_SYRINGE.get(), (Item)Sitems.SKELETAL_SYRINGE.get(), (Item)Sitems.DROWNED_SYRINGE.get(), (Item)Sitems.CHARRED_SYRINGE.get());

    public SyringeGun() {
        super(new Item.Properties().stacksTo(1).durability(((Integer)SConfig.SERVER.syringe_durability.get()).intValue()).component(SdataComponents.CHAMBER.get(), (Object)0).component(SdataComponents.RELOAD_TIMER.get(), (Object)0).component(SdataComponents.SHOOT_COOLDOWN.get(), (Object)0).component(SdataComponents.RELOADING.get(), (Object)false));
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return TEXTURE;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    private boolean isValidAmmo(ItemStack stack) {
        return !stack.isEmpty() && AMMO.contains(stack.getItem());
    }

    private NonNullList<ItemStack> getMagazine(ItemStack gun) {
        ItemContainerContents contents = (ItemContainerContents)gun.get(DataComponents.CONTAINER);
        if (contents != null) {
            NonNullList magazine = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
            List items = contents.stream().toList();
            for (int i = 0; i < Math.min(items.size(), 4); ++i) {
                magazine.set(i, (Object)((ItemStack)items.get(i)));
            }
            return magazine;
        }
        return NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    }

    public NonNullList<Integer> getClip(ItemStack gun) {
        NonNullList clip = NonNullList.withSize((int)4, (Object)0);
        NonNullList<ItemStack> magazine = this.getMagazine(gun);
        for (int i = 0; i < magazine.size(); ++i) {
            ItemStack ammo = (ItemStack)magazine.get(i);
            if (ammo.isEmpty()) continue;
            clip.set(i, (Object)this.encodeColors(ammo));
        }
        return clip;
    }

    private void saveMagazine(ItemStack gun, NonNullList<ItemStack> magazine) {
        gun.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(magazine));
    }

    public void setMagazine(ItemStack gun, ItemStack ammo, int slot) {
        NonNullList<ItemStack> magazine = this.getMagazine(gun);
        if (this.isValidAmmo(ammo)) {
            magazine.set(slot, (Object)ammo.copy());
        }
        this.saveMagazine(gun, magazine);
    }

    public void removeMagazine(ItemStack gun, int slot) {
        NonNullList<ItemStack> magazine = this.getMagazine(gun);
        magazine.set(slot, (Object)ItemStack.EMPTY);
        this.saveMagazine(gun, magazine);
    }

    private int encodeColors(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.getItem().equals(Sitems.SYRINGE.get())) {
            return -1;
        }
        Item item = stack.getItem();
        if (item instanceof WeaponSyringe) {
            WeaponSyringe w = (WeaponSyringe)item;
            return w.getColor();
        }
        item = stack.getItem();
        if (item instanceof ArmorSyringe) {
            ArmorSyringe a = (ArmorSyringe)item;
            return a.getColor();
        }
        return 0;
    }

    private int getCurrentChamber(ItemStack gun) {
        return (Integer)gun.getOrDefault(SdataComponents.CHAMBER, (Object)0);
    }

    private void setCurrentChamber(ItemStack gun, int value) {
        gun.set(SdataComponents.CHAMBER, (Object)value);
    }

    private int getReloadTimer(ItemStack gun) {
        return (Integer)gun.getOrDefault(SdataComponents.RELOAD_TIMER.get(), (Object)0);
    }

    private void setReloadTimer(ItemStack gun, int value) {
        gun.set(SdataComponents.RELOAD_TIMER.get(), (Object)value);
    }

    private boolean isReloading(ItemStack gun) {
        return (Boolean)gun.getOrDefault(SdataComponents.RELOADING, (Object)false);
    }

    private void setReloading(ItemStack gun, boolean value) {
        gun.set(SdataComponents.RELOADING, (Object)value);
    }

    private int getShootCooldown(ItemStack gun) {
        return (Integer)gun.getOrDefault(SdataComponents.SHOOT_COOLDOWN.get(), (Object)0);
    }

    private void setShootCooldown(ItemStack gun, int value) {
        gun.set(SdataComponents.SHOOT_COOLDOWN.get(), (Object)value);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        boolean inHand;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean bl = inHand = player.getMainHandItem() == stack || player.getOffhandItem() == stack;
        if (inHand && this.isReloading(stack)) {
            if (this.getReloadTimer(stack) == 5) {
                player.playNotifySound(Ssounds.SYRINGE_SPIN.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
            }
            if (this.getReloadTimer(stack) > 0) {
                this.setReloadTimer(stack, this.getReloadTimer(stack) - 1);
            } else {
                this.reloadOne(stack, player);
                this.setReloadTimer(stack, 10);
            }
        }
        if (this.getShootCooldown(stack) > 0) {
            if (this.getShootCooldown(stack) == 5 && level.isClientSide) {
                int chamber = this.getCurrentChamber(stack);
                player.playNotifySound(Ssounds.SYRINGE_SPIN.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
                SGReloadAnimationTracker.triggerRotationToChamber(player, chamber, 10);
            }
            this.setShootCooldown(stack, this.getShootCooldown(stack) - 1);
        }
    }

    public void startReload(ItemStack stack) {
        this.setReloading(stack, true);
        this.setReloadTimer(stack, 10);
    }

    private void reloadOne(ItemStack gun, Player player) {
        NonNullList<ItemStack> magazine = this.getMagazine(gun);
        for (int i = 0; i < magazine.size(); ++i) {
            if (!((ItemStack)magazine.get(i)).isEmpty()) continue;
            ItemStack ammo = this.findAmmo(player);
            if (!ammo.isEmpty()) {
                if (player.level().isClientSide) {
                    SGReloadAnimationTracker.triggerRotationToChamber(player, i, 10);
                    player.playNotifySound(Ssounds.SYRINGE_RELOAD.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
                } else {
                    ItemStack taken = ammo.split(1);
                    this.setMagazine(gun, taken, i);
                }
            } else {
                this.setReloading(gun, false);
                break;
            }
            return;
        }
        this.setReloading(gun, false);
    }

    private ItemStack findAmmo(Player player) {
        ItemStack offhand = player.getOffhandItem();
        if (this.isValidAmmo(offhand)) {
            return offhand;
        }
        if (player.getAbilities().instabuild) {
            return new ItemStack((ItemLike)Sitems.SYRINGE.get());
        }
        for (ItemStack invStack : player.getInventory().items) {
            if (!this.isValidAmmo(invStack)) continue;
            return invStack;
        }
        return ItemStack.EMPTY;
    }

    public boolean shoot(ItemStack gun, Player player, Level level, InteractionHand hand) {
        int chamber;
        if (this.getShootCooldown(gun) > 0) {
            return false;
        }
        NonNullList<ItemStack> magazine = this.getMagazine(gun);
        ItemStack ammo = (ItemStack)magazine.get(chamber = this.getCurrentChamber(gun));
        if (!ammo.isEmpty()) {
            if (!level.isClientSide) {
                int enchantment = EnchantmentHelper.getItemEnchantmentLevel(Senchantments.getEnchantment((LevelAccessor)player.level(), (ResourceKey<Enchantment>)Enchantments.POWER), (ItemStack)gun);
                float power = enchantment > 0 ? (float)enchantment * 1.5f : 0.0f;
                SyringeProjectile arrow = new SyringeProjectile(level, (LivingEntity)player, (float)((Integer)SConfig.SERVER.syringe_damage.get()).intValue() + power, ammo);
                Vec3 vec3 = new Vec3(0.0, 0.0, hand == InteractionHand.MAIN_HAND ? 0.2 : -0.2).yRot(-player.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
                arrow.moveTo(player.position().add(vec3.x, 1.4, vec3.z));
                arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 1.0f);
                level.addFreshEntity((Entity)arrow);
                player.playNotifySound(Ssounds.SYRINGE_SHOOT.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
            } else {
                SGAnimationTracker.trigger(player);
            }
            this.removeMagazine(gun, chamber);
            this.setCurrentChamber(gun, (chamber + 1) % 4);
            this.setShootCooldown(gun, 10);
            return true;
        }
        player.playNotifySound(SoundEvents.LEVER_CLICK, SoundSource.AMBIENT, 1.0f, 1.0f);
        this.setCurrentChamber(gun, (chamber + 1) % 4);
        this.triggerMagazineRotation(chamber, player);
        return false;
    }

    private void triggerMagazineRotation(int chamber, Player player) {
        if (player.level().isClientSide) {
            SGReloadAnimationTracker.triggerRotationToChamber(player, chamber, 10);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack gun = player.getItemInHand(hand);
        player.startUsingItem(hand);
        if (player.isShiftKeyDown()) {
            if (!this.isReloading(gun)) {
                this.startReload(gun);
            }
            return InteractionResultHolder.consume((Object)gun);
        }
        if (this.getShootCooldown(gun) > 0 || this.isReloading(gun)) {
            return InteractionResultHolder.fail((Object)gun);
        }
        if (this.shoot(gun, player, level, hand)) {
            gun.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return InteractionResultHolder.consume((Object)gun);
        }
        this.startReload(gun);
        return InteractionResultHolder.fail((Object)gun);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        for (ItemStack ammo : this.getMagazine(stack)) {
            if (ammo.isEmpty()) continue;
            tooltipComponents.add(ammo.copy().getDisplayName());
        }
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack itemStack) {
        return itemStack.is((Item)Sitems.CIRCUIT_BOARD.get());
    }
}

