/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeBaseArmor;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sitems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;

public class UpgradedInfectedExoskeleton
extends SporeBaseArmor
implements CustomModelArmorData {
    private static final ResourceLocation location = ResourceLocation.parse((String)"spore:textures/armor/living_armor_set_mk.png");
    private final Holder<MobEffect> effectHolder = Seffects.SYMBIOSIS;

    public UpgradedInfectedExoskeleton(ArmorItem.Type type) {
        super(type, new int[]{(Integer)SConfig.SERVER.boots_up_durability.get(), (Integer)SConfig.SERVER.pants_up_durability.get(), (Integer)SConfig.SERVER.chestplate_up_durability.get(), (Integer)SConfig.SERVER.helmet_up_durability.get()}, new int[]{(Integer)SConfig.SERVER.boots_up_protection.get(), (Integer)SConfig.SERVER.pants_up_protection.get(), (Integer)SConfig.SERVER.chestplate_up_protection.get(), (Integer)SConfig.SERVER.helmet_protection.get()}, (Integer)SConfig.SERVER.armor_toughness.get() + 2, ((Integer)SConfig.SERVER.knockback_resistance.get()).intValue());
    }

    @Override
    public void tickArmor(Player living, Level level) {
        this.geteffect((LivingEntity)living);
    }

    public void geteffect(LivingEntity entity) {
        MobEffectInstance instance = entity.getEffect(this.effectHolder);
        if (entity.tickCount % 20 == 0) {
            int val = this.getEffectMod(entity);
            if (instance != null && instance.getDuration() < 60 && val != -1) {
                entity.addEffect(new MobEffectInstance(this.effectHolder, 200, val, false, false));
            }
            if (instance == null && val != -1) {
                entity.addEffect(new MobEffectInstance(this.effectHolder, 200, val, false, false));
            }
        }
    }

    private int getEffectMod(LivingEntity living) {
        int i = 0;
        ItemStack helmet = living.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chest = living.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack legs = living.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack feet = living.getItemBySlot(EquipmentSlot.FEET);
        if (helmet.equals(ItemStack.EMPTY) || chest.equals(ItemStack.EMPTY) || legs.equals(ItemStack.EMPTY) || feet.equals(ItemStack.EMPTY)) {
            return -1;
        }
        if (helmet.getItem().equals(Sitems.INF_UP_HELMET.get())) {
            i += 2;
        }
        if (chest.getItem().equals(Sitems.INF_UP_CHESTPLATE.get())) {
            i += 2;
        }
        if (legs.getItem().equals(Sitems.INF_UP_PANTS.get())) {
            i += 2;
        }
        if (feet.getItem().equals(Sitems.INF_UP_BOOTS.get())) {
            i += 2;
        }
        if (helmet.getItem().equals(Sitems.INF_HELMET.get())) {
            ++i;
        }
        if (chest.getItem().equals(Sitems.INF_CHEST.get())) {
            ++i;
        }
        if (legs.getItem().equals(Sitems.INF_PANTS.get())) {
            ++i;
        }
        if (feet.getItem().equals(Sitems.INF_BOOTS.get())) {
            ++i;
        }
        return i < 4 ? -1 : (i > 7 ? 1 : 0);
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return location;
    }

    public static class InfectedUpBoots
    extends UpgradedInfectedExoskeleton {
        public InfectedUpBoots() {
            super(ArmorItem.Type.BOOTS);
        }

        @Override
        public ItemAttributeModifiers getDynamicAttributeModifiers(ItemStack stack) {
            EquipmentSlot slot = this.type.getSlot();
            int index = this.type.getSlot().getIndex();
            double baseArmor = this.calculateTrueDefense(stack, this.protection[slot.getIndex()]) + this.modifyProtection(stack, this.protection[slot.getIndex()]);
            double baseToughness = this.calculateTrueToughness(stack, this.toughness) + this.modifyToughness(stack, this.toughness);
            double knockbackRes = (double)this.knockback + this.modifyKnockbackResistance(stack, this.knockback);
            double underwaterSpeed = this.getVariant(stack) == SporeArmorMutations.DROWNED ? 0.75 : 0.5;
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder().add(Attributes.ARMOR, new AttributeModifier(BASE_ARMOR_ID[index], baseArmor, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot)).add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(BASE_TOUGHNESS_ID[index], baseToughness, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot)).add(NeoForgeMod.SWIM_SPEED, new AttributeModifier(BASE_SWIM_ID[index], underwaterSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
            if (knockbackRes > 0.0) {
                builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(BASE_KNOCKBACK_ID[index], knockbackRes * (double)0.1f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
            }
            if (this.getVariant(stack) == SporeArmorMutations.REINFORCED || this.getVariant(stack) == SporeArmorMutations.SKELETAL) {
                double speedMod = this.getVariant(stack) == SporeArmorMutations.REINFORCED ? -0.01 : 0.01;
                builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(BASE_SPEED_ID[index], speedMod, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
            }
            return builder.build();
        }
    }

    public static class InfectedUpPants
    extends UpgradedInfectedExoskeleton {
        public InfectedUpPants() {
            super(ArmorItem.Type.LEGGINGS);
        }

        @Override
        public ItemAttributeModifiers getDynamicAttributeModifiers(ItemStack stack) {
            EquipmentSlot slot = this.type.getSlot();
            int index = this.type.getSlot().getIndex();
            double baseArmor = this.calculateTrueDefense(stack, this.protection[index]) + this.modifyProtection(stack, this.protection[index]);
            double baseToughness = this.calculateTrueToughness(stack, this.toughness) + this.modifyToughness(stack, this.toughness);
            double knockbackRes = (double)this.knockback + this.modifyKnockbackResistance(stack, this.knockback);
            float speed = this.getVariant(stack) == SporeArmorMutations.REINFORCED || this.getVariant(stack) == SporeArmorMutations.SKELETAL ? (this.getVariant(stack) == SporeArmorMutations.REINFORCED ? -0.01f : 0.01f) : 0.0f;
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder().add(Attributes.ARMOR, new AttributeModifier(BASE_ARMOR_ID[index], baseArmor, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot)).add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(BASE_TOUGHNESS_ID[index], baseToughness, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot)).add(Attributes.STEP_HEIGHT, new AttributeModifier(BASE_STEP_ID[index], 0.75, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot)).add(Attributes.MOVEMENT_SPEED, new AttributeModifier(BASE_SPEED_ID[index], 0.02 + (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
            if (knockbackRes > 0.0) {
                builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(BASE_KNOCKBACK_ID[index], knockbackRes * (double)0.1f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
            }
            if (this.getVariant(stack) == SporeArmorMutations.DROWNED) {
                builder.add(NeoForgeMod.SWIM_SPEED, new AttributeModifier(BASE_SWIM_ID[index], 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
            }
            if (this.getVariant(stack) == SporeArmorMutations.REINFORCED || this.getVariant(stack) == SporeArmorMutations.SKELETAL) {
                double speedMod = this.getVariant(stack) == SporeArmorMutations.REINFORCED ? -0.01 : 0.01;
                builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(BASE_SPEED_ID[index], speedMod, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
            }
            return builder.build();
        }

        @Override
        public void tickArmor(Player player, Level level) {
            super.tickArmor(player, level);
            if (player.tickCount % 30 == 0) {
                player.addEffect(new MobEffectInstance(MobEffects.JUMP, 40, 1, false, false));
            }
        }
    }

    public static class InfectedUpHelmet
    extends UpgradedInfectedExoskeleton {
        public InfectedUpHelmet() {
            super(ArmorItem.Type.HELMET);
        }

        @Override
        public void tickArmor(Player player, Level level) {
            super.tickArmor(player, level);
            if (player.tickCount % 10 == 0 && player.isCrouching()) {
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 600, 0, false, false));
            }
            if (player.tickCount % 20 == 0 && player.isInWater()) {
                player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 200, 0, false, false));
            }
        }
    }

    public static class InfectedUpChestplate
    extends UpgradedInfectedExoskeleton {
        public InfectedUpChestplate() {
            super(ArmorItem.Type.CHESTPLATE);
        }

        public static boolean isFlyEnabled(ItemStack stack) {
            return stack.getDamageValue() < stack.getMaxDamage() - 10;
        }

        public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
            return InfectedUpChestplate.isFlyEnabled(stack);
        }

        public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
            int nextFlightTick;
            if (!entity.level().isClientSide && (nextFlightTick = flightTicks + 1) % 10 == 0) {
                if (nextFlightTick % 20 == 0) {
                    stack.hurtAndBreak(1, entity, EquipmentSlot.CHEST);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.causeFoodExhaustion(0.1f);
                    }
                }
                entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
            }
            return true;
        }

        public int getEnchantmentValue() {
            return 2;
        }

        public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
            super.inventoryTick(stack, level, entity, slotId, isSelected);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            if (living.getItemBySlot(EquipmentSlot.CHEST).equals(stack) && living.horizontalCollision && living.isCrouching()) {
                Vec3 currentMovement = living.getDeltaMovement();
                if (currentMovement.y < 0.15) {
                    Vec3 climbVec = new Vec3(currentMovement.x, 0.15, currentMovement.z);
                    living.setDeltaMovement(climbVec);
                }
            }
        }

        @Override
        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
            super.appendHoverText(stack, context, components, tooltipFlag);
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"item.armor.shift").withStyle(ChatFormatting.DARK_RED));
            } else {
                components.add((Component)Component.translatable((String)"item.armor.normal").withStyle(ChatFormatting.GOLD));
            }
        }
    }
}

