/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sitems.BaseItem;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class VigilEye
extends BaseItem {
    public VigilEye() {
        super(new Item.Properties().stacksTo(1).durability(1).rarity(Rarity.RARE));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack p_40678_) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int value) {
        super.releaseUsing(stack, level, livingEntity, value);
        livingEntity.playSound(Ssounds.VIGIL_EYE_USE.get());
        if (!level.isClientSide) {
            AABB searchbox = livingEntity.getBoundingBox().inflate(128.0);
            List entities = level.getEntities((Entity)livingEntity, searchbox);
            for (Entity entity : entities) {
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || !((living = (LivingEntity)entity) instanceof Infected) && !(living instanceof Organoid) && !(living instanceof Calamity)) continue;
                living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 600, 0));
            }
            stack.hurtAndBreak(1, livingEntity, EquipmentSlot.MAINHAND);
        }
    }
}

