/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Recipes;

import com.Harbinger.Spore.Recipes.EntityContainer;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WombRecipe
implements Recipe<EntityContainer> {
    private final ResourceLocation id;
    private final List<Pair> entityPairs;
    private final String attribute;
    private final ResourceLocation icon;

    public WombRecipe(ResourceLocation id, List<Pair> entityPairs, String attribute, ResourceLocation icon) {
        this.id = id;
        this.entityPairs = entityPairs;
        this.attribute = attribute;
        this.icon = icon;
    }

    public List<Pair> getEntityPairs() {
        return this.entityPairs;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public boolean matches(EntityContainer entityContainer, Level level) {
        if (level.f_46443_) {
            return false;
        }
        EntityType entityType = entityContainer.entity().m_6095_();
        for (Pair pair : this.entityPairs) {
            VariantKeeper keeper;
            Entity entity;
            EntityType expectedType = EntityType.m_20632_((String)pair.entityId()).orElse(null);
            if (expectedType == null || !((entity = entityContainer.entity()) instanceof VariantKeeper ? (keeper = (VariantKeeper)entity).getTypeVariant() == pair.type() && entityType.equals(expectedType) : entityType.equals(expectedType))) continue;
            return true;
        }
        return false;
    }

    public ItemStack assemble(EntityContainer entityContainer, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return WombRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return WombRecipeType.INSTANCE;
    }

    public record Pair(String entityId, int type) {
    }

    public static class WombRecipeSerializer
    implements RecipeSerializer<WombRecipe> {
        public static final WombRecipeSerializer INSTANCE = new WombRecipeSerializer();
        public static final ResourceLocation ID = new ResourceLocation("spore", "assimilation");

        public WombRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            ArrayList<Pair> entityPairs = new ArrayList<Pair>();
            JsonArray entities = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"entities");
            for (int i = 0; i < entities.size(); ++i) {
                JsonObject obj = entities.get(i).getAsJsonObject();
                String entityId = GsonHelper.m_13906_((JsonObject)obj, (String)"entity");
                int type = GsonHelper.m_13927_((JsonObject)obj, (String)"entity_type");
                entityPairs.add(new Pair(entityId, type));
            }
            String attribute = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"attribute");
            ResourceLocation icon = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"icon"));
            return new WombRecipe(resourceLocation, entityPairs, attribute, icon);
        }

        @Nullable
        public WombRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<Pair> entityPairs = new ArrayList<Pair>();
            for (int i = 0; i < size; ++i) {
                String entityId = buf.m_130277_();
                int type = buf.readInt();
                entityPairs.add(new Pair(entityId, type));
            }
            String attribute = buf.m_130277_();
            ResourceLocation icon = buf.m_130281_();
            return new WombRecipe(resourceLocation, entityPairs, attribute, icon);
        }

        public void toNetwork(FriendlyByteBuf buf, WombRecipe recipe) {
            buf.writeInt(recipe.entityPairs.size());
            for (Pair pair : recipe.entityPairs) {
                buf.m_130070_(pair.entityId());
                buf.writeInt(pair.type());
            }
            buf.m_130070_(recipe.attribute);
            buf.m_130085_(recipe.icon);
        }
    }

    public static class WombRecipeType
    implements RecipeType<WombRecipe> {
        public static final WombRecipeType INSTANCE = new WombRecipeType();
        public static final String ID = "assimilation";

        private WombRecipeType() {
        }
    }
}

