/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.SBlockEntities.AnimatedEntity;
import com.Harbinger.Spore.Sentities.Utility.ArenaEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BrainRemnantBlockEntity
extends BlockEntity
implements AnimatedEntity {
    public int ticks;
    public int ticksOnFire = 0;
    private boolean onFire = false;

    public BrainRemnantBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SblockEntities.BRAIN_REMNANTS.get(), pos, state);
    }

    public BrainRemnantBlockEntity(BlockPos pos, BlockState state, boolean value) {
        super((BlockEntityType)SblockEntities.BRAIN_REMNANTS.get(), pos, state);
        this.setOnFire(value);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setOnFire(tag.m_128471_("fire"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("fire", this.isOnFire());
    }

    public boolean isOnFire() {
        return this.onFire;
    }

    public void setOnFire(boolean time) {
        this.onFire = time;
    }

    public static <E extends BrainRemnantBlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, E e) {
        BrainRemnantBlockEntity.tickOnFire(level, pos, state, e);
    }

    public static <E extends BrainRemnantBlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, E e) {
        e.ticks = e.ticks <= 720 ? ++e.ticks : 0;
    }

    public static void tickOnFire(Level level, BlockPos pos, BlockState state, BrainRemnantBlockEntity entity) {
        if (entity.ticksOnFire > 0 && entity.isOnFire()) {
            ++entity.ticksOnFire;
            if (entity.ticksOnFire >= 50) {
                entity.ticksOnFire = 0;
                level.m_7471_(pos, false);
                level.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2.0f, Level.ExplosionInteraction.NONE);
                ArenaEntity arenaEntity = new ArenaEntity((EntityType<? extends PathfinderMob>)((EntityType)Sentities.ARENA_TENDRIL.get()), level);
                arenaEntity.m_6027_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                arenaEntity.tickEmerging();
                arenaEntity.recalculateHosts();
                level.m_7967_((Entity)arenaEntity);
            }
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }
}

