/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.AI;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class ClimberNodeNavigator
extends NodeEvaluator {
    private final Long2ObjectMap<BlockPathTypes> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public Node m_7171_() {
        return this.getStartNode(this.f_77313_.m_20183_());
    }

    public Target m_7568_(double var1, double var3, double var5) {
        return this.m_230615_(this.m_5676_(Mth.m_14107_((double)var1), Mth.m_14107_((double)var3), Mth.m_14107_((double)var5)));
    }

    public void m_6802_() {
        super.m_6802_();
        this.pathTypesByPosCache.clear();
    }

    public int m_6065_(Node[] options, Node current) {
        var ref = new Object(){
            int numOptions = 0;
        };
        for (Direction direction : Direction.values()) {
            this.findNode(current.f_77271_ + direction.m_122429_(), current.f_77272_ + direction.m_122430_(), current.f_77273_ + direction.m_122431_()).filter(node -> this.isNeighborValid((Node)node, current)).ifPresent(newNode -> {
                options[ref.numOptions++] = newNode;
                for (Direction direction2 : (Direction[])Direction.m_235666_().filter(d -> d != direction && d != direction.m_122424_()).toArray(Direction[]::new)) {
                    this.findNode(newNode.f_77271_ + direction2.m_122429_(), newNode.f_77272_ + direction2.m_122430_(), newNode.f_77273_ + direction2.m_122431_()).filter(node -> this.isNeighborValid((Node)node, (Node)newNode)).ifPresent(newerNode -> {
                        options[ref.numOptions++] = newerNode;
                    });
                }
            });
        }
        return ref.numOptions;
    }

    protected boolean isNeighborValid(Node $$0, Node $$1) {
        return !$$0.f_77279_ && ($$0.f_77281_ >= 0.0f || $$1.f_77281_ < 0.0f);
    }

    private Optional<Node> findNode(int x, int y, int z) {
        Node node = null;
        if (!this.nextToClimbable(x, y, z)) {
            return Optional.empty();
        }
        BlockPathTypes pathTypes = this.getCachedBlockType(this.f_77313_, x, y, z);
        float malus = this.f_77313_.m_21439_(pathTypes);
        if (malus >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathTypes, malus);
        }
        return Optional.ofNullable(node);
    }

    private boolean nextToClimbable(int x, int y, int z) {
        for (Direction direction : Direction.values()) {
            BlockPathTypes type = this.getCachedBlockType(this.f_77313_, x + direction.m_122429_(), y + direction.m_122430_(), z + direction.m_122431_());
            if (this.isClimbableType(type)) {
                return true;
            }
            for (Direction direction2 : (Direction[])Direction.m_235666_().filter(d -> d != direction && d != direction.m_122424_()).toArray(Direction[]::new)) {
                BlockPathTypes type2 = this.getCachedBlockType(this.f_77313_, x + direction.m_122429_() + direction2.m_122429_(), y + direction.m_122430_() + direction2.m_122430_(), z + direction.m_122431_() + direction2.m_122431_());
                if (!this.isClimbableType(type2)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isClimbableType(BlockPathTypes type) {
        return type != BlockPathTypes.OPEN && type != BlockPathTypes.WALKABLE;
    }

    private Node getNodeAndUpdateCostToMax(int $$0, int $$1, int $$2, BlockPathTypes $$3, float $$4) {
        Node $$5 = this.m_5676_($$0, $$1, $$2);
        $$5.f_77282_ = $$3;
        $$5.f_77281_ = Math.max($$5.f_77281_, $$4);
        return $$5;
    }

    public BlockPathTypes m_7209_(BlockGetter var1, int var2, int var3, int var4, Mob var5) {
        return WalkNodeEvaluator.m_77604_((BlockGetter)var1, (BlockPos.MutableBlockPos)new BlockPos.MutableBlockPos(var2, var3, var4));
    }

    public BlockPathTypes m_8086_(BlockGetter var1, int var2, int var3, int var4) {
        return WalkNodeEvaluator.m_77604_((BlockGetter)var1, (BlockPos.MutableBlockPos)new BlockPos.MutableBlockPos(var2, var3, var4));
    }

    protected Node getStartNode(BlockPos $$0) {
        Node $$1 = this.m_77349_($$0);
        $$1.f_77282_ = this.getBlockPathType(this.f_77313_, $$1.m_77288_());
        $$1.f_77281_ = this.f_77313_.m_21439_($$1.f_77282_);
        return $$1;
    }

    protected BlockPathTypes getBlockPathType(Mob $$0, BlockPos $$1) {
        return this.getCachedBlockType($$0, $$1.m_123341_(), $$1.m_123342_(), $$1.m_123343_());
    }

    protected BlockPathTypes getCachedBlockType(Mob $$0, int $$1, int $$2, int $$3) {
        return (BlockPathTypes)this.pathTypesByPosCache.computeIfAbsent(BlockPos.m_121882_((int)$$1, (int)$$2, (int)$$3), $$4 -> this.m_7209_((BlockGetter)this.f_77312_, $$1, $$2, $$3, $$0));
    }
}

