/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Fluids;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;

public class BileLiquid
extends FluidType {
    public static final ResourceLocation FLUID_STILL = new ResourceLocation("spore:block/bile_static");
    public static final ResourceLocation FLUID_FLOWING = new ResourceLocation("spore:block/bile_flow");
    public static final ResourceLocation OVERLAY = new ResourceLocation("spore:textures/extra/bile_overlay.png");

    public BileLiquid(FluidType.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return FLUID_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLUID_FLOWING;
            }
        });
    }

    public boolean canSwim(Entity entity) {
        return entity instanceof UtilityEntity || entity instanceof Infected;
    }

    public boolean canExtinguish(Entity entity) {
        return true;
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        if (entity instanceof UtilityEntity || entity instanceof Infected || entity instanceof TrueCalamity) {
            movementVector.m_82490_(1.2);
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.01, 0.0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 0, 40));
            gravity = 0.0;
        } else {
            movementVector.m_82490_((double)0.4f);
            if (entity.f_19797_ % 40 == 0) {
                for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                    entity.m_7292_(instance);
                }
                entity.m_6469_(entity.m_269291_().m_269264_(), 1.0f);
            }
        }
        return super.move(state, entity, movementVector, gravity);
    }

    public static List<MobEffectInstance> bileEffects() {
        ArrayList<MobEffectInstance> values = new ArrayList<MobEffectInstance>();
        values.add(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
        values.add(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
        values.add(new MobEffectInstance(MobEffects.f_19597_, 100, 0));
        values.add(new MobEffectInstance(MobEffects.f_19599_, 200, 0));
        return values;
    }
}

