/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.PullGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.Hyper.HevokerPart;
import com.Harbinger.Spore.Sentities.Utility.HyperClaw;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;

public class Hevoker
extends Hyper {
    private static final EntityDataAccessor<Boolean> DEAD = SynchedEntityData.m_135353_(Hevoker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_ARM = SynchedEntityData.m_135353_(Hevoker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIME_REGROW = SynchedEntityData.m_135353_(Hevoker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final HevokerPart[] subEntities;
    private final HevokerPart totem = new HevokerPart(this, "totem", 0.5f, 0.5f);
    private final HevokerPart arm1 = new HevokerPart(this, "right_arm1", 0.5f, 0.5f);
    private final HevokerPart arm2 = new HevokerPart(this, "right_arm2", 0.5f, 0.5f);
    private final HevokerPart arm3 = new HevokerPart(this, "right_arm3", 0.5f, 0.5f);
    private final HevokerPart arm4 = new HevokerPart(this, "right_arm4", 0.5f, 0.5f);
    private int reviveTimer = 0;
    private int attackAnimationTick;
    private boolean value = true;

    public Hevoker(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.subEntities = new HevokerPart[]{this.totem, this.arm1, this.arm2, this.arm3, this.arm4};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public HevokerPart[] getSubEntities() {
        return this.subEntities;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket p_218825_) {
        super.m_141965_(p_218825_);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("fake_death", this.isFakeDead());
        tag.m_128379_("arm", this.hasArm());
        tag.m_128405_("regrow", this.getTimeRegrow());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFakeDead(tag.m_128471_("fake_death"));
        this.setArm(tag.m_128471_("arm"));
        this.setTimeRegrow(tag.m_128451_("regrow"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEAD, (Object)false);
        this.f_19804_.m_135372_(HAS_ARM, (Object)true);
        this.f_19804_.m_135372_(TIME_REGROW, (Object)0);
    }

    public boolean isFakeDead() {
        return (Boolean)this.f_19804_.m_135370_(DEAD);
    }

    public void setFakeDead(boolean value) {
        this.f_19804_.m_135381_(DEAD, (Object)value);
    }

    public boolean hasArm() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ARM);
    }

    public void setArm(boolean value) {
        this.f_19804_.m_135381_(HAS_ARM, (Object)value);
    }

    public void setTimeRegrow(int value) {
        this.f_19804_.m_135381_(TIME_REGROW, (Object)value);
    }

    public void tickTimeRegrow() {
        this.f_19804_.m_135381_(TIME_REGROW, (Object)((Integer)this.f_19804_.m_135370_(TIME_REGROW) + 1));
    }

    public int getTimeRegrow() {
        return (Integer)this.f_19804_.m_135370_(TIME_REGROW);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.reviveTimer > 0) {
            if (this.reviveTimer == 1) {
                this.reviveBody();
            }
            --this.reviveTimer;
        }
        if (this.isFakeDead()) {
            this.m_7601_(Blocks.f_50016_.m_49966_(), new Vec3(0.0, 1.0, 0.0));
        }
        if (!this.hasArm() && this.f_19797_ % 20 == 0) {
            this.tickTimeRegrow();
            if (this.getTimeRegrow() >= 300) {
                this.setArm(true);
                this.setTimeRegrow(0);
            }
        }
    }

    public void reviveBody() {
        float hp = (float)((Double)SConfig.SERVER.hevoker_hp.get() * (Double)SConfig.SERVER.global_health.get() / 4.0);
        this.m_21153_(hp);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42747_);
        DamageSource source = this.m_21225_();
        if (source != null) {
            ForgeHooks.onLivingUseTotem((LivingEntity)this, (DamageSource)source, (ItemStack)stack, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        this.setFakeDead(false);
        this.m_216990_(SoundEvents.f_12513_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 800, 1));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.hevoker_loot.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.hevoker_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.hevoker_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.hevoker_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    private boolean switchy() {
        LivingEntity living = this.m_5448_();
        if (this.isFakeDead()) {
            return false;
        }
        if (living != null && this.canSee((Entity)living)) {
            double ze = this.m_20280_((Entity)living);
            return ze > 200.0 && ze < 600.0 && (Boolean)this.f_19804_.m_135370_(HAS_ARM) != false;
        }
        return false;
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(3, (Goal)new AOEMeleeAttackGoal((PathfinderMob)this, 1.2, true, 1.2, 3.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            public boolean m_8036_() {
                if (Hevoker.this.isFakeDead()) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            protected void checkAndPerformAttack(LivingEntity entity, double p_25558_) {
                if (!Hevoker.this.isFakeDead()) {
                    super.checkAndPerformAttack(entity, p_25558_);
                }
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                if (Hevoker.this.isFakeDead()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new PullGoal((Mob)this, 32.0, 8.0){

            @Override
            public boolean m_8036_() {
                return Hevoker.this.switchy();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                if (Hevoker.this.isFakeDead()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
    }

    public void m_7822_(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.m_7822_(value);
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(entity);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.moveHitBoxesAround();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean m_20147_() {
        return super.m_20147_() || this.isFakeDead();
    }

    public boolean m_6097_() {
        if (this.isFakeDead()) {
            return false;
        }
        return super.m_6097_();
    }

    public boolean canSee(Entity entity) {
        if (entity.m_9236_() != this.m_9236_()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.f_146808_ || source.m_276093_(DamageTypes.f_268444_) || amount > 100.0f) {
            return super.m_6469_(source, amount);
        }
        if (this.isFakeDead()) {
            return false;
        }
        if (!this.isFakeDead() && amount > this.m_21223_() && !this.f_146808_) {
            this.setFakeDead(true);
            this.m_21153_(1.0f);
            this.reviveTimer = 200;
            return true;
        }
        if (Math.random() < 0.2) {
            this.performTelekineticThrow();
        }
        return super.m_6469_(source, amount);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DEAD.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isFakeDead()) {
            return super.m_6972_(pose).m_20390_(2.2f, 0.25f);
        }
        return super.m_6972_(pose);
    }

    public boolean hurt(HevokerPart hevokerArm, DamageSource source, float amount) {
        if (Math.random() < 0.2 && this.hasArm() && !this.m_9236_().f_46443_ && (hevokerArm == this.arm1 || hevokerArm == this.arm2 || hevokerArm == this.arm3 || hevokerArm == this.arm4)) {
            this.SummonClaw();
            this.setArm(false);
        }
        if (this.isFakeDead() && hevokerArm == this.totem) {
            return this.m_6469_(source, Float.MAX_VALUE);
        }
        return this.m_6469_(source, amount);
    }

    protected void tickPart(HevokerPart part, Vec3 vec3i) {
        Vec3 vec3 = vec3i.m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        part.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
    }

    public void SummonClaw() {
        Vec3 vec3 = new Vec3(0.3, 0.5, -0.8).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        HyperClaw claw = new HyperClaw((EntityType<? extends PathfinderMob>)((EntityType)Sentities.HEVOKER_ARM.get()), this.m_9236_());
        claw.m_6027_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
        this.m_9236_().m_7967_((Entity)claw);
        this.m_216990_((SoundEvent)Ssounds.LIMB_SLASH.get());
    }

    public void moveHitBoxesAround() {
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
        }
        this.tickPart(this.arm1, this.isFakeDead() ? new Vec3(0.0, 0.0, -0.5) : new Vec3(0.3, 0.5, -0.8));
        this.tickPart(this.arm2, this.isFakeDead() ? new Vec3(0.5, 0.0, -1.0) : new Vec3(0.3, 1.0, -0.8));
        this.tickPart(this.arm3, this.isFakeDead() ? new Vec3(0.6, 0.0, -1.5) : new Vec3(0.3, 1.5, -0.8));
        this.tickPart(this.arm4, this.isFakeDead() ? new Vec3(0.6, 0.0, -2.0) : new Vec3(0.3, 2.0, -0.8));
        this.tickPart(this.totem, this.isFakeDead() ? new Vec3(-0.2, 0.5, 0.0) : new Vec3(0.5, 1.8, 0.0));
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].f_19854_ = avec3[l].f_82479_;
            this.subEntities[l].f_19855_ = avec3[l].f_82480_;
            this.subEntities[l].f_19856_ = avec3[l].f_82481_;
            this.subEntities[l].f_19790_ = avec3[l].f_82479_;
            this.subEntities[l].f_19791_ = avec3[l].f_82480_;
            this.subEntities[l].f_19792_ = avec3[l].f_82481_;
        }
    }

    public InteractionResult interact(HevokerPart hevokerPart, Player player, InteractionHand hand) {
        if (this.isFakeDead() && hevokerPart == this.totem && this.reviveTimer > 20 && this.value) {
            this.m_6469_(this.m_269291_().m_269075_(player), Float.MAX_VALUE);
            this.createTotem();
            this.value = false;
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void createTotem() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42747_);
        ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)entity);
    }

    protected SoundEvent m_7515_() {
        return this.isFakeDead() ? null : (SoundEvent)Ssounds.HEVOKER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    public void performTelekineticThrow() {
        AABB aabb = this.m_20191_().m_82400_(8.0);
        List entities = this.m_9236_().m_6249_((Entity)this, aabb, entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(living = (LivingEntity)entity);
        });
        if (entities.size() > 1) {
            for (Entity entity2 : entities) {
                entity2.m_20256_(entity2.m_20184_().m_82520_(0.0, 1.0, 0.0));
            }
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
    }
}

