/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.BufferAI;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.FoliageSpread;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GastGeber
extends EvolvedInfected
implements FoliageSpread {
    public static final EntityDataAccessor<BlockPos> SPREAD_POINT = SynchedEntityData.m_135353_(GastGeber.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Integer> TIME_ROOTED = SynchedEntityData.m_135353_(GastGeber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> AGGRESSION = SynchedEntityData.m_135353_(GastGeber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SPREAD_INTERVAL = SynchedEntityData.m_135353_(GastGeber.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int maxCounter = (Integer)SConfig.SERVER.gastgeber_spread_cooldown.get();
    public final int maxRootTime;

    public GastGeber(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.maxRootTime = (Integer)SConfig.SERVER.gastgeber_root_time.get();
    }

    @Override
    public boolean m_6785_(double p_21542_) {
        return false;
    }

    @Override
    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos);
        return this.f_19797_ % 20 == 0 && value > 0.0f && value <= (float)this.getBreaking();
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.experiment_bd.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.gastgeber_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.gastgeber_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.gastgeber_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22282_, 3.0);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.gastgaber_loot.get();
    }

    @Override
    public boolean canStarve() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.GAST_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    @Override
    protected void addRegularGoals() {
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true){

            public boolean m_8036_() {
                return super.m_8036_() && GastGeber.this.getAggression() > 0;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new FindPlaceToInfect(this));
        this.f_21345_.m_25352_(6, (Goal)new FloatDiveGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new BufferAI(this));
    }

    public boolean isRooted() {
        return this.getTimeRooted() > 0;
    }

    public BlockPos getRootPoint() {
        return (BlockPos)this.f_19804_.m_135370_(SPREAD_POINT);
    }

    public void setRootPoint(BlockPos pos) {
        this.f_19804_.m_135381_(SPREAD_POINT, (Object)pos);
    }

    public int getTimeRooted() {
        return (Integer)this.f_19804_.m_135370_(TIME_ROOTED);
    }

    public void setTimeRooted(int value) {
        this.f_19804_.m_135381_(TIME_ROOTED, (Object)value);
    }

    public int getAggression() {
        return (Integer)this.f_19804_.m_135370_(AGGRESSION);
    }

    public void setAggression(int value) {
        this.f_19804_.m_135381_(AGGRESSION, (Object)value);
    }

    public int getSpreadInterval() {
        return (Integer)this.f_19804_.m_135370_(SPREAD_INTERVAL);
    }

    public void setSpreadInterval(int value) {
        this.f_19804_.m_135381_(SPREAD_INTERVAL, (Object)value);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPREAD_POINT, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(TIME_ROOTED, (Object)0);
        this.f_19804_.m_135372_(AGGRESSION, (Object)0);
        this.f_19804_.m_135372_(SPREAD_INTERVAL, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        int x = tag.m_128451_("spreadX");
        int y = tag.m_128451_("spreadY");
        int z = tag.m_128451_("spreadZ");
        this.setRootPoint(new BlockPos(x, y, z));
        this.setTimeRooted(tag.m_128451_("root"));
        this.setAggression(tag.m_128451_("anger"));
        this.setSpreadInterval(tag.m_128451_("spread"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("spreadX", this.getRootPoint().m_123341_());
        tag.m_128405_("spreadY", this.getRootPoint().m_123342_());
        tag.m_128405_("spreadZ", this.getRootPoint().m_123343_());
        tag.m_128405_("root", this.getTimeRooted());
        tag.m_128405_("anger", this.getAggression());
        tag.m_128405_("spread", this.getSpreadInterval());
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof LivingEntity) {
            this.setAggression(30);
            this.setTimeRooted(0);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 120, 2));
        }
        return super.m_7327_(entity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isRooted() && this.m_20096_()) {
            this.m_7601_(Blocks.f_50016_.m_49966_(), new Vec3(0.0, 1.0, 0.0));
        }
        if (this.f_19797_ % 20 == 0 && this.m_6084_()) {
            if (this.getAggression() > 0) {
                this.setAggression(this.getAggression() - 1);
            }
            if (this.isRooted()) {
                this.setTimeRooted(this.getTimeRooted() - 1);
                if (this.getSpreadInterval() < maxCounter) {
                    this.setSpreadInterval(this.getSpreadInterval() + 1);
                    if (this.getSpreadInterval() == maxCounter - 1) {
                        this.m_216990_((SoundEvent)Ssounds.PUFF.get());
                    }
                } else {
                    if (((Boolean)SConfig.SERVER.mound_foliage.get()).booleanValue()) {
                        this.SpreadInfection(this.m_9236_(), ((Integer)SConfig.SERVER.gastgeber_range.get()).intValue(), this.m_20097_());
                    } else {
                        this.SpreadEffect();
                    }
                    this.setSpreadInterval(0);
                }
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_21153_(this.m_21223_() + 1.0f);
                }
            }
        }
        if (this.f_19797_ % 200 == 0 && this.isRooted() && this.m_5448_() != null) {
            this.m_5496_((SoundEvent)Ssounds.GAST_AMBIENT.get(), 2.0f, 2.0f);
            this.SpreadEffect();
        }
        if (this.f_19797_ % 1200 == 0 && !this.isRooted() && this.getAggression() <= 0) {
            this.findNewPos();
        }
    }

    public void SpreadEffect() {
        Level entity2;
        AABB aabb = this.m_20191_().m_82400_(16.0);
        List entities = this.m_9236_().m_6249_((Entity)this, aabb, e -> {
            LivingEntity living;
            return e instanceof LivingEntity && this.TARGET_SELECTOR.test(living = (LivingEntity)e);
        });
        for (Level entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 400, 0));
            living.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 3));
        }
        entity2 = this.m_9236_();
        if (entity2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity2;
            double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.2) * 0.2;
            double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.5) * 0.5 * 10.0;
            double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.2) * 0.2;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.BLOOD_PARTICLE.get()), x0, y0, z0, 12, 0.0, 0.0, 0.0, 1.0);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getSpreadInterval() > maxCounter - 3) {
                double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.2) * 0.2;
                double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.5) * 0.5 * 10.0;
                double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.2) * 0.2;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.SPORE_PARTICLE.get()), x0, y0, z0, 9, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    public void findNewPos() {
        BlockPos pos = this.m_20097_();
        int x = this.f_19796_.m_216339_(-32, 32);
        int z = this.f_19796_.m_216339_(-32, 32);
        int y = this.f_19796_.m_216339_(-6, 6);
        BlockPos repos = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
        this.setRootPoint(repos);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (TIME_ROOTED.equals(dataAccessor) && this.getTimeRooted() == 0) {
            this.findNewPos();
        }
        if (EVOLUTION_POINTS.equals(dataAccessor) && this.getEvoPoints() > 0) {
            this.setKills(this.getKills() + 1);
            this.setEvoPoints(this.getEvoPoints() - 1);
        }
        super.m_7350_(dataAccessor);
    }

    private static class FindPlaceToInfect
    extends Goal {
        private final GastGeber geber;
        public int tryTicks;

        public FindPlaceToInfect(GastGeber geber1) {
            this.geber = geber1;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.geber.isRooted() || this.geber.getAggression() > 0) {
                return false;
            }
            if (this.geber.m_9236_().m_8055_(this.geber.getRootPoint().m_7494_()) != Blocks.f_50016_.m_49966_()) {
                this.geber.findNewPos();
                return false;
            }
            return this.geber.getRootPoint() != BlockPos.f_121853_;
        }

        protected void moveMobToBlock() {
            this.geber.m_21573_().m_26519_((double)this.geber.getRootPoint().m_123341_() + 0.5, (double)this.geber.getRootPoint().m_123342_(), (double)this.geber.getRootPoint().m_123343_() + 0.5, 1.0);
        }

        public void m_8056_() {
            this.moveMobToBlock();
            this.tryTicks = 0;
            super.m_8056_();
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.tryTicks;
            if (this.geber.getRootPoint() != BlockPos.f_121853_ && this.shouldRecalculatePath()) {
                this.geber.m_21573_().m_26519_((double)this.geber.getRootPoint().m_123341_(), (double)this.geber.getRootPoint().m_123342_(), (double)this.geber.getRootPoint().m_123343_(), 1.0);
            }
            if (this.geber.getRootPoint() != BlockPos.f_121853_ && this.geber.getRootPoint().m_203195_((Position)this.geber.m_20182_(), 9.0)) {
                this.geber.setTimeRooted(this.geber.maxRootTime);
            }
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

