/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.HohlfresserSeg1Model;
import com.Harbinger.Spore.Client.Models.HohlfresserSeg2Model;
import com.Harbinger.Spore.Client.Models.HohlfresserSeg3Model;
import com.Harbinger.Spore.Client.Models.hohlfresserTailModel;
import com.Harbinger.Spore.Sentities.BaseEntities.HohlMultipart;
import com.Harbinger.Spore.Sentities.Calamities.Hohlfresser;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HohlSegRenderer<Type extends HohlMultipart>
extends LivingEntityRenderer<Type, EntityModel<Type>> {
    public static final Map<HohlMultipart.SegmentVariants, ResourceLocation> TEXTURE = (Map)Util.m_137469_((Object)Maps.newEnumMap(HohlMultipart.SegmentVariants.class), p_114874_ -> {
        p_114874_.put(HohlMultipart.SegmentVariants.DEFAULT, new ResourceLocation("spore", "textures/entity/hohl/hohl_seg1.png"));
        p_114874_.put(HohlMultipart.SegmentVariants.MELEE, new ResourceLocation("spore", "textures/entity/hohl/hohl_seg2.png"));
        p_114874_.put(HohlMultipart.SegmentVariants.ORGAN, new ResourceLocation("spore", "textures/entity/hohl/hohl_seg3.png"));
    });
    private static final ResourceLocation INNARDS = new ResourceLocation("spore", "textures/entity/worm_innards.png");
    private static final ResourceLocation TAIL = new ResourceLocation("spore", "textures/entity/hohl/hohl_seg1.png");
    private final EntityModel<Type> mainSegment = this.m_7200_();
    private final EntityModel<Type> meleeSegment;
    private final EntityModel<Type> organSegment;
    private final EntityModel<Type> tailModel;

    public HohlSegRenderer(EntityRendererProvider.Context context) {
        super(context, new HohlfresserSeg1Model(context.m_174023_(HohlfresserSeg1Model.LAYER_LOCATION)), 4.0f);
        this.meleeSegment = new HohlfresserSeg2Model<Type>(context.m_174023_(HohlfresserSeg2Model.LAYER_LOCATION));
        this.organSegment = new HohlfresserSeg3Model<Type>(context.m_174023_(HohlfresserSeg3Model.LAYER_LOCATION));
        this.tailModel = new hohlfresserTailModel<Type>(context.m_174023_(hohlfresserTailModel.LAYER_LOCATION));
        this.m_115326_(new HohlColors(this));
        this.m_115326_(new HohlEmmisive(this));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((HohlMultipart)entity).isTail() ? TAIL : TEXTURE.get((Object)((HohlMultipart)entity).getSegmentVariant());
    }

    protected void scale(Type type, PoseStack stack, float p_115316_) {
        float size = ((HohlMultipart)type).getSize();
        stack.m_85841_(size, size, size);
        super.m_7546_(type, stack, p_115316_);
    }

    public EntityModel<Type> getSegmentModel(Type type) {
        switch (((HohlMultipart)type).getSegmentVariant()) {
            case MELEE: {
                return this.meleeSegment;
            }
            case ORGAN: {
                return this.organSegment;
            }
        }
        return this.mainSegment;
    }

    public void render(Type type, float val1, float val2, PoseStack stack, MultiBufferSource source, int light) {
        Entity parent;
        this.f_115290_ = ((HohlMultipart)type).isTail() ? this.tailModel : this.getSegmentModel(type);
        super.m_7392_(type, val1, val2, stack, source, light);
        if (type.m_20145_()) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        int i = ((HohlMultipart)type).getParentIntId();
        if (level != null && i != -1 && (parent = level.m_6815_(i)) != null) {
            this.renderConnection(type, parent, stack, source, val2);
        }
    }

    protected boolean shouldShowName(Type p_115333_) {
        return false;
    }

    private void renderConnection(Type parent, Entity to, PoseStack stack, MultiBufferSource buffer, float partialTick) {
        float b;
        float g;
        float r;
        float f;
        if (to instanceof HohlMultipart) {
            HohlMultipart hohlMultipart = (HohlMultipart)to;
            f = hohlMultipart.getSize();
        } else {
            f = to instanceof Hohlfresser ? 1.2f : 0.0f;
        }
        float i = f;
        Vec3 start = parent.m_20318_(partialTick).m_82520_(0.0, (double)(parent.m_20206_() * 0.3f * ((HohlMultipart)parent).getSize()), 0.0);
        Vec3 end = to.m_20318_(partialTick).m_82520_(0.0, (double)(to.m_20206_() * 0.45f * i), 0.0);
        Vec3 direction = end.m_82546_(start);
        float length = (float)direction.m_82553_();
        direction = direction.m_82541_();
        float yaw = (float)Math.atan2(direction.f_82479_, direction.f_82481_);
        float pitch = (float)(-Math.asin(direction.f_82480_));
        int color = ((HohlMultipart)parent).getColor();
        if (color == 0) {
            r = 1.0f;
            g = 1.0f;
            b = 1.0f;
        } else {
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        stack.m_85836_();
        Vec3 vec3 = parent.m_20182_().m_82546_(parent.m_20182_()).m_82490_(-1.0);
        stack.m_85837_(vec3.f_82479_, vec3.f_82480_ + 1.0, vec3.f_82481_);
        stack.m_85845_(Vector3f.f_122225_.m_122270_(yaw));
        stack.m_85845_(Vector3f.f_122223_.m_122270_(pitch));
        float inf = 0.6f;
        float startWidth = parent.m_20205_() * inf * ((HohlMultipart)parent).getSize();
        float startHeight = parent.m_20206_() * inf * ((HohlMultipart)parent).getSize();
        float endWidth = to.m_20205_() * inf * i;
        float endHeight = to.m_20206_() * inf * i;
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)INNARDS));
        PoseStack.Pose pose = stack.m_85850_();
        Matrix4f matrix = pose.m_85861_();
        this.drawTaperedConnection(vertexConsumer, matrix, pose.m_85864_(), startWidth, startHeight, endWidth, endHeight, length, OverlayTexture.f_118083_, 0xF000F0, r, g, b, 1.0f);
        stack.m_85849_();
    }

    private void drawTaperedConnection(VertexConsumer vertexConsumer, Matrix4f matrix, Matrix3f normal, float startWidth, float startHeight, float endWidth, float endHeight, float length, int overlay, int lightmap, float red, float green, float blue, float alpha) {
        float hwStart = startWidth / 2.0f;
        float hhStart = startHeight / 2.0f;
        float hwEnd = endWidth / 2.0f;
        float hhEnd = endHeight / 2.0f;
        vertexConsumer.m_85982_(matrix, -hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, -hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix, hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
    }

    public class HohlColors<T extends HohlMultipart, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        public HohlColors(RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int val, T type, float v, float v1, float v2, float v3, float v4, float v5) {
            if (!type.m_20145_()) {
                if (((HohlMultipart)type).getColor() == 0) {
                    return;
                }
                int i = ((HohlMultipart)type).getColor();
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                VertexConsumer consumer = multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_117347_((Entity)type)));
                this.m_117386_().m_7695_(poseStack, consumer, val, OverlayTexture.f_118083_, r, g, b, 0.5f);
            }
        }
    }

    static class HohlEmmisive<T extends HohlMultipart, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/hohl/hohl_bile.png");

        public HohlEmmisive(RenderLayerParent<T, M> renderLayerParent) {
            super(renderLayerParent);
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.m_20145_() && ((HohlMultipart)entity).getSegmentVariant() == HohlMultipart.SegmentVariants.ORGAN && !((HohlMultipart)entity).isTail()) {
                float alpha = 0.5f + 0.5f * Mth.m_14031_((float)(ageInTicks * 0.1f));
                VertexConsumer vertexConsumer = buffer.m_6299_(SporeRenderTypes.glowingTranslucent(TEXTURE));
                this.m_117386_().m_7695_(matrixStack, vertexConsumer, packedLight, 0xF00000, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }
}

