/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.MepheticBottle;
import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.MephiticModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Mephetic;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MephticRenderer<Type extends Mephetic>
extends BaseInfectedRenderer<Type, MephiticModel<Type>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/mephitic.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/mephitic.png");

    public MephticRenderer(EntityRendererProvider.Context context) {
        super(context, new MephiticModel(context.m_174023_(MephiticModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_(new MepheticBottle(this));
        this.m_115326_(new VolatileGlowingLayers(this));
        this.m_115326_(new PotionLayer(this, context.m_234598_()));
        this.m_115326_(new HeldDrink(this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    static class VolatileGlowingLayers<T extends Mephetic, M extends MephiticModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/mephitic_glow.png");

        public VolatileGlowingLayers(RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.m_20145_()) {
                float alpha = 0.5f + 0.5f * Mth.m_14031_((float)(ageInTicks * 0.1f));
                VertexConsumer vertexConsumer = buffer.m_6299_(SporeRenderTypes.glowingTranslucent(TEXTURE));
                ((MephiticModel)this.m_117386_()).m_7695_(matrixStack, vertexConsumer, packedLight, 0xF00000, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }

    static class PotionLayer<T extends Mephetic, M extends MephiticModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer itemInHandRenderer;

        public PotionLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer itemInHandRenderer) {
            super(parent);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            if (((Mephetic)((Object)t)).getPotions().isEmpty() || ((Mephetic)((Object)t)).getPotions().size() < 3) {
                return;
            }
            this.renderItem(poseStack, t, multiBufferSource, i, ((Mephetic)((Object)t)).getPotions().get(0), -0.05f, 0.05f);
            this.renderItem(poseStack, t, multiBufferSource, i, ((Mephetic)((Object)t)).getPotions().get(1), 0.0f, 0.0f);
            this.renderItem(poseStack, t, multiBufferSource, i, ((Mephetic)((Object)t)).getPotions().get(2), 0.05f, -0.05f);
        }

        private void renderItem(PoseStack poseStack, T entity, MultiBufferSource source, int light, ItemStack stack, float x, float y) {
            poseStack.m_85836_();
            ((MephiticModel)this.m_117386_()).armParts.forEach(part -> part.m_104299_(poseStack));
            poseStack.m_85837_(-0.15 + (double)x, (double)(1.0f + y), 0.0);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
            this.itemInHandRenderer.m_109322_(entity, stack, ItemTransforms.TransformType.FIXED, true, poseStack, source, light);
            poseStack.m_85849_();
        }
    }

    static class HeldDrink<T extends Mephetic, M extends MephiticModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer itemInHandRenderer;

        public HeldDrink(RenderLayerParent<T, M> parent, ItemInHandRenderer itemInHandRenderer) {
            super(parent);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            this.renderItem(poseStack, t, multiBufferSource, i, t.m_21205_(), 0.0f);
            this.renderItem(poseStack, t, multiBufferSource, i, t.m_21206_(), 0.1f);
        }

        private void renderItem(PoseStack poseStack, T entity, MultiBufferSource source, int light, ItemStack stack, float offset) {
            poseStack.m_85836_();
            ((MephiticModel)this.m_117386_()).OffarmParts.forEach(part -> part.m_104299_(poseStack));
            poseStack.m_85837_(0.2 + (double)offset, 1.1, 0.0);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
            this.itemInHandRenderer.m_109322_(entity, stack, ItemTransforms.TransformType.FIXED, true, poseStack, source, light);
            poseStack.m_85849_();
        }
    }
}

