/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings.Package;

import com.Harbinger.Spore.ExtremelySusThings.Package.SyncAdvancementPacket;
import com.Harbinger.Spore.ExtremelySusThings.SporePacketHandler;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class RequestAdvancementPacket {
    private final String advancementId;
    private final int id;

    public RequestAdvancementPacket(String advancementId, int id) {
        this.advancementId = advancementId;
        this.id = id;
    }

    public RequestAdvancementPacket(FriendlyByteBuf buffer) {
        this.advancementId = buffer.m_130277_();
        this.id = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.advancementId);
        buffer.writeInt(this.id);
    }

    public static void handle(RequestAdvancementPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)context.get();
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            Entity truePlayer = player.f_19853_.m_6815_(message.id);
            if (truePlayer instanceof ServerPlayer) {
                ServerPlayer playerValue = (ServerPlayer)truePlayer;
                MinecraftServer server = playerValue.f_8924_;
                Advancement advancement = server.m_129889_().m_136041_(new ResourceLocation(message.advancementId));
                if (advancement == null) {
                    return;
                }
                boolean hasAdvancement = playerValue.m_8960_().m_135996_(advancement).m_8193_();
                SporePacketHandler.sendToClient(new SyncAdvancementPacket(message.advancementId, hasAdvancement), playerValue);
            }
        });
        context.get().setPacketHandled(true);
    }
}

