/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GraftingRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;

    public GraftingRecipe(NonNullList<Ingredient> inputItems, ItemStack output, ResourceLocation id) {
        this.inputItems = inputItems;
        this.output = output;
        this.id = id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public boolean matches(SimpleContainer simpleContainer, Level level) {
        if (level.m_5776_() || simpleContainer.m_6643_() < 24) {
            return false;
        }
        for (int i = 21; i < 24; ++i) {
            if (((Ingredient)this.inputItems.get(i)).test(simpleContainer.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(SimpleContainer simpleContainer) {
        return this.output == null ? ItemStack.f_41583_ : this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return GraftingRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return GraftingRecipeType.INSTANCE;
    }

    public static class GraftingRecipeSerializer
    implements RecipeSerializer<GraftingRecipe> {
        public static final GraftingRecipeSerializer INSTANCE = new GraftingRecipeSerializer();
        public static final ResourceLocation ID = new ResourceLocation("spore", "grafting");

        public GraftingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)24, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                JsonObject ingredientJson = ingredients.get(i).getAsJsonObject();
                int slot = GsonHelper.m_13824_((JsonObject)ingredientJson, (String)"slot", (int)(i + 21));
                if (slot < 0 || slot >= inputs.size()) continue;
                inputs.set(slot, (Object)Ingredient.m_43917_((JsonElement)ingredientJson));
            }
            return new GraftingRecipe((NonNullList<Ingredient>)inputs, output, resourceLocation);
        }

        @Nullable
        public GraftingRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            NonNullList inputs = NonNullList.m_122780_((int)friendlyByteBuf.readInt(), (Object)Ingredient.f_43901_);
            inputs.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            ItemStack output = friendlyByteBuf.m_130267_();
            return new GraftingRecipe((NonNullList<Ingredient>)inputs, output, resourceLocation);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, GraftingRecipe surgeryRecipe) {
            friendlyByteBuf.writeInt(surgeryRecipe.inputItems.size());
            for (Ingredient ingredient : surgeryRecipe.m_7527_()) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.writeItemStack(surgeryRecipe.m_8043_(), false);
        }
    }

    public static class GraftingRecipeType
    implements RecipeType<GraftingRecipe> {
        public static final GraftingRecipeType INSTANCE = new GraftingRecipeType();
        public static final String ID = "grafting";

        private GraftingRecipeType() {
        }
    }
}

