/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Recipes;

import com.Harbinger.Spore.Recipes.EntityContainer;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class InjectionRecipe
implements Recipe<EntityContainer> {
    private final ResourceLocation id;
    private final String entityId;
    private final int type;
    private final ItemStack result;

    public InjectionRecipe(ResourceLocation id, String entityId, int type, ItemStack result) {
        this.id = id;
        this.entityId = entityId;
        this.type = type;
        this.result = result;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public int getEntityType() {
        return this.type;
    }

    public boolean matches(EntityContainer entityContainer, Level level) {
        if (level.f_46443_) {
            return false;
        }
        EntityType entityType = entityContainer.entity().m_6095_();
        EntityType expectedType = EntityType.m_20632_((String)this.entityId).orElse(null);
        if (expectedType == null) {
            return false;
        }
        Entity entity = entityContainer.entity();
        if (entity instanceof VariantKeeper) {
            VariantKeeper keeper = (VariantKeeper)entity;
            return keeper.getTypeVariant() == this.getEntityType() && entityType.equals(expectedType);
        }
        return entityType.equals(expectedType);
    }

    public ItemStack assemble(EntityContainer entityContainer) {
        return this.result == null ? ItemStack.f_41583_ : this.result.m_41777_();
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result == null ? ItemStack.f_41583_ : this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return InjectionRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return InjectionRecipeType.INSTANCE;
    }

    public static class InjectionRecipeSerializer
    implements RecipeSerializer<InjectionRecipe> {
        public static final InjectionRecipeSerializer INSTANCE = new InjectionRecipeSerializer();
        public static final ResourceLocation ID = new ResourceLocation("spore", "injection");

        public InjectionRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"output"));
            String entityId = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"entity");
            int type = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"entity_type");
            return new InjectionRecipe(resourceLocation, entityId, type, output);
        }

        @Nullable
        public InjectionRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            String entityId = buf.m_130277_();
            int type = buf.readInt();
            ItemStack result = buf.m_130267_();
            return new InjectionRecipe(resourceLocation, entityId, type, result);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, InjectionRecipe injectionRecipe) {
            friendlyByteBuf.m_130070_(injectionRecipe.entityId);
            friendlyByteBuf.writeInt(injectionRecipe.getEntityType());
            friendlyByteBuf.writeItemStack(injectionRecipe.m_8043_(), false);
        }
    }

    public static class InjectionRecipeType
    implements RecipeType<InjectionRecipe> {
        public static final InjectionRecipeType INSTANCE = new InjectionRecipeType();
        public static final String ID = "injection";

        private InjectionRecipeType() {
        }
    }
}

