/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.SBlockEntities.AnimatedEntity;
import com.Harbinger.Spore.Sentities.Organoids.Umarmer;
import com.Harbinger.Spore.Sentities.Organoids.Usurper;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OutpostWatcherBlockEntity
extends BlockEntity
implements AnimatedEntity {
    public int ticks;

    public OutpostWatcherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SblockEntities.OUTPOST_WATCHER.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
    }

    public void tick() {
        this.ticks = this.ticks <= 720 ? ++this.ticks : 0;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, OutpostWatcherBlockEntity e) {
        e.tick();
        if (e.getTicks() % 200 == 0) {
            e.checkForPotentialTargets(level, blockPos);
        }
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, OutpostWatcherBlockEntity e) {
        e.tick();
    }

    public void checkForPotentialTargets(Level level, BlockPos blockPos) {
        if (level.m_46791_() != Difficulty.PEACEFUL) {
            int range = 2 * (Integer)SConfig.DATAGEN.outpost_range.get();
            AABB aabb = AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)range, (double)range, (double)range);
            List possibleTargets = level.m_45976_(LivingEntity.class, aabb);
            ArrayList<ScentEntity> amountofScents = new ArrayList<ScentEntity>();
            for (LivingEntity entity : possibleTargets) {
                if (!(entity instanceof ScentEntity)) continue;
                ScentEntity scent = (ScentEntity)entity;
                amountofScents.add(scent);
            }
            for (LivingEntity entity : possibleTargets) {
                if (!Utilities.TARGET_SELECTOR.Test(entity) || !EntitySelector.f_20406_.test(entity) || entity.m_21023_((MobEffect)Seffects.SYMBIOSIS.get()) || !entity.m_20096_()) continue;
                if (Math.random() < (double)0.3f && amountofScents.size() <= (Integer)SConfig.SERVER.scent_cap.get()) {
                    this.SummonScent(entity, level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                }
                if (!(Math.random() < (double)0.1f) || !(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                this.SummonOrganoids(serverLevel, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Math.random() <= 0.5, blockPos);
            }
        }
    }

    private void SummonScent(LivingEntity target, Level level, double x, double y, double z) {
        AABB aabb = target.m_20191_().m_82400_(3.0);
        List entityList = level.m_6249_((Entity)target, aabb, entity -> {
            LivingEntity livingEntity;
            return entity instanceof LivingEntity && Utilities.TARGET_SELECTOR.Test(livingEntity = (LivingEntity)entity);
        });
        ScentEntity scent = new ScentEntity((EntityType<? extends PathfinderMob>)((EntityType)Sentities.SCENT.get()), level);
        scent.setOvercharged(entityList.size() > 2);
        scent.m_6027_(x, y, z);
        level.m_7967_((Entity)scent);
    }

    private void SummonOrganoids(ServerLevel level, double x, double y, double z, boolean range, BlockPos pos) {
        if (range) {
            Umarmer umarmer = new Umarmer((EntityType<? extends PathfinderMob>)((EntityType)Sentities.UMARMED.get()), (Level)level);
            umarmer.m_6027_(x, y, z);
            umarmer.m_6021_(x, y, z);
            umarmer.m_6518_((ServerLevelAccessor)level, level.m_6436_(new BlockPos((Vec3i)pos)), MobSpawnType.MOB_SUMMONED, null, null);
            level.m_7967_((Entity)umarmer);
        } else {
            Usurper usurper = new Usurper((EntityType<? extends PathfinderMob>)((EntityType)Sentities.USURPER.get()), (Level)level);
            usurper.m_6027_(x, y, z);
            usurper.m_6021_(x, y, z);
            usurper.m_6518_((ServerLevelAccessor)level, level.m_6436_(new BlockPos((Vec3i)pos)), MobSpawnType.MOB_SUMMONED, null, null);
            level.m_7967_((Entity)usurper);
        }
    }
}

