/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Screens;

import com.Harbinger.Spore.Recipes.WombRecipe;
import com.Harbinger.Spore.Screens.AssimilationMenu;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class AssimilationScreen
extends AbstractContainerScreen<AssimilationMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/gui/assimilation_gui.png");
    private final List<WombRecipe> recipes;
    private List<WombRecipe.Pair> mobPairs;
    private int tickCounter = 0;
    private int currentItemIndex = 0;
    private Button leftButton;
    private Button rightButton;
    private int currentEntityIndex = 0;
    ClientLevel level;

    public AssimilationScreen(AssimilationMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.level = Minecraft.m_91087_().f_91073_;
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.recipes = this.level == null ? new ArrayList<WombRecipe>() : this.level.m_7465_().m_44013_((RecipeType)WombRecipe.WombRecipeType.INSTANCE);
    }

    private void changeRecipe(int direction) {
        if (!this.recipes.isEmpty()) {
            this.currentItemIndex = (this.currentItemIndex + direction) % this.recipes.size();
            this.currentEntityIndex = 0;
            if (this.currentItemIndex < 0) {
                this.currentItemIndex += this.recipes.size();
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 10000;
        this.f_97729_ = 10000;
        int buttonY = this.f_97736_ - 20;
        int buttonX = this.f_97735_ + 88;
        this.leftButton = (Button)this.m_142416_((GuiEventListener)new Button(buttonX - 10, buttonY, 20, 20, (Component)Component.m_237113_((String)"<"), button -> this.changeRecipe(-1)));
        this.rightButton = (Button)this.m_142416_((GuiEventListener)new Button(buttonX + 10, buttonY, 20, 20, (Component)Component.m_237113_((String)">"), button -> this.changeRecipe(1)));
    }

    protected void m_7286_(PoseStack poseStack, float v, int i, int i1) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        AssimilationScreen.m_93133_((PoseStack)poseStack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
        RenderSystem.m_69461_();
    }

    public void m_6305_(PoseStack guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_7333_(guiGraphics);
        super.m_6305_(guiGraphics, mouseX, mouseY, delta);
        int x = this.f_97735_ + 34;
        int y = this.f_97736_ + 70;
        this.m_7025_(guiGraphics, mouseX, mouseY);
        WombRecipe recipe = this.recipes.get(this.currentItemIndex);
        if (recipe == null) {
            return;
        }
        this.mobPairs = recipe.getEntityPairs();
        if (this.level != null) {
            WombRecipe.Pair pairs = this.mobPairs.get(this.currentEntityIndex);
            int variant = pairs.type();
            ResourceLocation location = new ResourceLocation(pairs.entityId());
            Entity entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location)).m_20615_((Level)this.level);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (living instanceof VariantKeeper) {
                    VariantKeeper keeper = (VariantKeeper)living;
                    keeper.setVariant(variant);
                    this.renderEntityInInventoryFollowsAngle(guiGraphics, x, y, 20, 0.0f, 0.0f, living);
                } else {
                    this.renderEntityInInventoryFollowsAngle(guiGraphics, x, y, 20, 0.0f, 0.0f, living);
                }
            }
        }
        this.renderIcon(guiGraphics, recipe.getIcon());
        this.renderName(guiGraphics, recipe.getAttribute());
    }

    private void renderIcon(PoseStack guiGraphics, ResourceLocation iconLocation) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)iconLocation);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        int iconX = this.f_97735_ + 100;
        int iconY = this.f_97736_ + 30;
        int iconWidth = 32;
        int iconHeight = 32;
        AssimilationScreen.m_93133_((PoseStack)guiGraphics, (int)iconX, (int)iconY, (float)0.0f, (float)0.0f, (int)iconWidth, (int)iconHeight, (int)iconWidth, (int)iconHeight);
        RenderSystem.m_69461_();
    }

    private void renderName(PoseStack guiGraphics, String attributeName) {
        String[] strings = attributeName.split(":");
        MutableComponent name = Component.m_237115_((String)("attribute.name.spore." + strings[1]));
        int iconX = this.f_97735_ + 100;
        int iconY = this.f_97736_ + 25;
        int iconWidth = 32;
        int textX = iconX + iconWidth / 2 - this.f_96547_.m_92852_((FormattedText)name) / 2;
        int textY = iconY - 10;
        AssimilationScreen.m_93243_((PoseStack)guiGraphics, (Font)this.f_96547_, (Component)name, (int)textX, (int)textY, (int)0xFFFFFF);
    }

    public void renderEntityInInventoryFollowsAngle(PoseStack poseStack, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        poseStack.m_85836_();
        Quaternion pose = new Quaternion(0.0f, 180.0f, 180.0f, true);
        Quaternion cameraOrientation = new Quaternion(angleYComponent * 20.0f, 0.0f, 0.0f, true);
        pose.m_80148_(cameraOrientation);
        float originalBodyRot = entity.f_20883_;
        float originalYRot = entity.m_146908_();
        float originalXRot = entity.m_146909_();
        float originalHeadRotO = entity.f_20886_;
        float originalHeadRot = entity.f_20885_;
        entity.f_20883_ = 180.0f + angleXComponent * 20.0f;
        entity.m_146922_(180.0f + angleXComponent * 40.0f);
        entity.m_146926_(-angleYComponent * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        this.renderEntityInInventory(poseStack, x, y, scale, pose, entity);
        entity.f_20883_ = originalBodyRot;
        entity.m_146922_(originalYRot);
        entity.m_146926_(originalXRot);
        entity.f_20886_ = originalHeadRotO;
        entity.f_20885_ = originalHeadRot;
        poseStack.m_85849_();
    }

    private void renderEntityInInventory(PoseStack poseStack, int x, int y, int scale, Quaternion quaternion, LivingEntity entity) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 50.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack.m_85845_(quaternion);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_166384_();
        RenderSystem.m_157182_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        dispatcher.m_114468_(false);
        dispatcher.m_114468_(false);
        RenderSystem.m_69890_(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!this.recipes.isEmpty()) {
            ++this.tickCounter;
            if (this.tickCounter % 40 == 0) {
                this.currentEntityIndex = (this.currentEntityIndex + 1) % this.mobPairs.size();
            }
        }
    }
}

