/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.Calamities.Hohlfresser;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidType;

public class HohlMultipart
extends LivingEntity
implements TrueCalamity {
    private double prevHeight = 0.0;
    private int headEntityId = -1;
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_TAIL = SynchedEntityData.m_135353_(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PARENT_ID = SynchedEntityData.m_135353_(HohlMultipart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float spin = 0.0f;

    public HohlMultipart(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
        this.f_19793_ = 1.5f;
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.CALAMITY_DAMAGE.get();
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(IS_TAIL, (Object)false);
        this.f_19804_.m_135372_(PARENT_ID, (Object)-1);
    }

    public Entity getChild() {
        Level level;
        UUID id = this.getChildId();
        if (id != null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_8791_(id);
        }
        return null;
    }

    public int getParentIntId() {
        return (Integer)this.f_19804_.m_135370_(PARENT_ID);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19817_ = false;
        if (this.f_19797_ > 1) {
            Entity parent = this.getParentSafe();
            if (!this.f_19853_.f_46443_) {
                if (parent == null || parent.m_213877_()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                } else if (parent instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)parent;
                    this.f_20916_ = living.f_20916_;
                    this.f_20919_ = living.f_20919_;
                }
            }
        }
        if (this.f_19797_ % 100 == 0) {
            this.m_6210_();
        }
        if (this.f_19797_ % 30 == 0 && this.getSegmentVariant() == SegmentVariants.MELEE && !this.isTail()) {
            this.dealMeleeDamageAround();
        }
    }

    public float getSpin() {
        float speed = (float)Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
        this.spin += speed * 2.5E-4f * (float)this.f_19797_;
        return this.spin;
    }

    public Vec3 tickMultipartPosition(int headId, Vec3 parentPos, float parentXRot, float parentYRot, float ourYRot, boolean doHeight) {
        double spacing = 1.5f * this.m_20205_();
        Vec3 buttOffset = this.calcOffsetVec((float)(-spacing), parentXRot, parentYRot);
        Vec3 targetPos = parentPos.m_82549_(buttOffset);
        Vec3 currentPos = this.m_20182_();
        Vec3 smoothedPos = currentPos.m_165921_(targetPos, 0.25);
        double yOffset = 0.0;
        if (doHeight) {
            double hgt = this.getLowPartHeight(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_) + this.getHighPartHeight(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
            if (Math.abs(hgt - this.prevHeight) > (double)0.2f) {
                this.prevHeight = hgt;
            }
            yOffset = Mth.m_14008_((double)((double)this.m_6134_() * this.prevHeight), (double)-0.6f, (double)0.6f);
        }
        double dx = parentPos.f_82479_ - smoothedPos.f_82479_;
        double dz = parentPos.f_82481_ - smoothedPos.f_82481_;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
        float smoothedYaw = this.limitAngle(this.m_146908_(), targetYaw, 7.5f);
        float targetPitch = (float)(-Mth.m_14136_((double)yOffset, (double)horizontalDist) * 57.2957763671875);
        float smoothedPitch = this.limitAngle(this.m_146909_(), targetPitch, 5.0f);
        double distanceToParent = this.m_20182_().m_82554_(parentPos);
        boolean disablePhysics = distanceToParent > 5.0;
        Entity entity = this.getParentSafe();
        if (entity != null) {
            this.m_20242_(disablePhysics || entity.m_20068_());
            boolean bl = this.f_19794_ = disablePhysics || entity.f_19794_;
            if (disablePhysics) {
                this.m_6021_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            }
            this.m_20256_(disablePhysics ? entity.m_20184_().m_82542_(1.0, 0.0, 1.0) : entity.m_20184_());
        }
        this.m_7678_(smoothedPos.f_82479_, this.f_19861_ ? this.m_20182_().f_82480_ : smoothedPos.f_82480_, smoothedPos.f_82481_, smoothedYaw, smoothedPitch);
        this.m_146922_(smoothedYaw);
        this.m_146926_(smoothedPitch);
        this.f_20885_ = smoothedYaw;
        this.headEntityId = headId;
        return smoothedPos;
    }

    private Vec3 calcOffsetVec(float offsetZ, float xRot, float yRot) {
        return new Vec3(0.0, 0.0, (double)offsetZ).m_82496_(xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180));
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19310_ || source == DamageSource.f_19315_;
    }

    public boolean isOpaqueBlockAt(double x, double y, double z) {
        if (this.f_19794_) {
            return false;
        }
        Vec3 pos = new Vec3(x, y, z);
        AABB box = AABB.m_165882_((Vec3)pos, (double)1.0, (double)1.0E-6, (double)1.0);
        return this.f_19853_.m_45556_(box).filter(Predicate.not(BlockBehaviour.BlockStateBase::m_60795_)).anyMatch(state -> state.m_60828_((BlockGetter)this.f_19853_, new BlockPos(pos)) && Shapes.m_83157_((VoxelShape)state.m_60812_((BlockGetter)this.f_19853_, new BlockPos(pos)).m_83216_(pos.f_82479_, pos.f_82480_, pos.f_82481_), (VoxelShape)Shapes.m_83064_((AABB)box), (BooleanOp)BooleanOp.f_82689_));
    }

    public double getLowPartHeight(double x, double y, double z) {
        double dy;
        if (this.isFluidAt(x, y, z)) {
            return 0.0;
        }
        for (dy = 0.0; dy > -3.0 && !this.isOpaqueBlockAt(x, y + dy, z); dy -= 0.2) {
        }
        return dy;
    }

    public double getHighPartHeight(double x, double y, double z) {
        double dy;
        if (this.isFluidAt(x, y, z)) {
            return 0.0;
        }
        for (dy = 0.0; dy <= 3.0 && this.isOpaqueBlockAt(x, y + dy, z); dy += 0.2) {
        }
        return dy;
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean isFluidAt(double x, double y, double z) {
        if (this.f_19794_) {
            return false;
        }
        return !this.f_19853_.m_6425_(new BlockPos(x, y, z)).m_76178_();
    }

    public float limitAngle(float source, float target, float maxChange) {
        float delta = Mth.m_14177_((float)(target - source));
        delta = Mth.m_14036_((float)delta, (float)(-maxChange), (float)maxChange);
        float result = source + delta;
        return Mth.m_14177_((float)result);
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source == DamageSource.f_19310_ || source == DamageSource.f_19315_) {
            return false;
        }
        if (!this.isTail() && this.getSegmentVariant() == SegmentVariants.ORGAN) {
            damage *= 2.5f;
        }
        this.f_19864_ = true;
        this.f_20916_ = 20;
        return this.hurtHeadId(source, damage);
    }

    public void dealMeleeDamageAround() {
        AABB aabb = this.m_20191_().m_82400_(1.5);
        List entities = this.f_19853_.m_6249_((Entity)this, aabb, entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && Utilities.TARGET_SELECTOR.Test(living = (LivingEntity)entity);
        });
        float damage = (float)((Double)SConfig.SERVER.hohl_damage.get() * (Double)SConfig.SERVER.global_damage.get() / 2.0);
        for (Entity entity2 : entities) {
            entity2.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage);
        }
    }

    public boolean hurtHeadId(DamageSource source, float damage) {
        Entity e;
        if (this.headEntityId != -1 && (e = this.f_19853_.m_6815_(this.headEntityId)) instanceof Hohlfresser) {
            return e.m_6469_(source, damage);
        }
        return true;
    }

    public Entity getParentSafe() {
        Level level;
        UUID id = this.getParentId();
        if (id != null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity parent = serverLevel.m_8791_(id);
            if (parent == null) {
                return null;
            }
            this.f_19804_.m_135381_(PARENT_ID, (Object)parent.m_19879_());
            return parent;
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.m_20148_());
    }

    public UUID getParentId() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public boolean m_6052_() {
        return false;
    }

    protected void m_142540_(MobEffectInstance instance, @Nullable Entity source) {
        super.m_142540_(instance, source);
        Entity parent = this.getParentSafe();
        if (!(parent instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingParent = (LivingEntity)parent;
        MobEffectInstance existing = livingParent.m_21124_(instance.m_19544_());
        if (existing == null || existing.m_19557_() < instance.m_19557_() - 5) {
            livingParent.m_7292_(new MobEffectInstance(instance));
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult interactionResult;
        Entity parent = this.getParentSafe();
        if (parent instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)parent;
            interactionResult = living.m_6096_(player, hand);
        } else {
            interactionResult = super.m_6096_(player, hand);
        }
        return interactionResult;
    }

    public Iterable<ItemStack> m_6168_() {
        return List.of();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getParentId() != null) {
            tag.m_128362_("ParentUUID", this.getParentId());
        }
        if (this.getChildId() != null) {
            tag.m_128362_("ChildUUID", this.getChildId());
        }
        tag.m_128350_("size", ((Float)this.f_19804_.m_135370_(SIZE)).floatValue());
        tag.m_128405_("variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
        tag.m_128405_("color", ((Integer)this.f_19804_.m_135370_(COLOR)).intValue());
        tag.m_128379_("tail", ((Boolean)this.f_19804_.m_135370_(IS_TAIL)).booleanValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("ParentUUID")) {
            this.setParentId(tag.m_128342_("ParentUUID"));
        }
        if (tag.m_128403_("ChildUUID")) {
            this.setChildId(tag.m_128342_("ChildUUID"));
        }
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(tag.m_128457_("size")));
        this.f_19804_.m_135381_(VARIANT, (Object)tag.m_128451_("variant"));
        this.f_19804_.m_135381_(COLOR, (Object)tag.m_128451_("color"));
        this.f_19804_.m_135381_(IS_TAIL, (Object)tag.m_128471_("tail"));
    }

    public void setSize(float val) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(val));
    }

    public void setVariant(int val) {
        this.f_19804_.m_135381_(VARIANT, (Object)val);
    }

    public void setColor(int val) {
        this.f_19804_.m_135381_(COLOR, (Object)val);
    }

    public void setIsTail(boolean val) {
        this.f_19804_.m_135381_(IS_TAIL, (Object)val);
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public boolean isTail() {
        return (Boolean)this.f_19804_.m_135370_(IS_TAIL);
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        return false;
    }

    @Override
    public int chemicalRange() {
        return 0;
    }

    @Override
    public List<? extends String> buffs() {
        return List.of();
    }

    @Override
    public List<? extends String> debuffs() {
        return List.of();
    }

    public EntityDimensions m_6972_(Pose p_21047_) {
        return super.m_6972_(p_21047_).m_20388_(this.getSize());
    }

    private void setVariant(SegmentVariants variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void setVariant() {
        SegmentVariants variant = (SegmentVariants)((Object)Util.m_214670_((Object[])SegmentVariants.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
    }

    public SegmentVariants getSegmentVariant() {
        return SegmentVariants.byId((Integer)this.f_19804_.m_135370_(VARIANT) & 0xFF);
    }

    public static enum SegmentVariants {
        DEFAULT(0),
        MELEE(1),
        ORGAN(2);

        private static final SegmentVariants[] BY_ID;
        private final int id;

        private SegmentVariants(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static SegmentVariants byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        static {
            BY_ID = (SegmentVariants[])Arrays.stream(SegmentVariants.values()).sorted(Comparator.comparingInt(SegmentVariants::getId)).toArray(SegmentVariants[]::new);
        }
    }
}

