/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BasicInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.HazmatVariant;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InfectedHazmat
extends Infected
implements VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(InfectedHazmat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BLOW_TIME = SynchedEntityData.m_135353_(InfectedHazmat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public InfectedHazmat(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.SCIENTIST_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.inf_hazmat_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.inf_hazmat_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.inf_hazmat_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22282_, 0.3);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(BLOW_TIME, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        HazmatVariant variant = (HazmatVariant)((Object)Util.m_214670_((Object[])HazmatVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void setBlowTime(int i) {
        this.f_19804_.m_135381_(BLOW_TIME, (Object)i);
    }

    public int getBlowTime() {
        return (Integer)this.f_19804_.m_135370_(BLOW_TIME);
    }

    private void tickExplosion() {
        this.setBlowTime(this.getBlowTime() + 1);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getVariant() == HazmatVariant.TANK && Math.random() < 0.5) {
            this.tickExplosion();
        }
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getVariant() == HazmatVariant.TANK) {
            if (this.getBlowTime() == 1) {
                this.m_216990_(SoundEvents.f_12512_);
            }
            if (this.getBlowTime() > 0) {
                this.tickExplosion();
            }
            if (this.getBlowTime() >= 60) {
                this.explodeTank();
            }
        }
    }

    private void explodeTank() {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)((Integer)SConfig.SERVER.gastank_explosion.get()).intValue(), Explosion.BlockInteraction.NONE);
            this.m_146870_();
        }
    }

    public HazmatVariant getVariant() {
        return HazmatVariant.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
    }

    @Override
    public int amountOfMutations() {
        return HazmatVariant.values().length;
    }

    private void setVariant(HazmatVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (effectInstance.m_19544_().m_19486_() || this.getTypeVariant() == 2) {
            return super.m_147207_(effectInstance, entity);
        }
        return false;
    }
}

