/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BasicInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedHazmat;
import com.Harbinger.Spore.Sentities.EvolvedInfected.HasUsableSlot;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.InfPlayerSkins;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

public class InfectedPlayer
extends Infected
implements RangedAttackMob,
ArmedInfected,
EvolvingInfected,
VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(InfectedHazmat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public InfectedPlayer(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    protected void m_8024_() {
        this.m_6858_(this.m_5912_());
        if (!this.m_21525_() && GoalUtils.m_26894_((Mob)this)) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        }
        super.m_8024_();
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal<InfectedPlayer>(this, 1.0, 20, 15.0f){

            public boolean m_8036_() {
                return super.m_8036_() && InfectedPlayer.this.m_5448_() != null && InfectedPlayer.this.m_20280_((Entity)InfectedPlayer.this.m_5448_()) > 20.0;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(4, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 3.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new OpenDoorGoal((Mob)this, true){

            public void m_8056_() {
                this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                super.m_8056_();
            }
        });
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_player_loot.get();
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        return super.getCustomDamage(entity);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33282_, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        RandomSource randomsource = p_33282_.m_213780_();
        this.m_213945_(randomsource, p_33283_);
        this.m_213946_(randomsource, p_33283_);
        this.setSkin();
        return super.m_6518_(p_33282_, p_33283_, p_33284_, p_33285_, p_33286_);
    }

    public void setSkin() {
        InfPlayerSkins variant = (InfPlayerSkins)((Object)Util.m_214670_((Object[])InfPlayerSkins.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
    }

    public static void createItems(LivingEntity living, EquipmentSlot slot, List<? extends String> list) {
        if (living.m_6844_(slot) != ItemStack.f_41583_) {
            return;
        }
        ItemStack stack = ItemStack.f_41583_;
        for (String string : list) {
            String[] string2 = string.split("\\|");
            ItemStack itemStack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string2[0]))));
            if (!(Math.random() < (double)((float)Integer.parseUnsignedInt(string2[1]) / 100.0f))) continue;
            stack = itemStack;
        }
        living.m_8061_(slot, stack);
    }

    public static void createName(LivingEntity living, List<? extends String> list) {
        if (living.m_7770_() != null) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            int randomIndex = living.m_217043_().m_188503_(list.size());
            Component component = Component.m_130674_((String)list.get(randomIndex));
            living.m_6593_(component);
        }
    }

    protected void m_213945_(RandomSource p_219059_, DifficultyInstance p_219060_) {
        InfectedPlayer.createName((LivingEntity)this, (List)SConfig.DATAGEN.name.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.HEAD, (List)SConfig.DATAGEN.player_h.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.CHEST, (List)SConfig.DATAGEN.player_c.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.LEGS, (List)SConfig.DATAGEN.player_l.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.FEET, (List)SConfig.DATAGEN.player_b.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.MAINHAND, (List)SConfig.DATAGEN.player_hm.get());
        InfectedPlayer.createItems((LivingEntity)this, EquipmentSlot.OFFHAND, (List)SConfig.DATAGEN.player_ho.get());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.player_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.player_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.player_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22282_, 0.2);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.ADVENTURER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    public void m_6504_(LivingEntity entity, float value) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, value);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = entity.m_20185_() - this.m_20185_();
        double d1 = entity.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = entity.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        if (abstractarrow instanceof Arrow) {
            Arrow arrow = (Arrow)abstractarrow;
            arrow.m_36870_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600));
        }
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack p_32156_, float p_32157_) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)p_32156_, (float)p_32157_);
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickEvolution(this, (List)SConfig.SERVER.player_ev.get(), ScamperVariants.DEFAULT);
    }

    @Override
    public void Evolve(Infected livingEntity, List<? extends String> value, ScamperVariants variants) {
        if (livingEntity != null && value != null && livingEntity.f_19853_ instanceof ServerLevel) {
            Level level = livingEntity.f_19853_;
            RandomSource random = RandomSource.m_216327_();
            if (Math.random() < 0.9) {
                Random rand = new Random();
                for (int i = 0; i < 1; ++i) {
                    int randomIndex = rand.nextInt(value.size());
                    ResourceLocation randomElement1 = new ResourceLocation(value.get(randomIndex));
                    EntityType randomElement = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(randomElement1);
                    Entity waveentity = randomElement.m_20615_(level);
                    waveentity.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_() + 0.5, livingEntity.m_20189_());
                    waveentity.m_6593_(livingEntity.m_7770_());
                    if (waveentity instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)waveentity;
                        Collection collection = livingEntity.m_21220_();
                        for (MobEffectInstance mobeffectinstance : collection) {
                            entity.m_7292_(new MobEffectInstance(mobeffectinstance));
                        }
                    }
                    if (waveentity instanceof Infected) {
                        Infected infected = (Infected)waveentity;
                        infected.setKills(livingEntity.getKills());
                        infected.setEvoPoints(livingEntity.getEvoPoints());
                        infected.setSearchPos(livingEntity.getSearchPos());
                        infected.setLinked(livingEntity.getLinked());
                        if (infected instanceof HasUsableSlot) {
                            HasUsableSlot hasUsableSlot = (HasUsableSlot)((Object)infected);
                            for (EquipmentSlot slot : EquipmentSlot.values()) {
                                if (!hasUsableSlot.hasUsableSlot(slot)) continue;
                                infected.m_8061_(slot, this.m_6844_(slot));
                            }
                        }
                    }
                    level.m_7967_(waveentity);
                    livingEntity.m_146870_();
                }
            } else {
                Scamper scamper = new Scamper((EntityType<? extends Monster>)((EntityType)Sentities.SCAMPER.get()), level);
                scamper.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_() + 0.5, livingEntity.m_20189_());
                scamper.m_6593_(livingEntity.m_7770_());
                scamper.setKills(livingEntity.getKills());
                scamper.setEvoPoints(livingEntity.getEvoPoints());
                scamper.setLinked(livingEntity.getLinked());
                scamper.setSearchPos(livingEntity.getSearchPos());
                Collection collection = livingEntity.m_21220_();
                for (MobEffectInstance mobeffectinstance : collection) {
                    scamper.m_7292_(new MobEffectInstance(mobeffectinstance));
                }
                level.m_7967_((Entity)scamper);
                livingEntity.m_146870_();
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double x0 = livingEntity.m_20185_() - ((double)random.m_188501_() - 0.1) * 0.1;
                double y0 = livingEntity.m_20186_() + ((double)random.m_188501_() - 0.25) * 0.15 * 5.0;
                double z0 = livingEntity.m_20189_() + ((double)random.m_188501_() - 0.1) * 0.1;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        Item item = Items.f_42409_;
        if (this.m_21205_().m_41720_() == item || this.m_21206_().m_41720_() == item) {
            entity.m_20254_(10);
        }
        return super.m_7327_(entity);
    }

    private void setVariant(InfPlayerSkins variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public InfPlayerSkins getVariant() {
        return InfPlayerSkins.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > InfPlayerSkins.values().length || i < 0) {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return InfPlayerSkins.values().length;
    }
}

