/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.FlyingInfected;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedArialMovementControl;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Scavenger
extends EvolvedInfected
implements FlyingInfected {
    private int screams;
    private int ticksAggressive;

    public Scavenger(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21342_ = new InfectedArialMovementControl((Mob)this, 20, false);
        this.f_21344_ = new FlyingPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.scavenger_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.scavenger_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.scavenger_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22280_, 0.4);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.scavenger_loot.get();
    }

    public boolean canAttack() {
        return this.ticksAggressive > 0 || this.checkForHelp();
    }

    public boolean m_142535_(float p_147105_, float p_147106_, DamageSource p_147107_) {
        return false;
    }

    @Override
    public void m_7023_(Vec3 vec) {
        if (this.m_6142_() && !this.f_19861_) {
            this.m_19920_(0.1f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_(this.m_20069_() ? 0.2 : 1.0));
            this.m_20256_(this.m_20184_().m_82490_(0.85));
        } else {
            super.m_7023_(vec);
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
    }

    private boolean checkForHelp() {
        LivingEntity living = this.m_5448_();
        if (living == null) {
            return false;
        }
        List infected = this.f_19853_.m_6249_((Entity)this, living.m_20191_().m_82400_(3.0), entity -> entity instanceof Infected || entity instanceof UtilityEntity);
        return !infected.isEmpty();
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity living = this.m_5448_();
        if (living != null && !this.canAttack()) {
            this.moveToTarget(living, 150.0);
        }
        if (this.ticksAggressive > 0) {
            --this.ticksAggressive;
        }
    }

    public void scream(LivingEntity living) {
        if (this.screams > 3) {
            this.ticksAggressive = 200;
            this.screams = 0;
            return;
        }
        this.m_216990_((SoundEvent)Ssounds.SCAVENGER_SCREECH.get());
        ++this.screams;
        this.screamForHelp(living);
    }

    public void screamForHelp(LivingEntity living) {
        AABB aabb = this.m_20191_().m_82400_(48.0);
        List infected = this.f_19853_.m_6249_((Entity)this, aabb, entity -> entity instanceof Infected);
        for (Entity entity2 : infected) {
            Infected infected1;
            if (!(entity2 instanceof Infected) || (infected1 = (Infected)entity2).m_5448_() != null) continue;
            infected1.m_6710_(living);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null) {
            this.ticksAggressive = 200;
        }
        return super.m_6469_(source, amount);
    }

    private void moveToTarget(LivingEntity living, double range) {
        double distance = this.m_20280_((Entity)living);
        if (this.f_19797_ % 80 == 0) {
            this.scream(living);
        }
        if (distance >= range) {
            if (this.f_19797_ % 20 == 0) {
                this.m_21573_().m_5624_((Entity)living, 1.0);
            }
        } else if (distance < range * 0.75) {
            if (this.f_19797_ % 20 == 0) {
                Vec3 vec3 = Utilities.generatePositionAway(living.m_20182_(), 10.0);
                this.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.5);
            }
        } else if (this.m_21573_().m_26571_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0).m_82549_(living.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82524_(90.0f)).m_82490_(this.m_21133_(Attributes.f_22279_) * 2.0));
        } else {
            this.m_21573_().m_26573_();
        }
        if (this.m_20186_() < living.m_20186_() + 4.0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 1200, 0));
        }
        return super.m_7327_(entity);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            public boolean m_8036_() {
                return Scavenger.this.canAttack() && super.m_8036_();
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.INF_VILLAGER_GROWL.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_VILLAGER_DEATH.get();
    }
}

