/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Experiments;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Experiment;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedWallMovementControl;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Saugling
extends Experiment {
    public static final EntityDataAccessor<Boolean> IS_HIDDEN = SynchedEntityData.m_135353_(Saugling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<BlockPos> CHEST_POS = SynchedEntityData.m_135353_(Saugling.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Boolean> PRIMED = SynchedEntityData.m_135353_(Saugling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int setTicksOut = 0;
    private int ticksOpen = 0;

    public Saugling(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21344_ = new WallClimberNavigation((Mob)this, level);
        this.f_21342_ = new InfectedWallMovementControl((Mob)this);
    }

    public boolean isHidden() {
        return (Boolean)this.f_19804_.m_135370_(IS_HIDDEN);
    }

    public void setIsHidden(boolean val) {
        this.f_19804_.m_135381_(IS_HIDDEN, (Object)val);
    }

    public boolean isPrimed() {
        return (Boolean)this.f_19804_.m_135370_(PRIMED);
    }

    public void setPrimed(boolean val) {
        this.f_19804_.m_135381_(PRIMED, (Object)val);
    }

    public BlockPos getChestPos() {
        return (BlockPos)this.f_19804_.m_135370_(CHEST_POS);
    }

    public void setChestPos(BlockPos val) {
        this.f_19804_.m_135381_(CHEST_POS, (Object)val);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.saugling_loot.get();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isHidden()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_20147_() {
        return this.isHidden();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_HIDDEN, (Object)false);
        this.f_19804_.m_135372_(CHEST_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(PRIMED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("hidden", ((Boolean)this.f_19804_.m_135370_(IS_HIDDEN)).booleanValue());
        tag.m_128379_("primed", ((Boolean)this.f_19804_.m_135370_(PRIMED)).booleanValue());
        tag.m_128405_("chestPosX", ((BlockPos)this.f_19804_.m_135370_(CHEST_POS)).m_123341_());
        tag.m_128405_("chestPosY", ((BlockPos)this.f_19804_.m_135370_(CHEST_POS)).m_123342_());
        tag.m_128405_("chestPosZ", ((BlockPos)this.f_19804_.m_135370_(CHEST_POS)).m_123343_());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(IS_HIDDEN, (Object)tag.m_128471_("hidden"));
        this.f_19804_.m_135381_(PRIMED, (Object)tag.m_128471_("primed"));
        int x = tag.m_128451_("chestPosX");
        int y = tag.m_128451_("chestPosY");
        int z = tag.m_128451_("chestPosZ");
        this.f_19804_.m_135381_(CHEST_POS, (Object)new BlockPos(x, y, z));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.sau_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.sau_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.sau_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public int getSetTicksOut() {
        return this.setTicksOut;
    }

    public void setSetTicksOut(int setTicksOut) {
        this.setTicksOut = setTicksOut;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new HideInChestGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.5, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 2.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
    }

    public boolean m_20145_() {
        return this.isHidden();
    }

    public boolean m_21525_() {
        return this.isHidden();
    }

    private void leapAtTarget(LivingEntity target) {
        Vec3 $$0 = this.m_20184_();
        Vec3 $$1 = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_(), this.m_20189_() - this.m_20189_());
        if ($$1.m_82556_() > 1.0E-7) {
            $$1 = $$1.m_82541_().m_82490_(0.4).m_82549_($$0.m_82490_(0.2));
        }
        this.m_20334_($$1.f_82479_, $$1.f_82480_, $$1.f_82481_);
    }

    private BlockPos findNearbyChest() {
        BlockPos mobPos = this.m_20183_();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)mobPos.m_7918_(-8, -2, -8), (BlockPos)mobPos.m_7918_(8, 2, 8))) {
            if (!this.f_19853_.m_8055_(pos).m_60713_(Blocks.f_50087_)) continue;
            return pos.m_7949_();
        }
        return BlockPos.f_121853_;
    }

    public boolean checkChest(Level level) {
        return level.m_8055_(this.getChestPos()).m_60713_(Blocks.f_50087_) && this.getChestPos() != BlockPos.f_121853_;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 60 == 0) {
            this.setChestPos(this.findNearbyChest());
        }
        if (this.setTicksOut > 0) {
            --this.setTicksOut;
        }
        if (this.isHidden() && this.f_19797_ % 20 == 0) {
            if (!this.checkChest(this.f_19853_)) {
                this.setIsHidden(false);
                this.setPrimed(false);
            }
            if (!this.isPrimed()) {
                AABB aabb = this.m_20191_().m_82400_(3.0);
                List livingEntities = this.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> {
                    if (!entity.m_6084_()) return false;
                    if (!this.TARGET_SELECTOR.test(entity)) return false;
                    if (!(entity instanceof Player)) return true;
                    Player player = (Player)entity;
                    if (player.m_150110_().f_35937_) return false;
                    if (player.m_5833_()) return false;
                    return true;
                });
                if (!livingEntities.isEmpty()) {
                    this.setPrimed(true);
                    this.m_6710_((LivingEntity)livingEntities.get(this.f_19796_.m_188503_(livingEntities.size())));
                    this.m_216990_((SoundEvent)Ssounds.SAUGLING_JUMPSCARE.get());
                }
            } else {
                this.setIsHidden(false);
                this.setPrimed(false);
                this.openChest(this.getChestPos());
                this.setSetTicksOut(100);
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.leapAtTarget(target);
                }
            }
        }
        if (this.ticksOpen > 0) {
            if (this.ticksOpen == 1) {
                this.closeChest(this.getChestPos());
            }
            --this.ticksOpen;
        }
    }

    public void hideInChest() {
        this.ticksOpen = 50;
        this.setIsHidden(true);
        this.setPrimed(false);
        this.openChest(this.getChestPos());
        if (this.f_19853_.m_8055_(this.getChestPos().m_7494_()).m_60795_()) {
            this.m_6021_((double)this.getChestPos().m_123341_() + 0.5, this.getChestPos().m_123342_() + 1, (double)this.getChestPos().m_123343_() + 0.5);
        }
    }

    public void openChest(BlockPos pos) {
        BlockEntity entity = this.f_19853_.m_7702_(pos);
        if (entity instanceof ChestBlockEntity) {
            ChestBlockEntity chestBlock = (ChestBlockEntity)entity;
            this.m_216990_(SoundEvents.f_11749_);
            this.f_19853_.m_7696_(pos, chestBlock.m_58900_().m_60734_(), 1, 1);
            this.f_19853_.m_46672_(pos, chestBlock.m_58900_().m_60734_());
            this.f_19853_.m_46672_(pos.m_7495_(), chestBlock.m_58900_().m_60734_());
        }
    }

    public void closeChest(BlockPos pos) {
        BlockEntity entity = this.f_19853_.m_7702_(pos);
        if (entity instanceof ChestBlockEntity) {
            ChestBlockEntity chestBlock = (ChestBlockEntity)entity;
            this.m_216990_(SoundEvents.f_11747_);
            this.f_19853_.m_7696_(pos, chestBlock.m_58900_().m_60734_(), 1, 0);
            this.f_19853_.m_46672_(pos, chestBlock.m_58900_().m_60734_());
            this.f_19853_.m_46672_(pos.m_7495_(), chestBlock.m_58900_().m_60734_());
        }
    }

    @Override
    public boolean isDormant() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return this.isHidden() ? (SoundEvent)Ssounds.SAUGLING_CHEST_AMBIENT.get() : (SoundEvent)Ssounds.SAUGLING_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return super.m_5639_(p_21237_, p_21238_) - 10;
    }

    public static class HideInChestGoal
    extends Goal {
        private final Saugling mob;

        public HideInChestGoal(Saugling mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.mob.isHidden() || this.mob.m_5448_() != null) {
                return false;
            }
            return this.mob.getChestPos() != BlockPos.f_121853_ && this.mob.getSetTicksOut() <= 0;
        }

        public void m_8056_() {
            if (this.mob.getChestPos() != null && this.mob.getChestPos() != BlockPos.f_121853_) {
                this.mob.setChestPos(this.mob.getChestPos());
                this.mob.m_21573_().m_26519_((double)this.mob.getChestPos().m_123341_(), (double)this.mob.getChestPos().m_123342_(), (double)this.mob.getChestPos().m_123343_(), 1.0);
            }
        }

        public void m_8037_() {
            if (this.mob.getChestPos() != null && this.mob.getChestPos() != BlockPos.f_121853_ && this.mob.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.mob.getChestPos())) < 1.5) {
                this.mob.hideInChest();
            }
        }
    }
}

