/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Hyper;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedWallMovementControl;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Wendigo
extends Hyper {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final UUID SPEED_MODIFIER_STALKING_UUID = UUID.fromString("7107DE5E-7CE8-4030-940E-514C1F160890");
    private static final AttributeModifier SPEED_MODIFIER_CRAWLING = new AttributeModifier(SPEED_MODIFIER_STALKING_UUID, "Crawling speed slowdown", (double)-0.15f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SPEED_MODIFIER_SPRINTING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Sprinting speed", (double)0.15f, AttributeModifier.Operation.ADDITION);
    public static final EntityDataAccessor<Boolean> IS_STALKING = SynchedEntityData.m_135353_(Wendigo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> STALKING_TIMEOUT = SynchedEntityData.m_135353_(Wendigo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> CAMO = SynchedEntityData.m_135353_(Wendigo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> IS_SPRINTING = SynchedEntityData.m_135353_(Wendigo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Wendigo(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21342_ = new InfectedWallMovementControl((Mob)this);
        this.f_19793_ = 1.0f;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("stalking", this.isStalking());
        tag.m_128405_("camo", this.getCamo());
        tag.m_128405_("stalking_timeout", this.getStalkingTimeout());
        tag.m_128405_("sprinting", this.getIsSprinting());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setIsStalking(tag.m_128471_("stalking"));
        this.setCamo(tag.m_128451_("camo"));
        this.setStalkingTimeout(tag.m_128451_("stalking_timeout"));
        this.setIsSprinting(tag.m_128451_("sprinting"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_STALKING, (Object)false);
        this.f_19804_.m_135372_(STALKING_TIMEOUT, (Object)0);
        this.f_19804_.m_135372_(CAMO, (Object)0);
        this.f_19804_.m_135372_(IS_SPRINTING, (Object)0);
    }

    public void setIsStalking(boolean value) {
        this.f_19804_.m_135381_(IS_STALKING, (Object)value);
    }

    public boolean isStalking() {
        return (Boolean)this.f_19804_.m_135370_(IS_STALKING);
    }

    public void setCamo(int value) {
        this.f_19804_.m_135381_(CAMO, (Object)value);
    }

    public int getCamo() {
        return (Integer)this.f_19804_.m_135370_(CAMO);
    }

    public void setStalkingTimeout(int value) {
        this.f_19804_.m_135381_(STALKING_TIMEOUT, (Object)value);
    }

    public int getStalkingTimeout() {
        return (Integer)this.f_19804_.m_135370_(STALKING_TIMEOUT);
    }

    public void setIsSprinting(int value) {
        this.f_19804_.m_135381_(IS_SPRINTING, (Object)value);
    }

    public int getIsSprinting() {
        return (Integer)this.f_19804_.m_135370_(IS_SPRINTING);
    }

    public boolean m_20142_() {
        return this.getIsSprinting() > 0;
    }

    public boolean m_6047_() {
        return this.isStalking();
    }

    public double getJumpRange() {
        return 300.0;
    }

    boolean isLookingAtMe(LivingEntity entity) {
        Vec3 vec3 = entity.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20188_() - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && entity.m_142582_((Entity)this);
    }

    boolean canStartStalking(LivingEntity livingEntity) {
        if (this.getStalkingTimeout() > 0) {
            return false;
        }
        if (livingEntity.m_20280_((Entity)this) < this.getJumpRange()) {
            return false;
        }
        if (this.isLookingAtMe(livingEntity)) {
            this.setStalkingTimeout(20);
            return false;
        }
        return true;
    }

    @Override
    public void m_6710_(@Nullable LivingEntity livingEntity) {
        super.m_6710_(livingEntity);
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (attributeinstance != null) {
            if (livingEntity != null && this.canStartStalking(livingEntity)) {
                if (!attributeinstance.m_22109_(SPEED_MODIFIER_CRAWLING)) {
                    attributeinstance.m_22118_(SPEED_MODIFIER_CRAWLING);
                }
            } else {
                attributeinstance.m_22130_(SPEED_MODIFIER_CRAWLING);
            }
            this.setIsStalking(attributeinstance.m_22109_(SPEED_MODIFIER_CRAWLING));
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.undressTarget(livingEntity);
        }
        return super.m_7327_(entity);
    }

    private void undressTarget(LivingEntity livingEntity) {
        this.dropItem(livingEntity, livingEntity.m_6844_(EquipmentSlot.HEAD), EquipmentSlot.HEAD);
        this.dropItem(livingEntity, livingEntity.m_6844_(EquipmentSlot.CHEST), EquipmentSlot.CHEST);
        this.dropItem(livingEntity, livingEntity.m_6844_(EquipmentSlot.LEGS), EquipmentSlot.LEGS);
        this.dropItem(livingEntity, livingEntity.m_6844_(EquipmentSlot.FEET), EquipmentSlot.FEET);
    }

    private void dropItem(LivingEntity livingEntity, ItemStack stack, EquipmentSlot slot) {
        if (Math.random() < (double)0.02f && Wendigo.shouldDropItemsPerSlot(slot)) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_36356_(stack);
            } else {
                ItemEntity entity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
                this.f_19853_.m_7967_((Entity)entity);
                livingEntity.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    public static boolean shouldDropItemsPerSlot(EquipmentSlot slot) {
        return (Boolean)SConfig.SERVER.wendigo_disarmor.get();
    }

    public List<SoundEvent> LureList() {
        ArrayList<SoundEvent> values = new ArrayList<SoundEvent>();
        values.add(SoundEvents.f_12503_);
        values.add(SoundEvents.f_12582_);
        values.add(SoundEvents.f_11899_);
        values.add(SoundEvents.f_11850_);
        values.add(SoundEvents.f_12307_);
        return values;
    }

    public void playSoundsNearTarget(Entity target) {
        SoundEvent soundEvent = this.LureList().get(this.f_19796_.m_188503_(this.LureList().size()));
        BlockPos pos = target.m_20097_();
        target.f_19853_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundEvent, target.m_5720_(), 1.0f, 1.0f);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.wendigo_loot.get();
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(3, (Goal)new AOEMeleeAttackGoal((PathfinderMob)this, 1.2, true, 1.2, 3.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.wendigo_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.wendigo_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.wendigo_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        LivingEntity entity;
        super.m_8119_();
        if (this.f_19797_ % 200 == 0 && this.isStalking() && (entity = this.m_5448_()) != null) {
            this.playSoundsNearTarget((Entity)entity);
        }
        if (this.f_19797_ % 20 == 0) {
            if (this.getStalkingTimeout() > 0) {
                this.setStalkingTimeout(this.getStalkingTimeout() - 1);
            }
            if (this.getIsSprinting() > 0) {
                this.setIsSprinting(this.getIsSprinting() - 1);
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null) {
            this.setStalkingTimeout(20);
        }
        return super.m_6469_(source, amount);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (IS_STALKING.equals(dataAccessor)) {
            if (this.m_5448_() != null && this.getIsSprinting() <= 0) {
                this.setIsSprinting(10);
                this.m_216990_((SoundEvent)Ssounds.WENDIGO_SCREECH.get());
            }
            this.setCamo(this.isStalking() ? this.getBiomeTint() : 0);
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (attributeinstance != null) {
            if (this.getIsSprinting() > 0 && !this.isStalking()) {
                if (!attributeinstance.m_22109_(SPEED_MODIFIER_SPRINTING)) {
                    attributeinstance.m_22118_(SPEED_MODIFIER_SPRINTING);
                }
            } else {
                attributeinstance.m_22130_(SPEED_MODIFIER_SPRINTING);
            }
        }
    }

    public int getBiomeTint() {
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        BlockPos blockpos = new BlockPos(i, j, k);
        Biome biome = (Biome)this.f_19853_.m_204166_(blockpos).m_203334_();
        return biome.m_47542_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.WENDIGO_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isStalking()) {
            return super.m_6972_(pose).m_20390_(2.2f, 0.35f);
        }
        return super.m_6972_(pose);
    }
}

