/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.SBlockEntities.ContainerBlockEntity;
import com.Harbinger.Spore.SBlockEntities.LivingStructureBlocks;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.FoliageSpread;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Signal;
import com.Harbinger.Spore.Sentities.Utility.InfectionTendril;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Mound
extends Organoid
implements Enemy,
FoliageSpread {
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(Mound.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COUNTER = SynchedEntityData.m_135353_(Mound.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_AGE = SynchedEntityData.m_135353_(Mound.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> STRUCTURE = SynchedEntityData.m_135353_(Mound.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LINKED = SynchedEntityData.m_135353_(Mound.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int maxCounter;
    private int attack_counter;

    public Mound(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.maxCounter = (Integer)SConfig.SERVER.mound_cooldown.get();
        this.attack_counter = 0;
    }

    protected int m_5639_(float p_149389_, float p_149390_) {
        return super.m_5639_(p_149389_, p_149390_) - 30;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.getLinked() && this.getMaxAge() <= 2;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.mound_loot.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 == 0) {
            Level level;
            if (this.m_6084_() && (Integer)this.f_19804_.m_135370_(AGE) < (Integer)this.f_19804_.m_135370_(MAX_AGE)) {
                this.getPersistentData().m_128405_("age", 1 + this.getPersistentData().m_128451_("age"));
                if (this.getPersistentData().m_128451_("age") >= (Integer)SConfig.SERVER.mound_age.get()) {
                    this.getPersistentData().m_128405_("age", 0);
                    this.f_19804_.m_135381_(AGE, (Object)((Integer)this.f_19804_.m_135370_(AGE) + 1));
                }
            }
            if ((Integer)this.f_19804_.m_135370_(COUNTER) < this.maxCounter) {
                this.setCounter(this.getCounter() + 1);
            }
            if (this.m_6084_() && this.getCounter() >= this.maxCounter && !this.f_19853_.f_46443_) {
                double range = switch ((Integer)this.f_19804_.m_135370_(AGE)) {
                    case 2 -> (Double)SConfig.SERVER.mound_range_age2.get();
                    case 3 -> (Double)SConfig.SERVER.mound_range_age3.get();
                    case 4 -> (Double)SConfig.SERVER.mound_range_age4.get();
                    default -> (Double)SConfig.SERVER.mound_range_default.get();
                };
                this.SpreadInfection(this.f_19853_, range, this.m_20097_());
                this.setCounter(0);
                if (this.f_19796_.m_188503_(10) == 0 && (Integer)this.f_19804_.m_135370_(AGE) >= 3 && this.checkForExtraTendrils((Entity)this, this.f_19853_)) {
                    this.SpreadKin((Entity)this, this.f_19853_);
                }
            }
            if (this.getCounter() > this.maxCounter - 2 && this.getCounter() < this.maxCounter && (level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.2) * 0.2;
                double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.5) * 0.5 * 10.0;
                double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.2) * 0.2;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.SPORE_PARTICLE.get()), x0, y0, z0, 9, 0.0, 0.0, 0.0, 1.0);
            }
            if (this.getCounter() == this.maxCounter - 2) {
                this.m_216990_((SoundEvent)Ssounds.PUFF.get());
            }
        }
        if (this.m_6084_() && this.attack_counter > 0) {
            --this.attack_counter;
        }
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("age", ((Integer)this.f_19804_.m_135370_(AGE)).intValue());
        tag.m_128405_("counter", ((Integer)this.f_19804_.m_135370_(COUNTER)).intValue());
        tag.m_128405_("max_age", ((Integer)this.f_19804_.m_135370_(MAX_AGE)).intValue());
        tag.m_128379_("structure", ((Boolean)this.f_19804_.m_135370_(STRUCTURE)).booleanValue());
        tag.m_128379_("linked", ((Boolean)this.f_19804_.m_135370_(LINKED)).booleanValue());
    }

    public int getAgeCounter() {
        return this.getPersistentData().m_128451_("age");
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(AGE, (Object)tag.m_128451_("age"));
        this.f_19804_.m_135381_(COUNTER, (Object)tag.m_128451_("counter"));
        this.f_19804_.m_135381_(MAX_AGE, (Object)tag.m_128451_("max_age"));
        this.f_19804_.m_135381_(STRUCTURE, (Object)tag.m_128471_("structure"));
        this.f_19804_.m_135381_(LINKED, (Object)tag.m_128471_("linked"));
    }

    public void setCounter(int counter) {
        this.f_19804_.m_135381_(COUNTER, (Object)counter);
    }

    public int getCounter() {
        return (Integer)this.f_19804_.m_135370_(COUNTER);
    }

    public int getMaxCounter() {
        return this.maxCounter;
    }

    public void setAge(int maxAge) {
        this.f_19804_.m_135381_(AGE, (Object)maxAge);
    }

    public void setMaxAge(int maxAge) {
        this.f_19804_.m_135381_(MAX_AGE, (Object)maxAge);
    }

    public int getMaxAge() {
        return (Integer)this.f_19804_.m_135370_(MAX_AGE);
    }

    public void setLinked(boolean value) {
        this.f_19804_.m_135381_(LINKED, (Object)value);
    }

    public boolean getLinked() {
        return (Boolean)this.f_19804_.m_135370_(LINKED);
    }

    @Override
    public void additionPlacers(Level level, BlockPos pos, double range) {
        AABB aabb = this.m_20191_().m_82400_(range);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = level.m_8055_(blockpos);
            BlockState above = level.m_8055_(blockpos.m_7494_());
            if (!(Math.random() < 0.1) || !above.m_60795_() || !blockstate.m_60804_((BlockGetter)level, blockpos) || !((Boolean)this.f_19804_.m_135370_(STRUCTURE)).booleanValue() || (Integer)this.f_19804_.m_135370_(AGE) < (Integer)this.f_19804_.m_135370_(MAX_AGE) || !(this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()) > 80.0)) continue;
            BlockState block4 = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("spore:block_st"))).getRandomElement(RandomSource.m_216327_()).orElse(Blocks.f_50016_).m_49966_();
            level.m_7731_(blockpos.m_7494_(), block4, 3);
            this.f_19804_.m_135381_(STRUCTURE, (Object)false);
        }
    }

    @Override
    public void additionIgnoreConfigPlacers(Level level, BlockPos pos, double range) {
        AABB aabb = this.m_20191_().m_82400_(range);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = level.m_8055_(blockpos);
            BlockState above = level.m_8055_(blockpos.m_7494_());
            if (!(Math.random() < 0.1) || !above.m_60795_() || !blockstate.m_60804_((BlockGetter)level, blockpos) || !((Boolean)this.f_19804_.m_135370_(STRUCTURE)).booleanValue() || (Integer)this.f_19804_.m_135370_(AGE) < (Integer)this.f_19804_.m_135370_(MAX_AGE) || !(this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()) > 80.0)) continue;
            BlockState block4 = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("spore:block_st"))).getRandomElement(RandomSource.m_216327_()).orElse(Blocks.f_50016_).m_49966_();
            level.m_7731_(blockpos.m_7494_(), block4, 3);
            this.f_19804_.m_135381_(STRUCTURE, (Object)false);
        }
        List entities = level.m_45976_(LivingEntity.class, aabb);
        for (LivingEntity en : entities) {
            if (en instanceof Infected || en instanceof UtilityEntity || ((List)SConfig.SERVER.blacklist.get()).contains(en.m_20078_()) || en.m_6844_(EquipmentSlot.HEAD).m_41720_() == Sitems.GAS_MASK.get()) continue;
            en.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 1));
        }
    }

    private void SpreadKin(Entity entity, Level level) {
        AABB aabb = entity.m_20191_().m_82400_((double)((Integer)SConfig.SERVER.mound_tendril_checker.get()).intValue());
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockState = level.m_8055_(blockpos);
            if (!(this.isStucture(blockpos) || this.isChestWithFood(blockpos) && (Boolean)SConfig.SERVER.tendril_chest.get() != false || blockState.m_60713_((Block)Sblocks.REMAINS.get()) && (Boolean)SConfig.SERVER.tendril_corpse.get() != false) && (!blockState.m_60713_(Blocks.f_50085_) || !((Boolean)SConfig.SERVER.tendril_spawner.get()).booleanValue())) continue;
            InfectionTendril tendril = new InfectionTendril((EntityType<? extends PathfinderMob>)((EntityType)Sentities.TENDRIL.get()), level);
            tendril.setAgeM(this.getMaxAge() - 1);
            tendril.setSearchArea(blockpos);
            tendril.m_6034_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_());
            level.m_7967_((Entity)tendril);
            break;
        }
    }

    private boolean isChestWithFood(BlockPos pos) {
        Container container;
        BlockEntity blockEntity = this.f_19853_.m_7702_(pos);
        if (blockEntity instanceof Container && !((container = (Container)blockEntity) instanceof ContainerBlockEntity)) {
            return container.m_216874_(ItemStack::m_41614_);
        }
        return false;
    }

    private boolean isStucture(BlockPos pos) {
        BlockEntity blockEntity = this.f_19853_.m_7702_(pos);
        return blockEntity instanceof LivingStructureBlocks;
    }

    private boolean checkForExtraTendrils(Entity entity, Level level) {
        AABB aabb = entity.m_20191_().m_82400_((double)((Integer)SConfig.SERVER.mound_tendril_checker.get()).intValue());
        List entities = level.m_45976_(InfectionTendril.class, aabb);
        return entities.size() <= 4;
    }

    @Override
    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (this.attack_counter == 0) {
            Mound entity = this;
            if (!((LivingEntity)entity).f_19853_.f_46443_) {
                AreaEffectCloud areaeffectcloud = new AreaEffectCloud(((LivingEntity)entity).f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                areaeffectcloud.m_19718_((LivingEntity)entity);
                areaeffectcloud.m_19712_(2.0f);
                areaeffectcloud.m_19734_(300);
                areaeffectcloud.m_19738_((1.5f * (float)((Integer)this.f_19804_.m_135370_(AGE)).intValue() - areaeffectcloud.m_19743_()) / (float)areaeffectcloud.m_19748_());
                areaeffectcloud.m_19716_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 200, 1));
                ((LivingEntity)entity).f_19853_.m_7967_((Entity)areaeffectcloud);
                this.m_5496_((SoundEvent)Ssounds.PUFF.get(), 0.5f, 0.5f);
                this.attack_counter = 300;
            }
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.mound_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.mound_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGE, (Object)1);
        this.f_19804_.m_135372_(COUNTER, (Object)0);
        this.f_19804_.m_135372_(MAX_AGE, (Object)4);
        this.f_19804_.m_135372_(STRUCTURE, (Object)true);
        this.f_19804_.m_135372_(LINKED, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        double health = (Double)SConfig.SERVER.mound_hp.get() * (double)((Integer)this.f_19804_.m_135370_(AGE)).intValue() * (Double)SConfig.SERVER.global_health.get();
        double armor = (Double)SConfig.SERVER.mound_armor.get() * (double)((Integer)this.f_19804_.m_135370_(AGE)).intValue() * (Double)SConfig.SERVER.global_armor.get();
        if (AGE.equals(dataAccessor)) {
            AttributeInstance hp = this.m_21051_(Attributes.f_22276_);
            AttributeInstance def = this.m_21051_(Attributes.f_22284_);
            if (hp != null) {
                hp.m_22100_(health);
            }
            if (def != null) {
                def.m_22100_(armor);
            }
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getAge() >= 1 ? 1.0f * (float)this.getAge() : 1.0f);
    }

    public void m_6667_(DamageSource source) {
        if (this.getLinked() && source.m_7639_() != null && this.getAge() > 3) {
            if (this.f_146808_ || this.Cold() || this.m_21225_() != null && this.m_21225_() == DamageSource.f_146701_) {
                return;
            }
            AABB searchbox = this.m_20191_().m_82400_((double)((Integer)SConfig.SERVER.proto_range.get()).intValue());
            List entities = this.f_19853_.m_6443_(Proto.class, searchbox, EntitySelector.f_20406_);
            for (Proto proto : entities) {
                int y = source.m_7640_() != null ? (int)source.m_7640_().m_20186_() : (int)this.m_20186_();
                proto.setSignal(new Signal(true, new BlockPos((int)this.m_20185_(), y, (int)this.m_20189_())));
            }
        }
        for (int i = 0; i <= this.getAge(); ++i) {
            super.m_6667_(source);
        }
    }

    @Override
    public boolean isCloseCombatant() {
        return true;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        this.setDefaultLinkage(this.f_19853_);
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void setDefaultLinkage(Level level) {
        ServerLevel serverLevel;
        SporeSavedData data;
        if (level instanceof ServerLevel && (data = SporeSavedData.getDataLocation(serverLevel = (ServerLevel)level)) != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get()) {
            this.setLinked(true);
        }
    }

    @Override
    public int getEmerge_tick() {
        return 40;
    }
}

