/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.Utility.WaveEntity;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.UmarmerVariants;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Umarmer
extends Organoid
implements VariantKeeper {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(Umarmer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.m_135353_(Umarmer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(Umarmer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HARD_ATTACK = SynchedEntityData.m_135353_(Umarmer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> PINNED = SynchedEntityData.m_135353_(Umarmer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHIELDING = SynchedEntityData.m_135353_(Umarmer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState pin_start = new AnimationState();
    public AnimationState pin_end = new AnimationState();
    public AnimationState pin_idle = new AnimationState();
    public AnimationState shield_idle = new AnimationState();
    public AnimationState shield_start = new AnimationState();
    public AnimationState shield_end = new AnimationState();
    public AnimationState squeeze_idle = new AnimationState();
    private int attackAnimationTimeout = 0;
    private int SlamAttackAnimationTimeout = 0;
    private int SlamAttackAnimationEndTimeout = 0;
    private int idlePinTimeout = 0;
    private int idleShieldTimeout = 0;
    private int startShieldTimeout = 0;
    private int endShieldTimeout = 0;
    private int squeezeTimeout = 0;
    private int chargeWave = 0;
    private boolean start_shield = false;
    private boolean end_shield = false;
    private boolean end_pin = false;

    public Umarmer(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public int getNumberOfParticles() {
        return 6;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.umarmer_loot.get();
    }

    @Override
    public int getEmerge_tick() {
        return 80;
    }

    @Override
    public int getBorrow_tick() {
        return 100;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.umarmed_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.umarmed_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.umarmed_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("timer", ((Integer)this.f_19804_.m_135370_(TIMER)).intValue());
        tag.m_128379_("pinned", ((Boolean)this.f_19804_.m_135370_(PINNED)).booleanValue());
        tag.m_128379_("shielded", ((Boolean)this.f_19804_.m_135370_(SHIELDING)).booleanValue());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(TIMER, (Object)tag.m_128451_("timer"));
        this.f_19804_.m_135381_(PINNED, (Object)tag.m_128471_("pinned"));
        this.f_19804_.m_135381_(SHIELDING, (Object)tag.m_128471_("shielded"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    public int getTimer() {
        return (Integer)this.f_19804_.m_135370_(TIMER);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            this.setupAnimationStates();
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null && this.chargeWave < 61) {
                ++this.chargeWave;
            }
            if (this.m_5448_() == null && (Integer)this.f_19804_.m_135370_(TIMER) < 2400) {
                this.f_19804_.m_135381_(TIMER, (Object)((Integer)this.f_19804_.m_135370_(TIMER) + 1));
            } else if ((Integer)this.f_19804_.m_135370_(TIMER) >= 2400) {
                this.tickBurrowing();
            }
        }
        if (!this.m_20160_() && this.isPinned()) {
            this.setPinned(false);
        }
    }

    private void setupAnimationStates() {
        if (this.isPinned() && this.idlePinTimeout <= 0) {
            this.idlePinTimeout = 40;
            this.pin_idle.m_216977_(this.f_19797_);
        } else {
            --this.idlePinTimeout;
        }
        if (this.start_shield && this.startShieldTimeout <= 0) {
            this.startShieldTimeout = 30;
            this.shield_start.m_216977_(this.f_19797_);
        } else {
            --this.startShieldTimeout;
            this.start_shield = false;
        }
        if (this.end_pin && this.SlamAttackAnimationEndTimeout <= 0) {
            this.SlamAttackAnimationEndTimeout = 40;
            this.pin_end.m_216977_(this.f_19797_);
        } else {
            --this.SlamAttackAnimationEndTimeout;
            this.end_pin = false;
        }
        if (this.end_shield && this.endShieldTimeout <= 0) {
            this.endShieldTimeout = 30;
            this.shield_end.m_216977_(this.f_19797_);
        } else {
            --this.endShieldTimeout;
            this.end_shield = false;
        }
        if (this.m_20160_() && !this.isPinned() && this.squeezeTimeout <= 0) {
            this.squeezeTimeout = 40;
            this.squeeze_idle.m_216977_(this.f_19797_);
        } else {
            --this.squeezeTimeout;
        }
        if (this.isShielding() && this.idleShieldTimeout <= 0) {
            this.idleShieldTimeout = 30;
            this.shield_idle.m_216977_(this.f_19797_);
        } else {
            --this.idleShieldTimeout;
        }
        if (this.startShieldTimeout <= 0) {
            this.shield_start.m_216973_();
        }
        if (this.endShieldTimeout <= 0) {
            this.shield_end.m_216973_();
        }
        if (this.IsAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (this.IsHardAttacking() && this.SlamAttackAnimationTimeout <= 0) {
            this.SlamAttackAnimationTimeout = 60;
            this.pin_start.m_216977_(this.f_19797_);
        } else {
            --this.SlamAttackAnimationTimeout;
        }
        if (!this.IsHardAttacking()) {
            this.pin_start.m_216973_();
        }
        if (!this.IsAttacking()) {
            this.attackAnimationState.m_216973_();
        }
        if (!this.isPinned()) {
            this.pin_idle.m_216973_();
        }
        if (!this.m_20160_()) {
            this.squeeze_idle.m_216973_();
        }
        if (!this.isShielding()) {
            this.shield_idle.m_216973_();
        }
    }

    public boolean m_21525_() {
        return this.isBurrowing() || this.isEmerging();
    }

    @Override
    public boolean m_6469_(DamageSource source, float value) {
        if (source.m_19360_()) {
            if (this.isShielding()) {
                return super.m_6469_(source, value / 4.0f);
            }
            this.setShielding(true);
        }
        if (this.isEmerging()) {
            return false;
        }
        return super.m_6469_(source, value);
    }

    protected void m_8099_() {
        this.addTargettingGoals();
        this.f_21345_.m_25352_(3, (Goal)new GrabTarget(this));
        this.f_21345_.m_25352_(4, (Goal)new UmarmedMeleeAttack(this, 0.0, false, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.f_21345_.m_25352_(4, (Goal)new PinAttack(this, 0.0, false));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && !Umarmer.this.m_20160_();
            }
        });
        super.m_8099_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(HARD_ATTACK, (Object)false);
        this.f_19804_.m_135372_(PINNED, (Object)false);
        this.f_19804_.m_135372_(SHIELDING, (Object)false);
        this.f_19804_.m_135372_(TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public boolean m_5825_() {
        return this.getVariant() == UmarmerVariants.CHARRED;
    }

    public void SetAttacking(boolean value) {
        this.f_19804_.m_135381_(ATTACKING, (Object)value);
    }

    public boolean IsAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setPinned(boolean value) {
        this.f_19804_.m_135381_(PINNED, (Object)value);
    }

    public boolean isPinned() {
        return (Boolean)this.f_19804_.m_135370_(PINNED);
    }

    public void SetHardAttacking(boolean value) {
        this.f_19804_.m_135381_(HARD_ATTACK, (Object)value);
    }

    public boolean IsHardAttacking() {
        return (Boolean)this.f_19804_.m_135370_(HARD_ATTACK);
    }

    public void setShielding(boolean value) {
        this.f_19804_.m_135381_(SHIELDING, (Object)value);
    }

    public boolean isShielding() {
        return (Boolean)this.f_19804_.m_135370_(SHIELDING);
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.f_19804_.m_135370_(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            this.m_146870_();
            burrowing = -1;
        }
        this.f_19804_.m_135381_(BORROW, (Object)(burrowing + 1));
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean m_20160_() {
        Entity entity;
        if (this.m_146895_() != null && (entity = this.m_146895_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.isPinned()) {
                this.m_21563_().m_24946_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
                livingEntity.m_20124_(Pose.SWIMMING);
            }
            livingEntity.m_147207_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 2), (Entity)this);
            livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 400, 1), (Entity)this);
        }
        return super.m_20160_();
    }

    public void m_7332_(Entity entity) {
        double y;
        Vec3 vec3;
        super.m_7332_(entity);
        if (this.isPinned()) {
            vec3 = new Vec3(2.0, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            y = -0.1;
        } else {
            vec3 = new Vec3(0.4, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            y = 1.2;
        }
        entity.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + y, this.m_20189_() + vec3.f_82481_);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getVariant() == UmarmerVariants.CHARRED) {
                livingEntity.m_20254_(10);
            } else if (this.getVariant() == UmarmerVariants.BILE) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 0));
            } else if (this.getVariant() == UmarmerVariants.CORROSIVE) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.CORROSION.get(), 600, 1));
            }
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 1));
            livingEntity.m_147240_((double)1.2f, (double)(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))), (double)Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))));
        }
        return super.m_7327_(entity);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        UmarmerVariants variant = (UmarmerVariants)((Object)Util.m_214670_((Object[])UmarmerVariants.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public UmarmerVariants getVariant() {
        return UmarmerVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        if (i > UmarmerVariants.values().length || i < 0) {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)0);
        } else {
            this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)i);
        }
    }

    @Override
    public int amountOfMutations() {
        return UmarmerVariants.values().length;
    }

    private void setVariant(UmarmerVariants variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.UMARMER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (PINNED.equals(dataAccessor)) {
            if (!this.isPinned()) {
                this.end_pin = true;
            }
            this.m_6210_();
        }
        if (SHIELDING.equals(dataAccessor)) {
            if (this.isShielding()) {
                this.start_shield = true;
            } else {
                this.end_shield = true;
            }
        }
        super.m_7350_(dataAccessor);
    }

    @Override
    public boolean isCloseCombatant() {
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isPinned()) {
            return super.m_6972_(pose).m_20390_(2.75f, 0.35f);
        }
        return super.m_6972_(pose);
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    static class GrabTarget
    extends Goal {
        Umarmer umarmer;
        int damage;

        public GrabTarget(Umarmer umarmer1) {
            this.umarmer = umarmer1;
        }

        public boolean m_8036_() {
            if (this.umarmer.m_20160_() && !this.umarmer.isPinned()) {
                return true;
            }
            return this.umarmer.m_5448_() != null && this.umarmer.f_19796_.m_188503_(15) == 0;
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.umarmer.m_5448_() != null && !this.umarmer.m_20160_() && this.umarmer.m_20280_((Entity)this.umarmer.m_5448_()) < 5.0) {
                this.umarmer.m_5448_().m_20329_((Entity)this.umarmer);
            }
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity target = this.umarmer.m_5448_();
            if (target != null && this.umarmer.m_146895_() == target) {
                if (this.damage >= 10) {
                    this.umarmer.m_7327_((Entity)target);
                    this.damage = 0;
                } else {
                    ++this.damage;
                }
            }
        }
    }

    static class UmarmedMeleeAttack
    extends AOEMeleeAttackGoal {
        private final Umarmer mob;
        private final int attackDelay = 10;
        private int ticksUntilNextAttack = 10;
        private boolean shouldCountTillNextAttack = false;

        public UmarmedMeleeAttack(Umarmer umarmer, double p_25553_, boolean p_25554_, Predicate<LivingEntity> livingEntityPredicate) {
            super(umarmer, p_25553_, p_25554_, 2.0, 1.0f, livingEntityPredicate);
            this.mob = umarmer;
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            if (this.mob.isPinned()) {
                return false;
            }
            if (this.mob.m_20160_()) {
                return false;
            }
            if (target != null && this.mob.m_20280_((Entity)target) > this.getAttackReachSqr(target)) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        protected double getAttackReachSqr(LivingEntity entity) {
            return 16.0 + (double)(entity.m_20205_() * entity.m_20205_());
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity entity, double at) {
            if (this.isEnemyWithinAttackDistance(entity, at)) {
                this.shouldCountTillNextAttack = true;
                if (this.isTimeToStartAttackAnimation()) {
                    this.mob.SetAttacking(true);
                    this.mob.setShielding(false);
                }
                if (this.isTimeToAttack()) {
                    this.mob.m_21563_().m_24946_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
                    this.performAttack(entity);
                }
            } else {
                this.resetAttackCooldown();
                this.shouldCountTillNextAttack = false;
                this.mob.SetAttacking(false);
                this.mob.attackAnimationTimeout = 0;
            }
        }

        private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
            return pDistToEnemySqr <= this.getAttackReachSqr(pEnemy);
        }

        @Override
        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }

        @Override
        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected boolean isTimeToStartAttackAnimation() {
            return this.ticksUntilNextAttack <= 10;
        }

        @Override
        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected void performAttack(LivingEntity pEnemy) {
            this.resetAttackCooldown();
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)pEnemy);
            AABB hitbox = pEnemy.m_20191_().m_82400_(this.box);
            List targets = pEnemy.f_19853_.m_6443_(LivingEntity.class, hitbox, this.victims);
            for (LivingEntity en : targets) {
                this.mob.m_7327_((Entity)en);
            }
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            if (this.shouldCountTillNextAttack) {
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            }
        }

        @Override
        public void m_8041_() {
            this.mob.SetAttacking(false);
            super.m_8041_();
        }
    }

    static class PinAttack
    extends CustomMeleeAttackGoal {
        private final Umarmer mob;
        private final int attackDelay = 55;
        private int ticksUntilNextAttack = 110;
        private boolean shouldCountTillNextAttack = false;

        public PinAttack(Umarmer umarmer, double p_25553_, boolean p_25554_) {
            super(umarmer, p_25553_, p_25554_);
            this.mob = umarmer;
        }

        @Override
        public boolean m_8036_() {
            if (this.mob.isPinned()) {
                return false;
            }
            if (this.mob.m_20160_()) {
                return false;
            }
            if (this.mob.chargeWave >= 60) {
                return true;
            }
            return super.m_8036_();
        }

        @Override
        protected double getAttackReachSqr(LivingEntity entity) {
            return 8.0 + (double)(entity.m_20205_() * entity.m_20205_());
        }

        @Override
        protected void checkAndPerformAttack(LivingEntity entity, double at) {
            if (this.isEnemyWithinAttackDistance(entity, at)) {
                this.shouldCountTillNextAttack = true;
                if (this.isTimeToStartAttackAnimation()) {
                    this.mob.SetHardAttacking(true);
                    this.mob.setShielding(false);
                }
                if (this.isTimeToAttack()) {
                    this.mob.m_21563_().m_24946_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
                    this.performAttack(entity);
                }
            } else if (!this.isEnemyWithinAttackDistance(entity, at) && this.mob.chargeWave >= 60) {
                this.shouldCountTillNextAttack = true;
                if (this.isTimeToStartAttackAnimation()) {
                    this.mob.SetHardAttacking(true);
                    this.mob.setShielding(false);
                    if (this.isTimeToAttack()) {
                        WaveEntity waveEntity = new WaveEntity(this.mob.f_19853_, this.mob);
                        this.mob.f_19853_.m_7967_((Entity)waveEntity);
                        this.mob.chargeWave = 0;
                    }
                }
            } else {
                this.resetAttackCooldown();
                this.shouldCountTillNextAttack = false;
                this.mob.SetHardAttacking(false);
                this.mob.attackAnimationTimeout = 0;
            }
        }

        @Override
        public boolean m_8045_() {
            if (this.mob.isPinned()) {
                return false;
            }
            return super.m_8045_();
        }

        private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
            return pDistToEnemySqr <= this.getAttackReachSqr(pEnemy);
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(110);
        }

        @Override
        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected boolean isTimeToStartAttackAnimation() {
            return this.ticksUntilNextAttack <= 55;
        }

        @Override
        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected void performAttack(LivingEntity pEnemy) {
            this.resetAttackCooldown();
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.setPinned(true);
            pEnemy.m_20329_((Entity)this.mob);
            this.mob.m_7327_((Entity)pEnemy);
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            if (this.shouldCountTillNextAttack) {
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            }
        }

        @Override
        public void m_8041_() {
            this.mob.SetHardAttacking(false);
            super.m_8041_();
        }
    }
}

