/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Knight;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

public class Verwa
extends Organoid {
    public static final EntityDataAccessor<String> STORED_MOB = SynchedEntityData.m_135353_(Verwa.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.m_135353_(Verwa.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState burst = new AnimationState();
    private int burstTimeout = 0;

    public Verwa(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("timer", ((Integer)this.f_19804_.m_135370_(TIMER)).intValue());
        tag.m_128359_("stored_mob", (String)this.f_19804_.m_135370_(STORED_MOB));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(TIMER, (Object)tag.m_128451_("timer"));
        this.f_19804_.m_135381_(STORED_MOB, (Object)tag.m_128461_("stored_mob"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TIMER, (Object)0);
        this.f_19804_.m_135372_(STORED_MOB, (Object)"spore:knight");
    }

    public Entity getStoredEntity() {
        ResourceLocation location = new ResourceLocation((String)this.f_19804_.m_135370_(STORED_MOB));
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
        if (entityType != null) {
            return entityType.m_20615_(this.f_19853_);
        }
        return new Knight((EntityType<? extends Monster>)((EntityType)Sentities.KNIGHT.get()), this.f_19853_);
    }

    public void TickTimer() {
        this.f_19804_.m_135381_(TIMER, (Object)((Integer)this.f_19804_.m_135370_(TIMER) + 1));
        if ((Integer)this.f_19804_.m_135370_(TIMER) > 40 && this.f_19853_.f_46443_) {
            this.ClientAnimation();
        }
        if ((Integer)this.f_19804_.m_135370_(TIMER) > 80) {
            this.f_19804_.m_135381_(TIMER, (Object)-1);
            this.SummonStoredEntity();
            this.tickBurrowing();
        }
    }

    public List<String> getDropList() {
        Object infected;
        List baseLoot = (List)SConfig.DATAGEN.verwa_loot.get();
        List<Object> storedLoot = new ArrayList();
        Entity entity = this.getStoredEntity();
        if (entity instanceof Infected && !((Infected)((Object)(infected = (Infected)entity))).getDropList().isEmpty()) {
            storedLoot = ((Infected)((Object)infected)).getDropList();
        }
        if ((entity = this.getStoredEntity()) instanceof UtilityEntity && !((UtilityEntity)((Object)(infected = (UtilityEntity)entity))).getDropList().isEmpty()) {
            storedLoot = ((UtilityEntity)((Object)infected)).getDropList();
        }
        ArrayList<String> combinedLoot = new ArrayList<String>();
        combinedLoot.addAll(baseLoot);
        combinedLoot.addAll(storedLoot);
        return combinedLoot;
    }

    public void SummonStoredEntity() {
        Entity entity = this.getStoredEntity();
        this.awardHivemind();
        if (entity instanceof LivingEntity) {
            Level level;
            LivingEntity living = (LivingEntity)entity;
            for (String string : (List)SConfig.SERVER.verwa_effect.get()) {
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(string));
                if (effect == null) continue;
                living.m_7292_(new MobEffectInstance(effect, 600, 1));
            }
            if (living instanceof Infected) {
                Infected infected = (Infected)living;
                infected.setLinked(true);
                infected.setPersistent(true);
            }
            if ((level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (living instanceof Mob) {
                    Mob mob = (Mob)living;
                    mob.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(this.m_20097_()), MobSpawnType.SPAWNER, null, null);
                }
            }
        }
        entity.m_6027_(this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_());
        this.f_19853_.m_7967_(entity);
    }

    public void ClientAnimation() {
        if (this.burstTimeout <= 0) {
            this.burstTimeout = 40;
            this.burst.m_216977_(this.f_19797_);
        } else {
            --this.burstTimeout;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isEmerging() && (Integer)this.f_19804_.m_135370_(TIMER) >= 0) {
            this.TickTimer();
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float p_21017_) {
        if (this.isEmerging()) {
            return false;
        }
        this.tickBurrowing();
        return super.m_6469_(source, p_21017_);
    }

    @Override
    public int getEmerge_tick() {
        return 40;
    }

    @Override
    public int getBorrow_tick() {
        return 60;
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.f_19804_.m_135370_(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            burrowing = -1;
            this.m_146870_();
        }
        this.f_19804_.m_135381_(BORROW, (Object)(burrowing + 1));
    }

    public void setStoredMob(String storedMob) {
        this.f_19804_.m_135381_(STORED_MOB, (Object)storedMob);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.verwa_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.verwa_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 8.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.WOMB_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        int i = ((List)SConfig.SERVER.verwa_summons.get()).size();
        this.f_19804_.m_135381_(STORED_MOB, (Object)((String)((List)SConfig.SERVER.verwa_summons.get()).get(this.f_19796_.m_188503_(i))));
        return super.m_6518_(serverLevelAccessor, p_33283_, p_33284_, p_33285_, p_33286_);
    }
}

