/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Variants.BulletParameters;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class AdaptableProjectile
extends Projectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AdaptableProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(AdaptableProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PARTICLES = SynchedEntityData.m_135353_(AdaptableProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AdaptableProjectile(Level level) {
        super((EntityType)Sentities.SPIT.get(), level);
    }

    public AdaptableProjectile(BulletParameters parameters, Level level, LivingEntity livingEntity) {
        super((EntityType)Sentities.SPIT.get(), level);
        this.m_5602_((Entity)livingEntity);
        this.setType(parameters.getId());
        this.setDamage(parameters.getDamage());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TYPE, (Object)0);
        this.f_19804_.m_135372_(PARTICLES, (Object)0);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(tag.m_128457_("damage")));
        this.f_19804_.m_135381_(TYPE, (Object)tag.m_128451_("type"));
        this.f_19804_.m_135381_(PARTICLES, (Object)tag.m_128451_("particles"));
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("damage", ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue());
        tag.m_128405_("type", ((Integer)this.f_19804_.m_135370_(TYPE)).intValue());
        tag.m_128405_("particles", ((Integer)this.f_19804_.m_135370_(PARTICLES)).intValue());
    }

    public void setType(int i) {
        this.f_19804_.m_135381_(TYPE, (Object)i);
    }

    public void setDamage(float i) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(i));
    }

    public void setParticles(int i) {
        this.f_19804_.m_135381_(PARTICLES, (Object)i);
    }

    public int getParticles() {
        return (Integer)this.f_19804_.m_135370_(PARTICLES);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected boolean m_5603_(Entity entity) {
        return entity != this.m_37282_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= 300) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_6034_(d0, d1, d2);
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        if (!this.f_19853_.m_5776_()) {
            Entity entity = entityHitResult.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity instanceof Infected || livingEntity instanceof UtilityEntity || ((List)SConfig.SERVER.blacklist.get()).contains(livingEntity.m_20078_())) {
                    return;
                }
                int type = (Integer)this.f_19804_.m_135370_(TYPE);
                DamageSource damageSource = this.m_37282_() != null ? DamageSource.m_19370_((LivingEntity)((LivingEntity)this.m_37282_())) : DamageSource.f_19318_;
                livingEntity.m_6469_(damageSource, ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue());
                if (type == 0) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 400, 3));
                } else if (type == 1) {
                    livingEntity.f_19853_.m_46511_(this.m_37282_(), livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 1.0f, Explosion.BlockInteraction.NONE);
                } else if (type == 2) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.CORROSION.get(), 600, 1));
                } else if (type == 3) {
                    livingEntity.m_20254_(6);
                }
                this.m_146870_();
            }
        } else {
            super.m_5790_(entityHitResult);
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        if (!this.f_19853_.f_46443_) {
            int type = (Integer)this.f_19804_.m_135370_(TYPE);
            Level level = this.f_19853_;
            if (type == 3 && level.m_8055_(blockHitResult.m_82425_()).isFlammable((BlockGetter)level, blockHitResult.m_82425_(), blockHitResult.m_82434_())) {
                this.f_19853_.m_7731_(blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_()), Blocks.f_50083_.m_49966_(), 3);
            }
            this.m_146870_();
        }
        super.m_8060_(blockHitResult);
    }
}

