/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Senchantments;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownBoomerang
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownBoomerang.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ThrownBoomerang.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private ItemStack boomerang = new ItemStack((ItemLike)Sitems.BOOMERANG.get());
    private boolean dealtDamage;
    private int returnTick;

    public ThrownBoomerang(Level level, LivingEntity owner, ItemStack stack, int color) {
        super((EntityType)Sentities.THROWN_BOOMERANG.get(), owner, level);
        this.boomerang = stack.m_41777_();
        this.f_19804_.m_135381_(ID_FOIL, (Object)stack.m_41790_());
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public ItemStack getBoomerang() {
        return this.boomerang;
    }

    public ThrownBoomerang(Level level) {
        this((EntityType<ThrownBoomerang>)((EntityType)Sentities.THROWN_BOOMERANG.get()), level);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public ThrownBoomerang(EntityType<ThrownBoomerang> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)0);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4 || this.returnTick++ > 35) {
            this.dealtDamage = true;
        }
        Entity owner = this.m_37282_();
        if ((this.dealtDamage || this.m_36797_()) && owner != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 direction = owner.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + direction.f_82480_ * 0.045, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(direction.m_82541_().m_82490_(0.15)));
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity owner = this.m_37282_();
        return owner != null && owner.m_6084_() && (!(owner instanceof ServerPlayer) || !owner.m_5833_());
    }

    protected ItemStack m_7941_() {
        return this.boomerang.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 from, Vec3 to) {
        return this.dealtDamage ? null : super.m_6351_(from, to);
    }

    protected void m_8060_(BlockHitResult p_36755_) {
        this.dealtDamage = true;
        super.m_8060_(p_36755_);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity owner;
        Entity target = result.m_82443_();
        float baseDamage = (float)((Integer)SConfig.SERVER.boomerang_damage.get()).intValue() + 0.5f * (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)this.boomerang);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            baseDamage += EnchantmentHelper.m_44833_((ItemStack)this.boomerang, (MobType)livingTarget.m_6336_());
        }
        DamageSource source = DamageSource.m_19337_((Entity)this, (Entity)((owner = this.m_37282_()) == null ? this : owner));
        this.dealtDamage = true;
        if (target.m_6469_(source, baseDamage)) {
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                if (owner instanceof LivingEntity) {
                    LivingEntity ownerLiving = (LivingEntity)owner;
                    EnchantmentHelper.m_44823_((LivingEntity)living, (Entity)ownerLiving);
                    EnchantmentHelper.m_44896_((LivingEntity)ownerLiving, (Entity)living);
                    Item item = this.boomerang.m_41720_();
                    if (item instanceof SporeWeaponData) {
                        SporeWeaponData data = (SporeWeaponData)item;
                        data.abstractMutationBuffs(living, ownerLiving, this.boomerang, data);
                    }
                }
                if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.boomerang) > 0) {
                    target.m_20254_(4 * EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.boomerang));
                }
                ThrownBoomerang.abstractEffects(this.boomerang, living);
                this.m_7761_(living);
            }
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
            this.m_5496_((SoundEvent)Ssounds.INFECTED_WEAPON_HIT_ENTITY.get(), 1.0f, 1.0f);
        }
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    public boolean m_20068_() {
        return true;
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)Ssounds.INFECTED_WEAPON_HIT_BLOCK.get();
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_37282_() == null) {
            super.m_6123_(player);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Boomerang", 10)) {
            this.boomerang = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Boomerang"));
        }
        this.dealtDamage = tag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(COLOR, (Object)tag.m_128451_("color"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Boomerang", (Tag)this.boomerang.m_41739_(new CompoundTag()));
        tag.m_128379_("DealtDamage", this.dealtDamage);
        tag.m_128405_("color", ((Integer)this.f_19804_.m_135370_(COLOR)).intValue());
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public static void abstractEffects(ItemStack stack, LivingEntity target) {
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.CORROSIVE_POTENCY.get()) > 0) {
            target.m_7292_(new MobEffectInstance((MobEffect)Seffects.CORROSION.get(), 200, 1));
        }
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.GASTRIC_SPEWAGE.get()) > 0) {
            for (MobEffectInstance effect : BileLiquid.bileEffects()) {
                target.m_7292_(effect);
            }
        }
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.CRYOGENIC_ASPECT.get()) > 0) {
            target.m_146917_(target.m_146888_() + 300);
        }
    }
}

