/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Fluids.BileLiquid;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.PlayMessages;

public class ThrownTumor
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(ThrownTumor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public MobEffect mobEffect;
    public int duration = 600;
    public int potion_level = 1;
    public Explosion.BlockInteraction explode = Explosion.BlockInteraction.NONE;

    public ThrownTumor(EntityType<? extends ThrownTumor> type, Level level) {
        super(type, level);
    }

    public ThrownTumor(Level level, LivingEntity entity) {
        super((EntityType)Sentities.THROWN_TUMOR.get(), entity, level);
    }

    public ThrownTumor(PlayMessages.SpawnEntity spawnEntity, Level level) {
        super((EntityType)Sentities.THROWN_TUMOR.get(), level);
    }

    protected Item m_7881_() {
        return switch ((Integer)this.f_19804_.m_135370_(TYPE)) {
            case 1 -> (Item)Sitems.SICKEN_TUMOR.get();
            case 2 -> (Item)Sitems.CALCIFIED_TUMOR.get();
            case 3 -> (Item)Sitems.FROZEN_TUMOR.get();
            case 4 -> (Item)Sitems.BILE_TUMOR.get();
            default -> (Item)Sitems.TUMOR.get();
        };
    }

    public void m_7822_(byte value) {
        if (value == 3) {
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
        }
    }

    public void setMobEffect(MobEffect effect) {
        this.mobEffect = effect;
    }

    public void setExplode(Explosion.BlockInteraction value) {
        this.explode = value;
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)((Integer)SConfig.SERVER.tumor_explosion.get()).intValue(), this.explode);
            AABB aabb = this.m_20191_().m_82400_(3.0);
            List entities = this.f_19853_.m_45933_((Entity)this, aabb);
            switch ((Integer)this.f_19804_.m_135370_(TYPE)) {
                case 0: {
                    this.summonPotionEffects();
                    break;
                }
                case 1: {
                    this.poisonTargets(entities);
                    break;
                }
                case 2: {
                    this.damageTargets(entities);
                    break;
                }
                case 3: {
                    this.freezeTargets(entities);
                    break;
                }
                case 4: {
                    this.bileTargets(entities);
                }
            }
            this.m_146870_();
        }
    }

    public void summonPotionEffects() {
        AreaEffectCloud cloud = (AreaEffectCloud)EntityType.f_20476_.m_20615_(this.f_19853_);
        if (this.mobEffect != null && cloud != null) {
            cloud.m_19716_(new MobEffectInstance(this.mobEffect, this.duration, this.potion_level));
            cloud.m_19734_(160);
            cloud.m_19712_(2.0f);
            cloud.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.f_19853_.m_7967_((Entity)cloud);
        }
    }

    public void poisonTargets(List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1));
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.CORROSION.get(), 200, 1));
        }
    }

    public void bileTargets(List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                livingEntity.m_7292_(instance);
            }
        }
    }

    public void freezeTargets(List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_19802_ = 0;
            livingEntity.m_6469_(DamageSource.f_146701_, 5.0f);
            livingEntity.m_146917_(this.m_146888_() + 200);
        }
    }

    public void damageTargets(List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            Entity entity2 = this.m_37282_();
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            livingEntity.f_20916_ = 0;
            livingEntity.f_19802_ = 0;
            livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)living), 10.0f);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(TYPE, (Object)tag.m_128451_("type"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("type", ((Integer)this.f_19804_.m_135370_(TYPE)).intValue());
    }

    public void setType(int value) {
        this.f_19804_.m_135381_(TYPE, (Object)value);
    }
}

