/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.BaseWeapons;

import com.Harbinger.Spore.Core.ScreativeTab;
import com.Harbinger.Spore.Core.Senchantments;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public abstract class SporeBaseArmor
extends ArmorItem
implements SporeArmorData {
    public final EnumMap<EquipmentSlot, UUID> UUIDS = (EnumMap)Util.m_137469_((Object)Maps.newEnumMap(EquipmentSlot.class), p_114874_ -> {
        p_114874_.put(EquipmentSlot.HEAD, UUID.fromString("bcd36ebc-8e7e-4598-b35d-de98063823f3"));
        p_114874_.put(EquipmentSlot.CHEST, UUID.fromString("8e55d62a-8302-4422-9f70-a1cb4efbb93e"));
        p_114874_.put(EquipmentSlot.LEGS, UUID.fromString("5424cab4-14d5-49c2-a4f0-b6778a728a0a"));
        p_114874_.put(EquipmentSlot.FEET, UUID.fromString("8cea5f8e-4b19-43ba-85de-91d49faf8c28"));
    });
    protected final int[] protection;
    protected final float f_40382_;
    protected float knockback;

    public SporeBaseArmor(EquipmentSlot type, final int[] durability, int[] protection, float toughness, float knockback, final SoundEvent soundEvent, final String name) {
        super(new ArmorMaterial(){

            public int m_7366_(EquipmentSlot type) {
                return durability[type.m_20749_()];
            }

            public int m_7365_(EquipmentSlot type) {
                return 0;
            }

            public int m_6646_() {
                return 0;
            }

            public SoundEvent m_7344_() {
                return soundEvent;
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Sitems.BIOMASS.get()});
            }

            public String m_6082_() {
                return name;
            }

            public float m_6651_() {
                return 0.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, new Item.Properties().m_41491_(ScreativeTab.SPORE));
        Sitems.TINTABLE_ITEMS.add((Item)this);
        Sitems.BIOLOGICAL_ITEMS.add((Item)this);
        this.protection = protection;
        this.f_40382_ = toughness;
        this.knockback = knockback;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = this.UUIDS.get(slot);
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", this.calculateTrueDefense(stack, this.protection[this.m_40402_().m_20749_()]) + this.modifyProtection(stack, this.protection[this.m_40402_().m_20749_()]), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor modifier", this.calculateTrueToughness(stack, this.f_40382_) + this.modifyToughness(stack, this.f_40382_), AttributeModifier.Operation.ADDITION));
        if (this.knockback > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", ((double)this.knockback + this.modifyKnockbackResistance(stack, this.knockback)) * (double)0.1f, AttributeModifier.Operation.ADDITION));
        }
        if (this.getVariant(stack) == SporeArmorMutations.DROWNED) {
            builder.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(uuid, "Armor Speed modifier", 0.25, AttributeModifier.Operation.ADDITION));
        }
        if (this.getVariant(stack) == SporeArmorMutations.REINFORCED || this.getVariant(stack) == SporeArmorMutations.SKELETAL) {
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Armor Speed modifier", this.getVariant(stack) == SporeArmorMutations.REINFORCED ? -0.01 : 0.01, AttributeModifier.Operation.ADDITION));
        }
        return slot == this.f_40377_ && this.tooHurt(stack) ? builder.build() : ImmutableMultimap.of();
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int durabilityLeft = stack.m_41776_() - stack.m_41773_();
        if (durabilityLeft - amount <= 11) {
            entity.m_216990_((SoundEvent)Ssounds.INFECTED_GEAR_BREAK.get());
        }
        if (this.tooHurt(stack)) {
            if (this.getAdditionalDurability(stack) > 0) {
                this.hurtExtraDurability(stack, amount, entity);
                return 0;
            }
            return super.damageItem(stack, this.calculateDurabilityLost(stack, amount), entity, onBroken);
        }
        return 0;
    }

    public int calculateDurabilityLost(ItemStack stack, int value) {
        if (this.getVariant(stack) == SporeArmorMutations.CHARRED) {
            return value * 2;
        }
        return value;
    }

    public int getEnchantmentValue(ItemStack stack) {
        int luck = this.getLuck(stack);
        return luck > 0 ? luck : 1;
    }

    public double modifyProtection(ItemStack stack, double value) {
        if (this.getVariant(stack) == SporeArmorMutations.REINFORCED) {
            return value * (double)0.2f;
        }
        if (this.getVariant(stack) == SporeArmorMutations.SKELETAL) {
            return value * (double)-0.2f;
        }
        return 0.0;
    }

    public double modifyToughness(ItemStack stack, double value) {
        if (this.getVariant(stack) == SporeArmorMutations.SKELETAL) {
            return 1.0;
        }
        return 0.0;
    }

    public double modifyKnockbackResistance(ItemStack stack, double value) {
        return 0.0;
    }

    public float calculateAdditionalDamage(DamageSource source, ItemStack stack, float value) {
        if (this.getVariant(stack) == SporeArmorMutations.CHARRED && source.m_19384_()) {
            return -value * 0.25f;
        }
        if (this.getVariant(stack) == SporeArmorMutations.DROWNED && source.m_19384_()) {
            return value * 0.25f;
        }
        return 0.0f;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        super.m_7373_(stack, p_41422_, components, p_41424_);
        if (!this.tooHurt(stack)) {
            components.add((Component)Component.m_237115_((String)"spore.item.hurt").m_130940_(ChatFormatting.RED));
        }
        if (Screen.m_96638_()) {
            if (this.getAdditionalProtection(stack) > 0.0) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.armor_increase").getString() + this.getAdditionalProtection(stack) + "%")));
            }
            if (this.getAdditionalToughness(stack) > 0.0) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.toughness_increase").getString() + this.getAdditionalToughness(stack) + "%")));
            }
            if (this.getMaxAdditionalDurability(stack) > 0) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.durability_increase").getString() + this.getMaxAdditionalDurability(stack) + "%")));
            }
            if (this.getAdditionalDurability(stack) > 0) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.additional_durability").getString() + this.getAdditionalDurability(stack))));
            }
            if (this.getEnchantmentValue(stack) > 0) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.enchant").getString() + this.getEnchantmentValue(stack))));
            }
            if (this.getVariant(stack) != SporeArmorMutations.DEFAULT) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.mutation").getString() + Component.m_237115_((String)this.getVariant(stack).getName()).getString())));
            }
        }
    }

    public boolean m_142305_(ItemStack stack, ItemStack itemStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        boolean shouldOverride;
        if (clickAction == ClickAction.SECONDARY && stack.getEnchantmentLevel((Enchantment)Senchantments.VORACIOUS_MAW.get()) > 0 && stack.m_41773_() > 0) {
            if (!itemStack.m_41614_()) {
                return false;
            }
            FoodProperties properties = itemStack.m_41720_().getFoodProperties(itemStack, null);
            if (properties != null && properties.m_38746_()) {
                stack.m_41721_(this.getDamage(stack) - 50);
                itemStack.m_41774_(1);
                player.m_6330_(SoundEvents.f_11912_, SoundSource.AMBIENT, 1.0f, 1.0f);
                return true;
            }
        }
        boolean bl = shouldOverride = clickAction == ClickAction.SECONDARY && itemStack.m_41720_() == Sitems.SYRINGE.get() && this.getVariant(stack) != SporeArmorMutations.DEFAULT;
        if (shouldOverride) {
            this.setVariant(SporeArmorMutations.DEFAULT, stack);
            itemStack.m_41774_(1);
            player.m_6330_((SoundEvent)Ssounds.SYRINGE_SUCK.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return shouldOverride;
    }
}

