/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.BaseWeapons;

import com.Harbinger.Spore.Core.ScreativeTab;
import com.Harbinger.Spore.Core.Senchantments;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.extensions.IForgeItem;
import org.jetbrains.annotations.Nullable;

public class SporeToolsBaseItem
extends Item
implements IForgeItem,
SporeWeaponData {
    protected final double meleeDamage;
    protected final double meleeReach;
    protected final double meleeRecharge;
    protected final int miningLevel;
    protected final UUID BONUS_DAMAGE_MODIFIER_UUID = UUID.fromString("035e66d6-5a74-402f-b64c-e61432ec39ba");
    protected final UUID BONUS_REACH_MODIFIER_UUID = UUID.fromString("d8c35ba5-f440-4335-92b2-3c8b1b703706");
    protected final UUID BONUS_RECHARGE_MODIFIER_UUID = UUID.fromString("6dee499d-60f9-4f91-9ae9-fa62f285cc24");

    public SporeToolsBaseItem(double meleeDamage, double meleeReach, double meleeRecharge, int durability, int miningLevel) {
        super(new Item.Properties().m_41487_(1).m_41503_(durability).m_41491_(ScreativeTab.SPORE));
        this.meleeDamage = meleeDamage;
        this.meleeReach = meleeReach;
        this.meleeRecharge = meleeRecharge;
        this.miningLevel = miningLevel;
        Sitems.TINTABLE_ITEMS.add(this);
    }

    public boolean m_6832_(ItemStack stack, ItemStack itemStack) {
        return super.m_6832_(stack, itemStack) || itemStack.m_41720_() == Sitems.BIOMASS.get();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.BONUS_DAMAGE_MODIFIER_UUID, "Tool modifier", this.calculateTrueDamage(stack, this.meleeDamage) + this.modifyDamage(stack, this.meleeDamage), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(this.BONUS_RECHARGE_MODIFIER_UUID, "Tool modifier", -this.meleeRecharge + this.modifyRecharge(stack), AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ATTACK_RANGE.get()), (Object)new AttributeModifier(this.BONUS_REACH_MODIFIER_UUID, "Tool modifier", this.meleeReach + this.modifyRange(stack), AttributeModifier.Operation.ADDITION));
        return slot == EquipmentSlot.MAINHAND && this.tooHurt(stack) ? builder.build() : ImmutableMultimap.of();
    }

    public float m_8102_(ItemStack stack, BlockState blockState) {
        return this.tooHurt(stack) ? (float)this.miningLevel : 1.0f;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        int luck = this.getLuck(stack);
        return luck > 0 ? luck : 1;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int durabilityLeft = stack.m_41776_() - stack.m_41773_();
        if (durabilityLeft - amount <= 11) {
            entity.m_216990_((SoundEvent)Ssounds.INFECTED_GEAR_BREAK.get());
        }
        if (durabilityLeft < 10) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (!this.tooHurt(stack) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36335_().m_41524_((Item)this, 60);
        }
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity living, LivingEntity entity) {
        if (this.tooHurt(stack)) {
            this.hurtTool(stack, entity, 1);
        }
        this.doEntityHurtAfterEffects(stack, living, entity);
        return super.m_7579_(stack, living, entity);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity living) {
        if (!this.tooHurt(stack)) {
            return false;
        }
        return super.m_6813_(stack, level, state, pos, living);
    }

    public boolean m_142522_(ItemStack stack) {
        return super.m_142522_(stack) || this.getAdditionalDurability(stack) > 0;
    }

    public int m_142159_(ItemStack stack) {
        if (this.getAdditionalDurability(stack) > 0) {
            return Mth.m_14169_((float)240.0f, (float)100.0f, (float)100.0f);
        }
        return super.m_142159_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        super.m_7373_(stack, p_41422_, components, p_41424_);
        if (!this.tooHurt(stack)) {
            components.add((Component)Component.m_237115_((String)"spore.item.hurt").m_130940_(ChatFormatting.RED));
        }
        if (Screen.m_96638_()) {
            if (this.getAdditionalDamage(stack) > 0.0) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.damage_increase").getString() + this.getAdditionalDamage(stack) + "%")));
            }
            if (this.getMaxAdditionalDurability(stack) > 0) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.durability_increase").getString() + this.getMaxAdditionalDurability(stack) + "%")));
            }
            if (this.getAdditionalDurability(stack) > 0) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.additional_durability").getString() + this.getAdditionalDurability(stack))));
            }
            if (this.getEnchantmentValue(stack) > 1) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.enchant").getString() + this.getEnchantmentValue(stack))));
            }
            if (this.getVariant(stack) != SporeToolsMutations.DEFAULT) {
                components.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"spore.item.mutation").getString() + Component.m_237115_((String)this.getVariant(stack).getName()).getString())));
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || ImmutableSet.of((Object)Enchantments.f_44977_, (Object)Enchantments.f_44981_, (Object)Enchantments.f_44980_, (Object)Enchantments.f_44982_, (Object)Enchantments.f_44978_).contains((Object)enchantment);
    }

    public boolean m_142305_(ItemStack stack, ItemStack itemStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        boolean shouldOverride;
        if (clickAction == ClickAction.SECONDARY && stack.getEnchantmentLevel((Enchantment)Senchantments.VORACIOUS_MAW.get()) > 0 && stack.m_41773_() > 0) {
            if (!itemStack.m_41614_()) {
                return false;
            }
            FoodProperties properties = itemStack.m_41720_().getFoodProperties(itemStack, null);
            if (properties != null && properties.m_38746_()) {
                stack.m_41721_(this.getDamage(stack) - 50);
                itemStack.m_41774_(1);
                player.m_6330_(SoundEvents.f_11912_, SoundSource.AMBIENT, 1.0f, 1.0f);
                return true;
            }
        }
        boolean bl = shouldOverride = clickAction == ClickAction.SECONDARY && itemStack.m_41720_() == Sitems.SYRINGE.get() && this.getVariant(stack) != SporeToolsMutations.DEFAULT;
        if (shouldOverride) {
            this.setVariant(SporeToolsMutations.DEFAULT, stack);
            itemStack.m_41774_(1);
            player.m_6330_((SoundEvent)Ssounds.SYRINGE_SUCK.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return shouldOverride;
    }
}

