/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Package.AdvancementGivingPackage;
import com.Harbinger.Spore.ExtremelySusThings.SporePacketHandler;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Experiment;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.Utility.Illusion;
import com.Harbinger.Spore.Sitems.OrganItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ScannerItem
extends Item {
    public ScannerItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack p_43419_) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack tool = player.m_21120_(hand);
        if (!level.f_46443_) {
            LivingEntity victim = this.getScannedEntity(player, level);
            if (victim != null) {
                player.m_6330_((SoundEvent)Ssounds.SCANNER_MOB.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                this.showInfo(tool, victim, player);
            } else {
                player.m_6330_((SoundEvent)Ssounds.SCANNER_EMPTY.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            player.m_36335_().m_41524_((Item)this, 20);
        }
        return InteractionResultHolder.m_19090_((Object)tool);
    }

    @Nullable
    public LivingEntity getScannedEntity(Player player, Level level) {
        AABB hitbox1 = this.getScannerHitBox(player, 10.0);
        List list = level.m_6249_((Entity)player, hitbox1, entity -> entity instanceof LivingEntity);
        Iterator var5 = list.iterator();
        double value = Double.MAX_VALUE;
        LivingEntity entity2 = null;
        while (var5.hasNext()) {
            LivingEntity $$3 = (LivingEntity)var5.next();
            if (!(player.m_20280_((Entity)$$3) < value)) continue;
            entity2 = $$3;
            value = player.m_20280_((Entity)$$3);
        }
        return entity2;
    }

    @Nullable
    public AABB getScannerHitBox(Player player, double range) {
        Vec3 lookVec = player.m_20154_();
        Vec3 endVec = player.m_20182_().m_82549_(lookVec.m_82490_(range));
        return new AABB(player.m_20182_(), endVec).m_82400_(1.0);
    }

    public void showInfo(ItemStack stack, LivingEntity entity, Player player) {
        if (!(stack.m_41720_() instanceof ScannerItem)) {
            return;
        }
        ItemStack offhand = player.m_21206_();
        boolean writeToBook = offhand.m_150930_(Items.f_42614_);
        ArrayList<String> lines = new ArrayList<String>();
        if (entity instanceof Illusion) {
            this.sendScanMessage(player, lines, "spore.scanner.line.15");
            return;
        }
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40));
        String name = entity.m_7770_() != null ? entity.m_7770_().getString() : Component.m_237115_((String)"spore.scanner.line.1").getString();
        lines.add("------------------");
        lines.add(Component.m_237115_((String)"spore.scanner.line.2").getString() + name);
        lines.add(Component.m_237115_((String)"spore.scanner.line.3").getString() + Component.m_237115_((String)entity.m_6095_().m_20675_()).getString());
        lines.add(Component.m_237115_((String)"spore.scanner.line.4").getString() + entity.m_21223_() + "/" + entity.m_21233_());
        this.addExtraInfo(entity, lines);
        String danger = this.showThreatLevel(entity);
        if (danger != null) {
            lines.add("------------------");
            lines.add(Component.m_237115_((String)"spore.scanner.line.5").getString() + Component.m_237115_((String)danger).getString());
        }
        this.addDrops(entity, lines);
        if (writeToBook) {
            this.writeLinesToBook(offhand, lines);
        } else {
            for (String line : lines) {
                player.m_5661_((Component)Component.m_237113_((String)line), false);
            }
        }
    }

    public String showThreatLevel(LivingEntity living) {
        if (living instanceof Calamity) {
            return "spore.scanner.danger.calamity";
        }
        if (living instanceof Hyper) {
            return "spore.scanner.danger.hyper";
        }
        if (living instanceof EvolvedInfected) {
            return "spore.scanner.danger.evolved";
        }
        if (living instanceof Experiment) {
            return "spore.scanner.danger.experiment";
        }
        if (living instanceof Infected) {
            return "spore.scanner.danger.infected";
        }
        if (living instanceof Organoid) {
            return "spore.scanner.danger.organoid";
        }
        if (living instanceof UtilityEntity) {
            return "spore.scanner.danger.utility";
        }
        return null;
    }

    private void sendScanMessage(Player player, List<String> lines, String key) {
        String msg = Component.m_237115_((String)key).getString();
        lines.add(msg);
        player.m_5661_((Component)Component.m_237113_((String)msg), false);
    }

    private void addExtraInfo(LivingEntity entity, List<String> lines) {
        if (entity instanceof Infected) {
            Infected infected = (Infected)entity;
            lines.add(Component.m_237115_((String)"spore.scanner.line.6").getString() + infected.getKills());
            lines.add(Component.m_237115_((String)"spore.scanner.line.7").getString() + infected.getEvoPoints());
            if (infected.getEvolutionCoolDown() > 0) {
                lines.add(Component.m_237115_((String)"spore.scanner.line.8").getString() + infected.getEvolutionCoolDown() + "/" + SConfig.SERVER.evolution_age_human.get());
            }
            if (infected.getHunger() > 0) {
                lines.add(Component.m_237115_((String)"spore.scanner.line.9").getString() + infected.getHunger() + "/" + SConfig.SERVER.hunger.get());
            }
            lines.add(Component.m_237115_((String)"spore.scanner.line.10").getString() + infected.getLinked());
            if (infected.getMutation() != null) {
                lines.add(Component.m_237115_((String)infected.getMutation()).getString());
            }
            if (infected instanceof Scamper) {
                Scamper scamper = (Scamper)infected;
                lines.add(Component.m_237115_((String)"spore.scanner.line.scamper").getString() + scamper.getAge() + "/" + SConfig.SERVER.scamper_age.get());
            }
        }
    }

    private void addDrops(LivingEntity living, List<String> lines) {
        List<? extends String> itemDrops = null;
        if (living instanceof Infected) {
            Infected infected = (Infected)living;
            itemDrops = infected.getDropList();
        } else if (living instanceof UtilityEntity) {
            UtilityEntity utilityEntity = (UtilityEntity)living;
            itemDrops = utilityEntity.getDropList();
        }
        if (itemDrops == null || itemDrops.isEmpty()) {
            lines.add(Component.m_237115_((String)"spore.scanner.line.13").getString());
        } else {
            lines.add("------------------");
            lines.add(Component.m_237115_((String)"spore.scanner.line.14").getString());
            for (String string : itemDrops) {
                String[] split = string.split("\\|");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
                if (item == null) continue;
                lines.add(Component.m_237115_((String)item.m_5524_()).getString());
            }
        }
    }

    private void writeLinesToBook(ItemStack bookStack, List<String> lines) {
        CompoundTag nbt = bookStack.m_41784_();
        ListTag nbtPages = nbt.m_128425_("pages", 9) ? nbt.m_128437_("pages", 8) : new ListTag();
        List<String> pages = new ArrayList<String>();
        for (int i = 0; i < nbtPages.size(); ++i) {
            pages.add(nbtPages.m_128778_(i));
        }
        StringBuilder lastPage = pages.isEmpty() ? new StringBuilder() : new StringBuilder((String)pages.remove(pages.size() - 1));
        for (String line : lines) {
            if (lastPage.length() + line.length() + 1 > 256) {
                pages.add(lastPage.toString());
                lastPage = new StringBuilder();
            }
            lastPage.append(line).append("\n");
        }
        if (!lastPage.isEmpty()) {
            pages.add(lastPage.toString());
        }
        if (pages.size() > 50) {
            pages = pages.subList(pages.size() - 50, pages.size());
        }
        ListTag newPagesTag = new ListTag();
        for (String pageContent : pages) {
            newPagesTag.add((Object)StringTag.m_129297_((String)pageContent));
        }
        nbt.m_128365_("pages", (Tag)newPagesTag);
    }

    public boolean m_142207_(@NotNull ItemStack stack, Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        ItemStack itemStack = slot.m_7993_();
        Item item = itemStack.m_41720_();
        if (item instanceof OrganItem) {
            OrganItem organItem = (OrganItem)item;
            if (clickAction == ClickAction.SECONDARY) {
                player.m_6330_((SoundEvent)Ssounds.SCANNER_ITEM.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                SporePacketHandler.sendToServer(new AdvancementGivingPackage(organItem.getAdvancementIds(), player.m_19879_()));
                return true;
            }
        }
        return false;
    }
}

