/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore;

import com.Harbinger.Spore.Core.SAttributes;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.SMenu;
import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Senchantments;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sfeatures;
import com.Harbinger.Spore.Core.Sfluids;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Spaintings;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Core.Spotion;
import com.Harbinger.Spore.Core.Srecipes;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.BiomeModification;
import com.Harbinger.Spore.ExtremelySusThings.SporePacketHandler;
import com.Harbinger.Spore.ExtremelySusThings.StructureModification;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="spore")
public class Spore {
    public static Spore instance;
    public static final String MODID = "spore";
    public static final Logger LOGGER;

    public Spore() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SConfig.DATAGEN_SPEC, "sporedata.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SConfig.SERVER_SPEC, "sporeconfig.toml");
        SConfig.loadConfig(SConfig.SERVER_SPEC, FMLPaths.CONFIGDIR.get().resolve("sporeconfig.toml").toString());
        modEventBus.addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Sblocks.register(modEventBus);
        Sitems.register(modEventBus);
        Senchantments.register(modEventBus);
        Sentities.register(modEventBus);
        Seffects.register(modEventBus);
        Spotion.register(modEventBus);
        Sparticles.register(modEventBus);
        Ssounds.register(modEventBus);
        SAttributes.register(modEventBus);
        Sfeatures.register(modEventBus);
        Sfluids.SPORE_FLUID_TYPE.register(modEventBus);
        Sfluids.SPORE_FLUID.register(modEventBus);
        SMenu.register(modEventBus);
        Srecipes.register(modEventBus);
        Spaintings.register(modEventBus);
        SblockEntities.register(modEventBus);
        SporePacketHandler.registerPackets();
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MODID);
        biomeModifiers.register(modEventBus);
        biomeModifiers.register("inf_spawns", BiomeModification::makeCodec);
        DeferredRegister structureModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (String)MODID);
        structureModifiers.register(modEventBus);
        structureModifiers.register("spore_structure_spawns", StructureModification::makeCodec);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (RegistryObject type : Sentities.SPORE_ENTITIES.getEntries()) {
                EntityType entityType = (EntityType)type.get();
                if (Spore.blacklist().contains(entityType)) continue;
                try {
                    SpawnPlacements.m_21754_((EntityType)entityType, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Infected::checkMonsterInfectedRules);
                }
                catch (Exception e) {
                    ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
                    LOGGER.warn("Could not apply custom placement {}: {}", (Object)id, (Object)e.getMessage());
                }
            }
        });
    }

    private static List<EntityType<?>> blacklist() {
        ArrayList values = new ArrayList();
        values.add((EntityType)Sentities.PLAGUED.get());
        values.add((EntityType)Sentities.LACERATOR.get());
        values.add((EntityType)Sentities.BIOBLOOB.get());
        values.add((EntityType)Sentities.SAUGLING.get());
        return values;
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
    }
}

