/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Sentities.Projectile.FleshBomb;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BileRound<T extends FleshBomb>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("spore", "bileround"), "main");
    private final ModelPart BileMissile;
    private final ModelPart Tumor;
    private final ModelPart Tendrils;

    public BileRound() {
        ModelPart root = BileRound.createBodyLayer().m_171564_();
        this.BileMissile = root.m_171324_("BileMissile");
        this.Tumor = this.BileMissile.m_171324_("Tail").m_171324_("Biomass");
        this.Tendrils = this.BileMissile.m_171324_("Tail").m_171324_("Tendrils");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition BileMissile = partdefinition.m_171599_("BileMissile", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.7859f, -7.8591f, -5.8501f, 12.0f, 16.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.2141f, (float)15.8591f, (float)-0.1499f));
        PartDefinition Bile_r1 = BileMissile.m_171599_("Bile_r1", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.9698f, (float)-2.0944f, (float)3.4616f, (float)0.2877f, (float)-0.5467f, (float)-0.5175f));
        PartDefinition Bile_r2 = BileMissile.m_171599_("Bile_r2", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-3.0f, -1.0f, -7.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.7859f, (float)0.1409f, (float)0.1499f, (float)-0.2877f, (float)-0.5467f, (float)0.5175f));
        PartDefinition Tail = BileMissile.m_171599_("Tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.2141f, (float)-7.8591f, (float)0.1499f));
        PartDefinition Biomass2 = Tail.m_171599_("Biomass", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.4335f, (float)3.0f, (float)-3.3512f));
        PartDefinition Biomass_r1 = Biomass2.m_171599_("Biomass_r1", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-3.5f, -3.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.9926f, (float)-2.3258f, (float)0.612f, (float)0.3699f, (float)0.7124f, (float)0.2154f));
        PartDefinition Biomass_r2 = Biomass2.m_171599_("Biomass_r2", CubeListBuilder.m_171558_().m_171514_(2, 30).m_171488_(-2.5f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.8902f, (float)-2.4341f, (float)6.7892f, (float)-0.1987f, (float)-0.4755f, (float)0.1473f));
        PartDefinition Biomass_r3 = Biomass2.m_171599_("Biomass_r3", CubeListBuilder.m_171558_().m_171514_(1, 29).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.2826f, (float)-1.3864f, (float)-0.1536f, (float)0.0f, (float)0.5236f, (float)0.3491f));
        PartDefinition Biomass_r4 = Biomass2.m_171599_("Biomass_r4", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-3.5f, -3.5f, -3.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.2467f, (float)-2.5148f, (float)7.8847f, (float)-0.1801f, (float)-0.3913f, (float)0.0164f));
        PartDefinition Tendrils = Tail.m_171599_("Tendrils", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition root_3 = Tendrils.m_171599_("root_3", CubeListBuilder.m_171558_().m_171514_(28, 28).m_171488_(-1.0f, -8.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.8403f, (float)0.6943f, (float)1.558f, (float)0.0f, (float)-0.5672f, (float)0.0f));
        PartDefinition r3seg2 = root_3.m_171599_("r3seg2", CubeListBuilder.m_171558_().m_171514_(36, 28).m_171488_(-1.0f, -9.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0138f, (float)-8.4634f, (float)-0.0145f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition r3seg3 = r3seg2.m_171599_("r3seg3", CubeListBuilder.m_171558_().m_171514_(44, 28).m_171488_(-0.5f, -9.0f, -0.5f, 1.0f, 10.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0815f, (float)-8.5697f, (float)-0.0142f));
        PartDefinition root_2 = Tendrils.m_171599_("root_2", CubeListBuilder.m_171558_().m_171514_(28, 28).m_171488_(-1.0f, -10.5f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.0041f, (float)0.6943f, (float)-1.4346f, (float)0.0f, (float)0.5672f, (float)0.0f));
        PartDefinition r2seg2 = root_2.m_171599_("r2seg2", CubeListBuilder.m_171558_().m_171514_(36, 28).m_171488_(-1.0f, -11.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0138f, (float)-10.4634f, (float)-0.0145f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition r2seg3 = r2seg2.m_171599_("r2seg3", CubeListBuilder.m_171558_().m_171514_(44, 28).m_171488_(-0.5f, -11.0f, -0.5f, 1.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0815f, (float)-10.5697f, (float)-0.0142f));
        PartDefinition root_1 = Tendrils.m_171599_("root_1", CubeListBuilder.m_171558_().m_171514_(28, 28).m_171488_(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9959f, (float)0.6943f, (float)1.5654f));
        PartDefinition r1seg2 = root_1.m_171599_("r1seg2", CubeListBuilder.m_171558_().m_171514_(36, 28).m_171488_(-1.0f, -7.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0138f, (float)-6.4634f, (float)-0.0145f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition r1seg3 = r1seg2.m_171599_("r1seg3", CubeListBuilder.m_171558_().m_171514_(44, 28).m_171488_(-0.5f, -7.0f, -0.5f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0815f, (float)-6.5697f, (float)-0.0142f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void animateTumor(ModelPart part, float value) {
        part.f_233553_ = 1.0f + Mth.m_14089_((float)(value / 6.0f)) / 6.0f;
        part.f_233554_ = 1.0f + Mth.m_14089_((float)(value / 6.0f)) / 6.0f;
        part.f_233555_ = 1.0f + Mth.m_14089_((float)(value / 6.0f)) / 6.0f;
    }

    private void animateTendril(ModelPart part, float value) {
        part.f_104203_ = Mth.m_14031_((float)(value / 9.0f)) / 2.0f;
        part.f_104204_ = Mth.m_14031_((float)(value / 9.0f)) / 3.0f;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animateTumor(this.Tumor, ageInTicks);
        this.animateTendril(this.Tendrils.m_171324_("root_3"), ageInTicks);
        this.animateTendril(this.Tendrils.m_171324_("root_3").m_171324_("r3seg2"), ageInTicks);
        this.animateTendril(this.Tendrils.m_171324_("root_3").m_171324_("r3seg2").m_171324_("r3seg3"), ageInTicks);
        this.animateTendril(this.Tendrils.m_171324_("root_2"), ageInTicks);
        this.animateTendril(this.Tendrils.m_171324_("root_2").m_171324_("r2seg2"), ageInTicks);
        this.animateTendril(this.Tendrils.m_171324_("root_2").m_171324_("r2seg2").m_171324_("r2seg3"), ageInTicks);
        this.animateTendril(this.Tendrils.m_171324_("root_1"), ageInTicks);
        this.animateTendril(this.Tendrils.m_171324_("root_1").m_171324_("r1seg2"), ageInTicks);
        this.animateTendril(this.Tendrils.m_171324_("root_1").m_171324_("r1seg2").m_171324_("r1seg3"), ageInTicks);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.BileMissile.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

