/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.CustomArmorLayer;
import com.Harbinger.Spore.Client.Models.InfectedPlayerModel;
import com.Harbinger.Spore.Client.Models.InfectedTechnoModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedPlayer;
import com.Harbinger.Spore.Sentities.Variants.InfPlayerSkins;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InfectedPlayerRenderer
extends BaseInfectedRenderer<InfectedPlayer, HumanoidModel<InfectedPlayer>> {
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/inf_player.png");
    private final HumanoidModel<InfectedPlayer> mainModel = (HumanoidModel)this.m_7200_();
    private final HumanoidModel<InfectedPlayer> technoSkin;
    private final HumanoidModel<InfectedPlayer> madnessModel;
    public static final Map<InfPlayerSkins, ResourceLocation> MAIN_TEXTURES = (Map)Util.m_137469_((Object)Maps.newEnumMap(InfPlayerSkins.class), p_114874_ -> {
        p_114874_.put(InfPlayerSkins.STEVE, new ResourceLocation("spore", "textures/entity/player/inf_player_steve.png"));
        p_114874_.put(InfPlayerSkins.ALEX, new ResourceLocation("spore", "textures/entity/player/inf_player_alex.png"));
        p_114874_.put(InfPlayerSkins.EFE, new ResourceLocation("spore", "textures/entity/player/inf_player_efe.png"));
        p_114874_.put(InfPlayerSkins.MAKENA, new ResourceLocation("spore", "textures/entity/player/inf_player_makena.png"));
        p_114874_.put(InfPlayerSkins.SUNNY, new ResourceLocation("spore", "textures/entity/player/inf_player_sunny.png"));
        p_114874_.put(InfPlayerSkins.ZURI, new ResourceLocation("spore", "textures/entity/player/inf_player_zuri.png"));
        p_114874_.put(InfPlayerSkins.ARI, new ResourceLocation("spore", "textures/entity/player/inf_player_ari.png"));
        p_114874_.put(InfPlayerSkins.KAI, new ResourceLocation("spore", "textures/entity/player/inf_player_kai.png"));
        p_114874_.put(InfPlayerSkins.NO0R, new ResourceLocation("spore", "textures/entity/player/inf_player_noor.png"));
    });
    public static final Map<InfPlayerSkins, ResourceLocation> MADNESS_TEXTURES = (Map)Util.m_137469_((Object)Maps.newEnumMap(InfPlayerSkins.class), p_114874_ -> {
        p_114874_.put(InfPlayerSkins.STEVE, new ResourceLocation("minecraft:textures/entity/player/wide/steve.png"));
        p_114874_.put(InfPlayerSkins.ALEX, new ResourceLocation("minecraft:textures/entity/player/wide/alex.png"));
        p_114874_.put(InfPlayerSkins.EFE, new ResourceLocation("minecraft:textures/entity/player/wide/efe.png"));
        p_114874_.put(InfPlayerSkins.MAKENA, new ResourceLocation("minecraft:textures/entity/player/wide/makena.png"));
        p_114874_.put(InfPlayerSkins.SUNNY, new ResourceLocation("minecraft:textures/entity/player/wide/sunny.png"));
        p_114874_.put(InfPlayerSkins.ZURI, new ResourceLocation("minecraft:textures/entity/player/wide/zuri.png"));
        p_114874_.put(InfPlayerSkins.ARI, new ResourceLocation("minecraft:textures/entity/player/wide/ari.png"));
        p_114874_.put(InfPlayerSkins.KAI, new ResourceLocation("minecraft:textures/entity/player/wide/kai.png"));
        p_114874_.put(InfPlayerSkins.NO0R, new ResourceLocation("minecraft:textures/entity/player/wide/noor.png"));
    });
    public static final Map<Component, ResourceLocation> SPECIAL_SKINS = new HashMap<Component, ResourceLocation>(){
        {
            this.put(Component.m_237113_((String)"Technoblade"), new ResourceLocation("spore", "textures/entity/player/techno_skin.png"));
            this.put(Component.m_237113_((String)"CODATOWER"), new ResourceLocation("spore", "textures/entity/player/inf_coda_skin.png"));
            this.put(Component.m_237113_((String)"Flash62724"), new ResourceLocation("spore", "textures/entity/player/inf_player_slasher.png"));
            this.put(Component.m_237113_((String)"TVGuy"), new ResourceLocation("spore", "textures/entity/player/inf_player_blura.png"));
            this.put(Component.m_237113_((String)"mrlambert6"), new ResourceLocation("spore", "textures/entity/player/inf_player_lambert.png"));
            this.put(Component.m_237113_((String)"NexouuZ"), new ResourceLocation("spore", "textures/entity/player/inf_player_nexouuz.png"));
            this.put(Component.m_237113_((String)"SyrCrypt"), new ResourceLocation("spore", "textures/entity/player/inf_player_syrcrypt.png"));
            this.put(Component.m_237113_((String)"KaratFeng"), new ResourceLocation("spore", "textures/entity/player/inf_karat_skin.png"));
            this.put(Component.m_237113_((String)"BigXplosion"), new ResourceLocation("spore", "textures/entity/player/inf_explosion_skin.png"));
            this.put(Component.m_237113_((String)"Toasteroni"), new ResourceLocation("spore", "textures/entity/player/inf_player_toast.png"));
            this.put(Component.m_237113_((String)"Dr_Pilot_MOO"), new ResourceLocation("spore", "textures/entity/player/dr_pilot_moo.png"));
            this.put(Component.m_237113_((String)"UnmeiHa"), new ResourceLocation("spore", "textures/entity/player/inf_player_nunny.png"));
            this.put(Component.m_237113_((String)"AllToAshes"), new ResourceLocation("spore", "textures/entity/player/inf_player_alltoashes.png"));
            this.put(Component.m_237113_((String)"0dna"), new ResourceLocation("spore", "textures/entity/player/inf_player_0dna.png"));
            this.put(Component.m_237113_((String)"PedroHenrry"), new ResourceLocation("spore", "textures/entity/player/inf_player_pedro.png"));
        }
    };

    public InfectedPlayerRenderer(EntityRendererProvider.Context context) {
        super(context, new InfectedPlayerModel(context.m_174023_(InfectedPlayerModel.LAYER_LOCATION)), 0.5f);
        this.madnessModel = new HumanoidModel(context.m_174023_(ModelLayers.f_171162_));
        this.technoSkin = new InfectedTechnoModel<InfectedPlayer>(context.m_174023_(InfectedTechnoModel.LAYER_LOCATION));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_(new CustomArmorLayer(this));
    }

    public ResourceLocation getTextureLocation(InfectedPlayer infectedPlayer) {
        if (this.isTheViewerMad(infectedPlayer)) {
            return MADNESS_TEXTURES.get((Object)infectedPlayer.getVariant());
        }
        Component component = infectedPlayer.m_7755_();
        ResourceLocation location = SPECIAL_SKINS.get(component);
        if (location != null) {
            return location;
        }
        return MAIN_TEXTURES.get((Object)infectedPlayer.getVariant());
    }

    public boolean isTheViewerMad(InfectedPlayer infectedPlayer) {
        Entity entity = Minecraft.m_91087_().f_91075_;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MobEffectInstance instance = player.m_21124_((MobEffect)Seffects.MADNESS.get());
            return instance != null && instance.m_19564_() > 0 && player.m_20270_((Entity)infectedPlayer) > 30.0f;
        }
        return false;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    public void render(InfectedPlayer type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.f_115290_ = this.isTheViewerMad(type) ? this.madnessModel : (Objects.equals(type.m_7770_(), Component.m_237113_((String)"Technoblade")) ? this.technoSkin : this.mainModel);
        super.m_7392_(type, value1, value2, stack, bufferSource, light);
    }
}

