/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.InfectedSpearModel;
import com.Harbinger.Spore.Sentities.Projectile.ThrownSpear;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpearRenderer
extends EntityRenderer<ThrownSpear> {
    public static final ResourceLocation Spear_LOCATION = new ResourceLocation("spore", "textures/entity/infected_spear.png");
    private final InfectedSpearModel<ThrownSpear> model;

    public SpearRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new InfectedSpearModel(context.m_174023_(InfectedSpearModel.LAYER_LOCATION));
    }

    public void render(ThrownSpear spear, float p_116112_, float p_116113_, PoseStack stack, MultiBufferSource p_116115_, int p_116116_) {
        int color = spear.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)p_116113_, (float)spear.f_19859_, (float)spear.m_146908_()) - 90.0f));
        stack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)p_116113_, (float)spear.f_19860_, (float)spear.m_146909_()) + 90.0f));
        VertexConsumer vertexconsumer = ItemRenderer.m_115222_((MultiBufferSource)p_116115_, (RenderType)this.model.m_103119_(this.getTextureLocation(spear)), (boolean)false, (boolean)spear.isFoil());
        this.model.m_7695_(stack, vertexconsumer, p_116116_, OverlayTexture.f_118083_, r, g, b, 1.0f);
        stack.m_85849_();
        super.m_7392_((Entity)spear, p_116112_, p_116113_, stack, p_116115_, p_116116_);
    }

    public ResourceLocation getTextureLocation(ThrownSpear p_116109_) {
        return Spear_LOCATION;
    }
}

