/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ChunkLoadRequest {
    private ChunkPos[] chunkPositionsToLoad;
    private int priority;
    private final String requestID;
    private final long tickAmount;
    private long ticksUntilExpiration;
    private final UUID ownerUUID;
    private final ResourceKey<Level> dimension;

    public ChunkLoadRequest(ResourceKey<Level> dimension, ChunkPos[] chunkPositionsToLoad, int priority, String requestID, long ticksUntilExpiration, UUID ownerUUID) {
        this.chunkPositionsToLoad = chunkPositionsToLoad;
        this.priority = priority;
        this.requestID = requestID;
        this.tickAmount = ticksUntilExpiration;
        this.ticksUntilExpiration = ticksUntilExpiration;
        this.ownerUUID = ownerUUID;
        this.dimension = dimension;
    }

    public ChunkPos[] getChunkPositionsToLoad() {
        return this.chunkPositionsToLoad;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTickAmount() {
        return this.tickAmount;
    }

    public ServerLevel getDimension() {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(this.dimension);
    }

    public String getRequestID() {
        return this.requestID;
    }

    public boolean isRequestID(String requestID) {
        return Objects.equals(this.requestID, requestID);
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public boolean isExpired() {
        return this.ticksUntilExpiration <= 0L;
    }

    public void decrementTicksUntilExpiration(int amountToDecrement) {
        this.ticksUntilExpiration -= (long)amountToDecrement;
    }

    public long getTicksUntilExpiration() {
        return this.ticksUntilExpiration;
    }

    private void setTicksUntilExpiration(long value) {
        this.ticksUntilExpiration = value;
    }

    public boolean isHigherPriorityThan(ChunkLoadRequest other) {
        return this.priority < other.priority;
    }

    public boolean doesContainChunk(ChunkPos chunkPos) {
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            if (!pos.equals((Object)chunkPos)) continue;
            return true;
        }
        return false;
    }

    public boolean isOwnerStillPresentInChunk() {
        if (this.ownerUUID == null) {
            return false;
        }
        ServerLevel level = this.getDimension();
        if (level == null) {
            return false;
        }
        Entity entity = level.m_8791_(this.ownerUUID);
        if (entity == null || !entity.m_6084_()) {
            return false;
        }
        ChunkPos entityPos = new ChunkPos(entity.m_20183_());
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            if (!pos.equals((Object)entityPos)) continue;
            return true;
        }
        return false;
    }

    public boolean refreshIfOwnerStillPresent(long newDurationTicks) {
        if (this.isOwnerStillPresentInChunk()) {
            this.ticksUntilExpiration = newDurationTicks;
            return true;
        }
        return false;
    }

    public void removeChunk(ChunkPos chunkPos) {
        if (!this.doesContainChunk(chunkPos)) {
            return;
        }
        ChunkPos[] newChunkPositionsToLoad = new ChunkPos[this.chunkPositionsToLoad.length - 1];
        int index = 0;
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            if (pos.equals((Object)chunkPos)) continue;
            newChunkPositionsToLoad[index++] = pos;
        }
        this.chunkPositionsToLoad = newChunkPositionsToLoad;
    }

    public void addChunk(ChunkPos chunkPos) {
        if (this.doesContainChunk(chunkPos)) {
            return;
        }
        ChunkPos[] newChunkPositionsToLoad = new ChunkPos[this.chunkPositionsToLoad.length + 1];
        System.arraycopy(this.chunkPositionsToLoad, 0, newChunkPositionsToLoad, 0, this.chunkPositionsToLoad.length);
        newChunkPositionsToLoad[this.chunkPositionsToLoad.length] = chunkPos;
        this.chunkPositionsToLoad = newChunkPositionsToLoad;
    }

    public void setChunkPositionsToLoad(ChunkPos[] chunkPositionsToLoad) {
        this.chunkPositionsToLoad = chunkPositionsToLoad;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("RequestID", this.requestID);
        tag.m_128405_("Priority", this.priority);
        tag.m_128356_("TicksUntilExpiration", this.ticksUntilExpiration);
        tag.m_128356_("StartTickValue", this.tickAmount);
        if (this.ownerUUID != null) {
            tag.m_128362_("OwnerUUID", this.ownerUUID);
        }
        tag.m_128359_("Dimension", this.dimension.m_135782_().toString());
        ListTag chunks = new ListTag();
        for (ChunkPos pos : this.chunkPositionsToLoad) {
            CompoundTag c = new CompoundTag();
            c.m_128405_("X", pos.f_45578_);
            c.m_128405_("Z", pos.f_45579_);
            chunks.add((Object)c);
        }
        tag.m_128365_("Chunks", (Tag)chunks);
        return tag;
    }

    public static ChunkLoadRequest deserializeNBT(CompoundTag tag) {
        String requestID = tag.m_128461_("RequestID");
        int priority = tag.m_128451_("Priority");
        long ticksUntilExpiration = tag.m_128454_("TicksUntilExpiration");
        long startTicks = tag.m_128454_("StartTickValue");
        UUID ownerUUID = tag.m_128403_("OwnerUUID") ? tag.m_128342_("OwnerUUID") : null;
        ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("Dimension")));
        ListTag chunksList = tag.m_128437_("Chunks", 10);
        ChunkPos[] positions = new ChunkPos[chunksList.size()];
        for (int i = 0; i < chunksList.size(); ++i) {
            CompoundTag c = chunksList.m_128728_(i);
            positions[i] = new ChunkPos(c.m_128451_("X"), c.m_128451_("Z"));
        }
        ChunkLoadRequest request = new ChunkLoadRequest((ResourceKey<Level>)dimKey, positions, priority, requestID, startTicks, ownerUUID);
        request.setTicksUntilExpiration(ticksUntilExpiration);
        return request;
    }
}

