/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.Core.SAttributes;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.LeapGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.FallenMultipart.HowitzerArm;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.Projectile.FleshBomb;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.Sentities.Utility.NukeEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Howitzer
extends Calamity
implements TrueCalamity,
RangedAttackMob {
    public static final EntityDataAccessor<Float> RIGHT_ARM = SynchedEntityData.m_135353_(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LEFT_ARM = SynchedEntityData.m_135353_(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> ORES = SynchedEntityData.m_135353_(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> NUKE = SynchedEntityData.m_135353_(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SELF_DETONATION = SynchedEntityData.m_135353_(Howitzer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final CalamityMultipart[] subEntities;
    public final CalamityMultipart rightArm;
    public final CalamityMultipart leftArm;
    public final CalamityMultipart mouth;
    public int getLeapTime = 0;
    @Nullable
    private BlockPos Targetpos;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.HOWI_CANNON1, HitboxesForParts.HOWI_CANNON2, HitboxesForParts.HOWI_CANNON3, HitboxesForParts.HOWI_LEFT_LEG, HitboxesForParts.HOWI_RIGHT_LEG, HitboxesForParts.HOWI_SACK);

    public Howitzer(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.rightArm = new CalamityMultipart(this, "rightarm", 2.0f, 4.0f);
        this.leftArm = new CalamityMultipart(this, "leftarm", 2.0f, 4.0f);
        this.mouth = new CalamityMultipart(this, "mouth", 4.0f, 3.0f);
        this.subEntities = new CalamityMultipart[]{this.rightArm, this.leftArm, this.mouth};
        this.m_274367_(1.5f);
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.howit_dpsr.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.howit_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.howit_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.howit_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_((Attribute)SAttributes.TOXICITY.get(), 0.0).m_22268_((Attribute)SAttributes.REJUVENATION.get(), 0.0).m_22268_((Attribute)SAttributes.LOCALIZATION.get(), 0.0).m_22268_((Attribute)SAttributes.LACERATION.get(), 0.0).m_22268_((Attribute)SAttributes.CORROSIVES.get(), 0.0).m_22268_((Attribute)SAttributes.BALLISTIC.get(), 0.0).m_22268_((Attribute)SAttributes.GRINDING.get(), 0.0);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.m_5496_((SoundEvent)Ssounds.LANDING.get(), 0.5f, 0.5f);
        return super.m_7327_(entity);
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new LeapGoal((Mob)this, 0.9f){

            @Override
            public boolean m_8036_() {
                return Howitzer.this.getGetLeapTime() <= 0 && Howitzer.this.hasBothArms() && Howitzer.this.isInMeleeRange() && super.m_8036_();
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                Howitzer.this.setLeapTicks(200);
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new AOEMeleeAttackGoal(this, 1.0, true, 2.0, 5.0f, e -> this.TARGET_SELECTOR.test(e)){

            @Override
            public boolean m_8036_() {
                return Howitzer.this.isInMeleeRange() && super.m_8036_();
            }

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                float f = Howitzer.this.m_20205_();
                return f * 1.5f * f * 1.5f + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new HowitzerRangedAttackGoal(this, 1.0, 80, 64.0f, 1, 5){

            @Override
            public boolean m_8036_() {
                return !Howitzer.this.isInMeleeRange() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new SearchAroundGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new FloatDiveGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new CalamityInfectedCommand(this));
        this.f_21345_.m_25352_(7, (Goal)new SummonScentInCombat(this));
        this.f_21345_.m_25352_(8, (Goal)new SporeBurstSupport(this));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void m_8107_() {
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
        }
        this.tickPart(this.mouth, Vec3.f_82478_, 5.0);
        if (this.getRightArmHp() > 0.0f) {
            this.tickPart(this.rightArm, new Vec3(-3.85, 0.0, 4.0));
        } else {
            this.tickPart(this.rightArm, Vec3.f_82478_);
            this.rightArm.m_20191_().m_82377_(1.0, 0.3, 1.0);
        }
        if (this.getLeftArmHp() > 0.0f) {
            this.tickPart(this.leftArm, new Vec3(3.85, 0.0, -4.0));
        } else {
            this.tickPart(this.leftArm, Vec3.f_82478_);
            this.leftArm.m_20191_().m_82377_(1.0, 0.3, 1.0);
        }
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].f_19854_ = avec3[l].f_82479_;
            this.subEntities[l].f_19855_ = avec3[l].f_82480_;
            this.subEntities[l].f_19856_ = avec3[l].f_82481_;
            this.subEntities[l].f_19790_ = avec3[l].f_82479_;
            this.subEntities[l].f_19791_ = avec3[l].f_82480_;
            this.subEntities[l].f_19792_ = avec3[l].f_82481_;
        }
        super.m_8107_();
    }

    public void tickDetonation() {
        if ((Integer)this.f_19804_.m_135370_(SELF_DETONATION) >= 30) {
            NukeEntity nukeEntity = new NukeEntity((EntityType)Sentities.NUKE.get(), this.m_9236_());
            nukeEntity.setInitRange(3.0f);
            nukeEntity.setRange((float)((Double)SConfig.SERVER.nuke_range.get() * 2.0));
            nukeEntity.setInitDuration(0);
            nukeEntity.setDuration((Integer)SConfig.SERVER.nuke_time.get());
            nukeEntity.setDamage((float)((Double)SConfig.SERVER.nuke_damage.get() * 1.0));
            nukeEntity.livingEntityPredicate = this.TARGET_SELECTOR;
            nukeEntity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_9236_().m_7967_((Entity)nukeEntity);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Utilities.explodeCircle(serverLevel, (Entity)this, this.m_20097_(), 15.0, (float)((Double)SConfig.SERVER.howit_damage.get() * 1.0), 8.0, entity -> {
                    LivingEntity livingEntity;
                    return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(livingEntity = (LivingEntity)entity);
                });
            }
            this.m_146870_();
        } else {
            this.f_19804_.m_135381_(SELF_DETONATION, (Object)((Integer)this.f_19804_.m_135370_(SELF_DETONATION) + 1));
        }
    }

    public int getSelfDetonation() {
        return (Integer)this.f_19804_.m_135370_(SELF_DETONATION);
    }

    public boolean hasBothArms() {
        return this.getRightArmHp() > 0.0f && this.getLeftArmHp() > 0.0f;
    }

    public boolean isInMeleeRange() {
        LivingEntity living = this.m_5448_();
        return living != null && this.m_20280_((Entity)living) < 200.0;
    }

    public int getGetLeapTime() {
        return this.getLeapTime;
    }

    public void setLeapTicks(int i) {
        this.getLeapTime = i;
    }

    public CalamityMultipart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket entityPacket) {
        super.m_141965_(entityPacket);
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        if (calamityMultipart == this.mouth) {
            this.m_6469_(source, value * 2.0f);
        } else if (calamityMultipart == this.rightArm) {
            this.m_6469_(source, value * 1.5f);
            float lostHealth = this.getRightArmHp() - this.m_21161_(source, value);
            this.setRightArmHp(lostHealth > 0.0f ? lostHealth : (this.getRightArmHp() != 0.0f ? this.summonDetashedPart(true) : 0.0f));
        } else if (calamityMultipart == this.leftArm) {
            this.m_6469_(source, value * 1.5f);
            float lostHealth = this.getLeftArmHp() - this.m_21161_(source, value);
            this.setLeftArmHp(lostHealth > 0.0f ? lostHealth : (this.getLeftArmHp() != 0.0f ? this.summonDetashedPart(false) : 0.0f));
        } else {
            this.m_6469_(source, value);
        }
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && this.f_19796_.m_188501_() < 0.2f) {
            this.m_6710_(null);
        }
        if (source.m_276093_(DamageTypes.f_268444_)) {
            this.f_19804_.m_135381_(NUKE, (Object)0);
        }
        if (this.m_21223_() <= 50.0f && this.isRadioactive() && this.getSelfDetonation() <= 0) {
            this.tickDetonation();
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public int chemicalRange() {
        return 16;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.howit_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.howit_debuffs.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIGHT_ARM, (Object)Float.valueOf(this.getMaxArmHp()));
        this.f_19804_.m_135372_(LEFT_ARM, (Object)Float.valueOf(this.getMaxArmHp()));
        this.f_19804_.m_135372_(ORES, (Object)0);
        this.f_19804_.m_135372_(NUKE, (Object)0);
        this.f_19804_.m_135372_(SELF_DETONATION, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("right_arm", ((Float)this.f_19804_.m_135370_(RIGHT_ARM)).floatValue());
        tag.m_128350_("left_arm", ((Float)this.f_19804_.m_135370_(LEFT_ARM)).floatValue());
        tag.m_128405_("ores", ((Integer)this.f_19804_.m_135370_(ORES)).intValue());
        tag.m_128405_("nuke", ((Integer)this.f_19804_.m_135370_(NUKE)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(RIGHT_ARM, (Object)Float.valueOf(tag.m_128457_("right_arm")));
        this.f_19804_.m_135381_(LEFT_ARM, (Object)Float.valueOf(tag.m_128457_("left_arm")));
        this.f_19804_.m_135381_(ORES, (Object)tag.m_128451_("ores"));
        this.f_19804_.m_135381_(NUKE, (Object)tag.m_128451_("nuke"));
    }

    public float getRightArmHp() {
        return ((Float)this.f_19804_.m_135370_(RIGHT_ARM)).floatValue();
    }

    public void setRightArmHp(float i) {
        this.f_19804_.m_135381_(RIGHT_ARM, (Object)Float.valueOf(i));
    }

    public float getLeftArmHp() {
        return ((Float)this.f_19804_.m_135370_(LEFT_ARM)).floatValue();
    }

    public void setLeftArmHp(float i) {
        this.f_19804_.m_135381_(LEFT_ARM, (Object)Float.valueOf(i));
    }

    public float getMaxArmHp() {
        return (float)((Double)SConfig.SERVER.howit_hp.get() / 4.0);
    }

    public boolean m_142582_(Entity entity) {
        if (this.canEntitySeeTheSky(entity) || entity.m_20280_((Entity)this) < 200.0) {
            return true;
        }
        return super.m_142582_(entity);
    }

    private boolean canEntitySeeTheSky(Entity entity) {
        return entity.m_9236_().m_45527_(entity.m_20097_());
    }

    @Override
    protected int m_5639_(float p_149389_, float p_149390_) {
        if (this.getLeapTime > 140) {
            this.damageStomp(this.m_9236_(), this.m_20097_(), 12.0, 8.0);
        }
        return super.m_5639_(p_149389_, p_149390_) - 25;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getGetLeapTime() > 0) {
            --this.getLeapTime;
        }
        if (this.f_19797_ % 20 == 0 && this.m_21223_() == this.m_21233_()) {
            if (this.getRightArmHp() < this.getMaxArmHp()) {
                this.setRightArmHp(this.getRightArmHp() + 1.0f);
            }
            if (this.getLeftArmHp() < this.getMaxArmHp()) {
                this.setLeftArmHp(this.getLeftArmHp() + 1.0f);
            }
        }
        if (this.f_19797_ % 20 == 0) {
            this.createBomb();
            if (this.isRadioactive()) {
                this.spreadRadiation();
            }
        }
        if (this.f_19797_ % 200 == 0) {
            this.searchBlocks();
        }
        if (this.isRadioactive() && this.getSelfDetonation() > 0) {
            if (!this.m_9236_().f_46443_ && this.f_19797_ % 20 == 0) {
                this.tickDetonation();
            }
            for (int i = 0; i < 360; ++i) {
                if (i % 40 != 0) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), Math.cos(i) * 0.25, 0.25, Math.sin(i) * 0.25);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), Math.sin(i) * 0.25, -0.25, Math.cos(i) * 0.25);
            }
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.howit_loot.get();
    }

    public float summonDetashedPart(boolean isRight) {
        double offset = isRight ? 3.0 : -3.0;
        Vec3 vec3 = new Vec3(0.0, 0.0, offset).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        HowitzerArm arm = new HowitzerArm((EntityType<? extends PathfinderMob>)((EntityType)Sentities.HOWIT_ARM.get()), this.m_9236_());
        arm.setRight(isRight);
        arm.setNuclear(this.isRadioactive());
        arm.m_6027_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + 1.6, this.m_20189_() + vec3.f_82481_);
        this.m_9236_().m_7967_((Entity)arm);
        this.m_216990_((SoundEvent)Ssounds.LIMB_SLASH.get());
        return 0.0f;
    }

    protected void damageStomp(Level level, BlockPos pos, double range, double damageRange) {
        AABB aabb = this.m_20191_().m_82400_(damageRange);
        List entities = level.m_6249_((Entity)this, aabb, entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(living = (LivingEntity)entity);
        });
        int i = 0;
        while ((double)i <= 2.0 * range) {
            int j = 0;
            while ((double)j <= 2.0 * range) {
                int k = 0;
                while ((double)k <= 2.0 * range) {
                    double distance = Mth.m_14116_((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                    if ((Math.abs(i) != 2 || Math.abs(j) != 2 || Math.abs(k) != 2) && distance < range + 0.5) {
                        BlockPos blockpos = pos.m_7918_(i - (int)range, j - (int)range, k - (int)range);
                        BlockState state = level.m_8055_(blockpos);
                        boolean airBelow = level.m_8055_(blockpos.m_7495_()).m_60795_();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            if (airBelow && state.m_60800_((BlockGetter)level, pos) >= 0.0f && Math.random() < 0.3) {
                                FallingBlockEntity.m_201971_((Level)serverLevel, (BlockPos)blockpos, (BlockState)state);
                                serverLevel.m_7471_(blockpos, false);
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            for (int i2 = 0; i2 < 2; ++i2) {
                this.m_7327_((Entity)living);
                living.f_20916_ = 0;
                living.f_19802_ = 0;
            }
        }
        this.m_216990_((SoundEvent)Ssounds.LANDING.get());
    }

    private FleshBomb.BombType compareEntity(LivingEntity living, int burnable) {
        AABB aabb = living.m_20191_().m_82400_(4.0);
        List extra_targets = this.m_9236_().m_6249_((Entity)living, aabb, entity -> {
            LivingEntity livingEntity;
            return entity instanceof LivingEntity && this.TARGET_SELECTOR.test(livingEntity = (LivingEntity)entity);
        });
        if (this.isRadioactive() && this.hasNuke() && (living.m_21233_() >= 100.0f || living.m_21230_() >= 20)) {
            this.f_19804_.m_135381_(NUKE, (Object)0);
            return FleshBomb.BombType.NUCLEAR;
        }
        if (burnable > 8) {
            return Math.random() < (double)0.3f ? FleshBomb.BombType.BILE : FleshBomb.BombType.FLAME;
        }
        if (((List)SConfig.SERVER.corrosion.get()).contains(living.m_20078_())) {
            return FleshBomb.BombType.ACID;
        }
        if (extra_targets.size() > 1 || living.m_21230_() >= 10) {
            return FleshBomb.BombType.BILE;
        }
        return FleshBomb.BombType.BASIC;
    }

    public boolean isRadioactive() {
        return (Integer)this.f_19804_.m_135370_(ORES) >= 100;
    }

    @Override
    public void ActivateAdaptation() {
        super.ActivateAdaptation();
        this.f_19804_.m_135381_(ORES, (Object)100);
    }

    public void m_6504_(LivingEntity entity, float val) {
        float damage = (float)((Double)SConfig.SERVER.howit_ranged_damage.get() * (Double)SConfig.SERVER.global_damage.get());
        FleshBomb bomb = new FleshBomb(this.m_9236_(), (LivingEntity)this, damage, this.compareEntity(entity, (int)val), this.f_19796_.m_216339_(4, 7));
        bomb.setLivingEntityPredicate(this.TARGET_SELECTOR);
        bomb.setCarrier(Math.random() < (double)0.2f);
        bomb.setTarget((Entity)entity);
        double dx = entity.m_20185_() - this.m_20185_();
        double dz = entity.m_20189_() - this.m_20189_();
        double dy = entity.m_20186_() - this.m_20186_();
        float value = this.f_19796_.m_188501_() * 0.5f;
        bomb.m_6027_(this.m_20185_() + (double)value, this.m_20186_() + 7.0, this.m_20189_() + (double)value);
        bomb.m_6686_(dx * (double)0.085f, 6.5 + Math.hypot(dx, dz) * (double)0.02f + (dy > 0.0 ? dy : 0.0), dz * (double)0.085f, 2.0f, 14.0f);
        this.m_9236_().m_7967_((Entity)bomb);
        this.m_216990_((SoundEvent)Ssounds.FALLING_BOMB.get());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.HOWITZER_AMBIENT.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12361_;
    }

    @Override
    protected void grief(AABB aabb) {
        boolean flag = false;
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (Utilities.biomass().contains(blockstate)) {
                flag = this.m_9236_().m_7731_(blockpos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).m_49966_(), 3) || flag;
                this.breakCounter = 0;
                continue;
            }
            if (!(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) < (float)this.getDestroySpeed()) || !(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) >= 0.0f) || !ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) continue;
            if (blockstate.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("forge:ores")))) {
                this.f_19804_.m_135381_(ORES, (Object)((Integer)this.f_19804_.m_135370_(ORES) + 1));
            }
            flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
            this.breakCounter = 0;
        }
    }

    public boolean hasLineOfSightBlocks(BlockPos pos) {
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(this.m_20299_(1.0f), new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockPos position = raytraceresult.m_82425_();
        return pos.equals((Object)position) || this.m_9236_().m_46859_(pos) || this.m_9236_().m_7702_(pos) == this.m_9236_().m_7702_(position);
    }

    public void searchBlocks() {
        AABB aabb = this.m_20191_().m_82377_(32.0, 4.0, 32.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState block = this.m_9236_().m_8055_(blockpos);
            if (!block.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("forge:ores"))) || !this.hasLineOfSightBlocks(blockpos) || !(this.f_19796_.m_188501_() < 0.5f)) continue;
            this.setTargetPos(blockpos);
            break;
        }
    }

    @Nullable
    private BlockPos getTargetPos() {
        return this.Targetpos;
    }

    public void setTargetPos(@Nullable BlockPos pos) {
        this.Targetpos = pos;
    }

    public boolean hasNuke() {
        return (Integer)this.f_19804_.m_135370_(NUKE) > 60;
    }

    protected void createBomb() {
        if (this.isRadioactive() && !this.hasNuke()) {
            this.f_19804_.m_135381_(NUKE, (Object)((Integer)this.f_19804_.m_135370_(NUKE) + 1));
        }
    }

    @Override
    public String getMutation() {
        if (this.isRadioactive()) {
            return "spore.entity.variant.irradiated";
        }
        return super.getMutation();
    }

    public void spreadRadiation() {
        List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(12.0));
        for (Entity entity : entities) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || !this.TARGET_SELECTOR.test(living = (LivingEntity)entity)) continue;
            this.addEffect(living);
        }
    }

    public void addEffect(LivingEntity living) {
        if (ModList.get().isLoaded("alexscaves")) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("alexscaves:irradiated"));
            if (effect != null) {
                living.m_7292_(new MobEffectInstance(effect, 400, 0));
            }
        } else {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 400, 0));
        }
    }

    @Override
    public boolean getAdaptation() {
        return this.isRadioactive();
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>();
        if (this.getRightArmHp() > 0.0f) {
            values.add(HitboxesForParts.HOWI_RIGHT_ARM);
        }
        if (this.getLeftArmHp() > 0.0f) {
            values.add(HitboxesForParts.HOWI_LEFT_ARM);
        }
        for (HitboxesForParts hitboxes : this.innatePartList) {
            HitboxesForParts part = this.calculateChance(hitboxes, 0.65f);
            if (part == null) continue;
            values.add(part);
        }
        return values;
    }

    public static class SearchAroundGoal
    extends Goal {
        private final Howitzer howitzer;
        public int tryTicks;

        public SearchAroundGoal(Howitzer specter) {
            this.howitzer = specter;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.howitzer.getTargetPos() != null && this.howitzer.m_5448_() == null;
        }

        protected void moveToBlock(BlockPos pos) {
            if (pos != null) {
                this.howitzer.f_21344_.m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 1.0);
            }
        }

        public void m_8056_() {
            this.moveToBlock(this.howitzer.getTargetPos());
            this.tryTicks = 0;
            super.m_8056_();
        }

        public boolean m_8045_() {
            return this.howitzer.m_5448_() == null;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.tryTicks;
            BlockPos pos = this.howitzer.getTargetPos();
            if (pos != null && this.shouldRecalculatePath()) {
                this.moveToBlock(pos);
            }
            if (pos != null && pos.m_203195_((Position)this.howitzer.m_20182_(), 7.0)) {
                this.howitzer.m_9236_().m_46953_(pos, false, (Entity)this.howitzer);
                this.howitzer.f_19804_.m_135381_(ORES, (Object)((Integer)this.howitzer.f_19804_.m_135370_(ORES) + 1));
                this.howitzer.setTargetPos(null);
                this.howitzer.searchBlocks();
            }
        }
    }

    public static class HowitzerRangedAttackGoal
    extends ScatterShotRangedGoal {
        public HowitzerRangedAttackGoal(RangedAttackMob mob, double speed, int interval, float range, int min, int max) {
            super(mob, speed, interval, range, min, max);
        }

        private int getBurnable(LivingEntity target) {
            AABB aabb = target.m_20191_().m_82400_(4.0);
            ArrayList<BlockPos> burnable_material = new ArrayList<BlockPos>();
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                if (!this.mob.m_9236_().m_8055_(blockpos).isFlammable((BlockGetter)this.mob.m_9236_(), blockpos, Direction.UP)) continue;
                burnable_material.add(blockpos);
            }
            return burnable_material.size();
        }

        @Override
        public void m_8037_() {
            double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.mob.m_21573_().m_26573_();
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (--this.attackTime == 0) {
                if (!flag) {
                    return;
                }
                RandomSource randomSource = RandomSource.m_216327_();
                int shot = randomSource.m_216339_(this.minShots, this.maxShots + this.getExtraShots());
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = this.getBurnable(this.target);
                for (int i = 0; i < shot; ++i) {
                    this.rangedAttackMob.m_6504_(this.target, f1);
                }
                this.attackTime = Mth.m_14143_((float)(f * (float)this.attackInterval + (float)this.attackInterval));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackInterval, (double)this.attackInterval));
            }
        }
    }
}

