/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class IkLegWithHitbox {
    private final Entity owner;
    private final PartEntity<?>[] entities;
    private final float maxLength;
    private final float minLength;
    private final Vec3 defaultBodyOffset;
    private final Vec3 defaultLimbOffset;
    private final float maxDistance;
    public final float length;
    private final RandomSource randomSource = RandomSource.m_216327_();
    private Vec3 sitPosition = null;
    private Vec3 lastSitPosition = null;

    public IkLegWithHitbox(Entity owner, PartEntity<?>[] entities, Vec3 defaultBodyOffset, Vec3 defaultLimbOffset, float maxDistance, float length, float maxLength, float minLength) {
        this.owner = owner;
        this.entities = entities;
        this.defaultBodyOffset = defaultBodyOffset;
        this.defaultLimbOffset = defaultLimbOffset;
        this.maxDistance = maxDistance;
        this.length = length;
        this.maxLength = maxLength;
        this.minLength = minLength;
    }

    public Vec3 getSitPosition() {
        return this.sitPosition;
    }

    public PartEntity<?>[] getEntities() {
        return this.entities;
    }

    public Vec3 getLastSitPosition() {
        return this.lastSitPosition;
    }

    public Vec3 getLegBasePos() {
        float yRotRad = -this.owner.m_146908_() * ((float)Math.PI / 180);
        double rotatedX = this.defaultLimbOffset.f_82479_ * Math.cos(yRotRad) - this.defaultLimbOffset.f_82481_ * Math.sin(yRotRad);
        double rotatedZ = this.defaultLimbOffset.f_82479_ * Math.sin(yRotRad) + this.defaultLimbOffset.f_82481_ * Math.cos(yRotRad);
        return this.owner.m_20182_().m_82520_(rotatedX, this.defaultLimbOffset.f_82480_, rotatedZ);
    }

    public Vec3 getDefaultBodyOffset() {
        float yRotRad = -this.owner.m_146908_() * ((float)Math.PI / 180);
        double rotatedX = this.defaultBodyOffset.f_82479_ * Math.cos(yRotRad) - this.defaultBodyOffset.f_82481_ * Math.sin(yRotRad);
        double rotatedZ = this.defaultBodyOffset.f_82479_ * Math.sin(yRotRad) + this.defaultBodyOffset.f_82481_ * Math.cos(yRotRad);
        return this.owner.m_20182_().m_82520_(rotatedX, this.defaultBodyOffset.f_82480_, rotatedZ);
    }

    private void moveSegmentTowards(int index, Vec3 target, boolean far) {
        Vec3 currentPos = this.entities[index].m_20182_();
        Vec3 newPos = currentPos.m_165921_(target, 0.25);
        this.entities[index].m_146884_(far ? target : newPos);
    }

    public void applyIK() {
        Vec3 solvedPos;
        Vec3 dir;
        int i;
        boolean tooFar;
        if (this.entities == null || this.entities.length == 0) {
            return;
        }
        Vec3[] oldPositions = new Vec3[this.entities.length];
        for (int j = 0; j < this.entities.length; ++j) {
            oldPositions[j] = this.entities[j].m_20182_();
        }
        Vec3 basePos = this.getDefaultBodyOffset();
        Vec3 defaultTipPos = this.getLegBasePos();
        boolean bl = tooFar = this.entities[this.entities.length - 1].m_20238_(defaultTipPos) > 100.0;
        if (this.sitPosition != null) {
            this.sitPosition = this.applyLengthConstraints(defaultTipPos, this.sitPosition);
        }
        Vec3 targetPos = this.sitPosition == null || tooFar ? defaultTipPos : this.sitPosition;
        targetPos = this.applyLengthConstraints(defaultTipPos, targetPos);
        this.entities[0].m_6034_(basePos.f_82479_, basePos.f_82480_, basePos.f_82481_);
        Vec3 tipTarget = targetPos;
        this.moveSegmentTowards(this.entities.length - 1, tipTarget, tooFar);
        for (i = this.entities.length - 2; i >= 0; --i) {
            Vec3 nextPos = this.entities[i + 1].m_20182_();
            dir = this.entities[i].m_20182_().m_82546_(nextPos).m_82541_();
            solvedPos = nextPos.m_82549_(dir.m_82490_((double)this.length));
            this.moveSegmentTowards(i, solvedPos, tooFar);
        }
        this.entities[0].m_6034_(basePos.f_82479_, basePos.f_82480_, basePos.f_82481_);
        for (i = 1; i < this.entities.length; ++i) {
            Vec3 prevPos = this.entities[i - 1].m_20182_();
            dir = this.entities[i].m_20182_().m_82546_(prevPos).m_82541_();
            solvedPos = prevPos.m_82549_(dir.m_82490_((double)this.length));
            this.moveSegmentTowards(i, solvedPos, tooFar);
        }
        for (int l = 0; l < this.entities.length; ++l) {
            this.entities[l].f_19854_ = oldPositions[l].f_82479_;
            this.entities[l].f_19855_ = oldPositions[l].f_82480_;
            this.entities[l].f_19856_ = oldPositions[l].f_82481_;
            this.entities[l].f_19790_ = oldPositions[l].f_82479_;
            this.entities[l].f_19791_ = oldPositions[l].f_82480_;
            this.entities[l].f_19792_ = oldPositions[l].f_82481_;
        }
    }

    public void refreshLegStandingPoint() {
        this.sitPosition = this.findStableFooting(this.entities[this.entities.length - 1]);
        if (!this.sitPosition.equals((Object)this.lastSitPosition)) {
            this.lastSitPosition = this.sitPosition;
        }
    }

    private Vec3 applyLengthConstraints(Vec3 basePos, Vec3 targetPos) {
        double distance = basePos.m_82554_(targetPos);
        if (distance > (double)this.maxLength) {
            Vec3 dir = targetPos.m_82546_(basePos).m_82541_();
            return basePos.m_82549_(dir.m_82490_((double)this.maxLength));
        }
        if (distance < (double)this.minLength && distance > 1.0E-4) {
            Vec3 dir = targetPos.m_82546_(basePos).m_82541_();
            return basePos.m_82549_(dir.m_82490_((double)this.minLength));
        }
        return targetPos;
    }

    private Vec3 findStableFooting(PartEntity<?> tip) {
        Level level = this.owner.m_9236_();
        Vec3 legBasePos = this.getLegBasePos();
        if (level.f_46443_) {
            return legBasePos;
        }
        if (this.lastSitPosition != null && legBasePos.m_82554_(this.lastSitPosition) < (double)this.maxDistance) {
            return this.lastSitPosition;
        }
        double randX = (this.randomSource.m_188500_() - 0.5) * 2.0;
        double randZ = (this.randomSource.m_188500_() - 0.5) * 2.0;
        Vec3 randomizedBase = legBasePos.m_82520_(randX, 0.0, randZ);
        double entityWidth = this.owner.m_20205_();
        double minDistance = entityWidth * 1.2;
        Vec3 horizontalVec = new Vec3(randomizedBase.f_82479_ - legBasePos.f_82479_, 0.0, randomizedBase.f_82481_ - legBasePos.f_82481_);
        double horizontalDist = horizontalVec.m_82553_();
        if (horizontalDist < minDistance && horizontalDist > 1.0E-4) {
            Vec3 direction = horizontalVec.m_82541_();
            randomizedBase = legBasePos.m_82549_(direction.m_82490_(minDistance));
        }
        BlockPos searchStart = new BlockPos((int)Math.floor(randomizedBase.f_82479_), (int)Math.floor(tip.m_20182_().f_82480_ + 2.0), (int)Math.floor(randomizedBase.f_82481_));
        for (int y = 0; y < 4; ++y) {
            BlockPos checkPos = searchStart.m_6625_(y);
            if (!this.owner.m_9236_().m_8055_(checkPos).m_60804_((BlockGetter)this.owner.m_9236_(), checkPos)) continue;
            return new Vec3((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() - 0.5, (double)checkPos.m_123343_() + 0.5);
        }
        return this.lastSitPosition == null ? legBasePos : randomizedBase;
    }
}

