/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Senchantments;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class ThrownSpear
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private ItemStack spearItem = new ItemStack((ItemLike)Sitems.INFECTED_SPEAR.get());
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public ThrownSpear(Level p_37569_, LivingEntity p_37570_, ItemStack stack, int color) {
        super((EntityType)Sentities.THROWN_SPEAR.get(), p_37570_, p_37569_);
        this.spearItem = stack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)stack)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)stack.m_41790_());
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public ThrownSpear(PlayMessages.SpawnEntity spawnEntity, Level level) {
        super((EntityType)Sentities.THROWN_SPEAR.get(), level);
    }

    public ThrownSpear(EntityType<ThrownSpear> thrownSpearEntityType, Level level) {
        super(thrownSpearEntityType, level);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)0);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.spearItem.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.m_6351_(p_37575_, p_37576_);
    }

    protected void m_5790_(EntityHitResult hit) {
        Entity entity = hit.m_82443_();
        float f = (float)((Integer)SConfig.SERVER.spear_damage.get()).intValue() + 0.5f * (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)this.spearItem);
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.spearItem, (MobType)livingentity.m_6336_());
        }
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = (SoundEvent)Ssounds.INFECTED_WEAPON_HIT_ENTITY.get();
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    LivingEntity ownerLiving = (LivingEntity)entity1;
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)ownerLiving);
                    EnchantmentHelper.m_44896_((LivingEntity)ownerLiving, (Entity)livingEntity);
                    Item item = this.spearItem.m_41720_();
                    if (item instanceof SporeWeaponData) {
                        SporeWeaponData data = (SporeWeaponData)item;
                        data.abstractMutationBuffs(livingEntity, ownerLiving, this.spearItem, data);
                    }
                }
                if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.spearItem) > 0) {
                    int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.spearItem);
                    entity.m_20254_(4 * j);
                }
                ThrownSpear.abstractEffects(this.spearItem, livingEntity);
                this.m_7761_(livingEntity);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        this.m_5496_(soundevent, f1, 1.0f);
    }

    protected boolean m_142470_(Player p_150196_) {
        return super.m_142470_(p_150196_) || this.m_36797_() && this.m_150171_((Entity)p_150196_) && p_150196_.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)Ssounds.INFECTED_WEAPON_HIT_BLOCK.get();
    }

    public void m_6123_(Player p_37580_) {
        if (this.m_150171_((Entity)p_37580_) || this.m_19749_() == null) {
            super.m_6123_(p_37580_);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Trident", 10)) {
            this.spearItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Trident"));
        }
        this.dealtDamage = tag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.spearItem)));
        this.f_19804_.m_135381_(COLOR, (Object)tag.m_128451_("color"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Trident", (Tag)this.spearItem.m_41739_(new CompoundTag()));
        tag.m_128379_("DealtDamage", this.dealtDamage);
        tag.m_128405_("color", ((Integer)this.f_19804_.m_135370_(COLOR)).intValue());
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    public static void abstractEffects(ItemStack stack, LivingEntity livingEntity) {
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.CORROSIVE_POTENCY.get()) > 0) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)Seffects.CORROSION.get(), 200, 1));
        }
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.GASTRIC_SPEWAGE.get()) > 0) {
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                livingEntity.m_7292_(instance);
            }
        }
        if (stack.getEnchantmentLevel((Enchantment)Senchantments.CRYOGENIC_ASPECT.get()) > 0) {
            livingEntity.m_146917_(livingEntity.m_146888_() + 300);
        }
    }
}

