/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.BaseWeapons;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsBaseItem;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SporeDiggerTools
extends SporeToolsBaseItem {
    protected final TagKey<Block> blocks;

    public SporeDiggerTools(double meleeDamage, double meleeReach, double meleeRecharge, int durability, int miningLevel, TagKey<Block> blocks) {
        super(meleeDamage, meleeReach, meleeRecharge, durability, miningLevel);
        this.blocks = blocks;
    }

    @Override
    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity living) {
        if (state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            this.hurtTool(stack, living, 1);
        }
        if (this.canMultiBreak(stack, level, state, pos, living) && this.tooHurt(stack)) {
            for (BlockPos blockPos : SporeDiggerTools.getBlocksToBeDestroyed(1, pos, living)) {
                if (!level.m_8055_(blockPos).m_204336_(this.blocks)) continue;
                level.m_46953_(blockPos, true, (Entity)living);
                this.hurtTool(stack, living, 1);
            }
        }
        return super.m_6813_(stack, level, state, pos, living);
    }

    @Override
    public float m_8102_(ItemStack stack, BlockState state) {
        return state.m_204336_(this.blocks) ? (float)this.miningLevel : 1.0f;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_204336_(this.blocks);
    }

    public static List<BlockPos> getBlocksToBeDestroyed(int range, BlockPos initalBlockPos, LivingEntity player) {
        int y;
        int x;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockHitResult traceResult = player.m_9236_().m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_(6.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (traceResult.m_6662_() == HitResult.Type.MISS) {
            return positions;
        }
        if (traceResult.m_82434_() == Direction.DOWN || traceResult.m_82434_() == Direction.UP) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.m_123341_() + x, initalBlockPos.m_123342_(), initalBlockPos.m_123343_() + y));
                }
            }
        }
        if (traceResult.m_82434_() == Direction.NORTH || traceResult.m_82434_() == Direction.SOUTH) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.m_123341_() + x, initalBlockPos.m_123342_() + y, initalBlockPos.m_123343_()));
                }
            }
        }
        if (traceResult.m_82434_() == Direction.EAST || traceResult.m_82434_() == Direction.WEST) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.m_123341_(), initalBlockPos.m_123342_() + y, initalBlockPos.m_123343_() + x));
                }
            }
        }
        return positions;
    }

    public boolean canMultiBreak(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity living) {
        return false;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || ImmutableSet.of((Object)Enchantments.f_44984_, (Object)Enchantments.f_44987_, (Object)Enchantments.f_44985_).contains((Object)enchantment);
    }
}

