/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Special.BlockEntityModel;
import com.Harbinger.Spore.SBlockEntities.ZoaholicBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ZoaholicModel<T extends ZoaholicBlockEntity>
extends BlockEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("spore", "zoaholic"), "main");
    private final ModelPart Base;
    private final ModelPart Blood;
    private final ModelPart Brain;
    private final ModelPart Heart;
    private final ModelPart InnardsTop;
    private final ModelPart InnardsDown;

    public ZoaholicModel() {
        ModelPart root = ZoaholicModel.createBodyLayer().m_171564_();
        this.Base = root.m_171324_("Base");
        this.Blood = this.Base.m_171324_("GutBox").m_171324_("Blood");
        this.Brain = this.Base.m_171324_("Top").m_171324_("FrankenstineBrain");
        this.Heart = this.Base.m_171324_("GutBox").m_171324_("Heart");
        this.InnardsTop = this.Base.m_171324_("GutBox").m_171324_("Innards").m_171324_("HookedInnards");
        this.InnardsDown = this.Base.m_171324_("GutBox").m_171324_("Innards").m_171324_("LyingInnards");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Base = partdefinition.m_171599_("Base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -2.0f, -8.0f, 16.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition GutBox = Base.m_171599_("GutBox", CubeListBuilder.m_171558_().m_171514_(14, 59).m_171488_(-8.0f, -9.0f, -8.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(14, 59).m_171488_(6.0f, -9.0f, -8.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(14, 59).m_171488_(-8.0f, -9.0f, 6.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(14, 59).m_171488_(6.0f, -9.0f, 6.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Glass = GutBox.m_171599_("Glass", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171488_(-6.0f, -10.0f, -7.0f, 12.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 51).m_171488_(-6.0f, -10.0f, 7.0f, 12.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition WestPane_r1 = Glass.m_171599_("WestPane_r1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171488_(-6.0f, -4.0f, -7.0f, 12.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 51).m_171488_(-6.0f, -4.0f, 7.0f, 12.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition FleshHook = GutBox.m_171599_("FleshHook", CubeListBuilder.m_171558_().m_171514_(29, 0).m_171488_(-0.5f, -0.25f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.25f)).m_171514_(37, 0).m_171488_(-1.0f, 0.75f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.25f)).m_171514_(39, 0).m_171488_(-1.0f, 2.25f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)).m_171514_(27, 0).m_171488_(0.0f, 1.75f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.25f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)-2.0f));
        PartDefinition Blood = GutBox.m_171599_("Blood", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-7.0f, -0.9f, -7.0f, 14.0f, 1.0f, 14.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition Innards2 = GutBox.m_171599_("Innards", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition HookedInnards = Innards2.m_171599_("HookedInnards", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.4984f, (float)-3.2709f, (float)1.9307f));
        PartDefinition Seg_3_r1 = HookedInnards.m_171599_("Seg_3_r1", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5834f, (float)0.6174f, (float)-0.4139f));
        PartDefinition Seg_4_r1 = HookedInnards.m_171599_("Seg_4_r1", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)1.3278f, (float)0.62f, (float)1.361f, (float)0.0284f, (float)1.0183f, (float)0.087f));
        PartDefinition Seg_5_r1 = HookedInnards.m_171599_("Seg_5_r1", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)3.0281f, (float)0.7113f, (float)2.4102f, (float)2.9551f, (float)0.8874f, (float)2.9774f));
        PartDefinition Seg_2_r1 = HookedInnards.m_171599_("Seg_2_r1", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-0.5825f, (float)-1.9026f, (float)-0.2022f, (float)-1.4581f, (float)0.4523f, (float)-0.2477f));
        PartDefinition Seg_1_r1 = HookedInnards.m_171599_("Seg_1_r1", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-0.9984f, (float)-3.4002f, (float)-1.4609f, (float)-0.8548f, (float)0.2878f, (float)-0.0288f));
        PartDefinition Seg2_r1 = HookedInnards.m_171599_("Seg2_r1", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, 0.0f, -1.75f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-0.9984f, (float)-2.3057f, (float)-4.4679f, (float)1.3303f, (float)-0.18f, (float)0.3691f));
        PartDefinition Seg3_r1 = HookedInnards.m_171599_("Seg3_r1", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-1.6348f, (float)-0.9948f, (float)-3.8053f, (float)2.0343f, (float)-0.0762f, (float)-0.013f));
        PartDefinition Seg1_r1 = HookedInnards.m_171599_("Seg1_r1", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-0.9984f, (float)-3.2291f, (float)-1.9307f, (float)0.3123f, (float)-0.1586f, (float)0.4549f));
        PartDefinition Seg11_r1 = HookedInnards.m_171599_("Seg11_r1", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-2.6869f, (float)0.6542f, (float)-0.6377f, (float)-0.1374f, (float)1.357f, (float)3.0113f));
        PartDefinition Seg10_r1 = HookedInnards.m_171599_("Seg10_r1", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-1.0f, -0.991f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-4.6155f, (float)0.6618f, (float)-1.1673f, (float)-3.0323f, (float)1.3012f, (float)0.1094f));
        PartDefinition Seg9_r1 = HookedInnards.m_171599_("Seg9_r1", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-5.7728f, (float)0.6098f, (float)0.4631f, (float)-0.0356f, (float)0.6169f, (float)3.125f));
        PartDefinition Seg8_r1 = HookedInnards.m_171599_("Seg8_r1", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-1.75f, -1.0f, -2.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-6.0405f, (float)0.7577f, (float)2.112f, (float)0.0812f, (float)-0.2964f, (float)3.046f));
        PartDefinition Seg7_r1 = HookedInnards.m_171599_("Seg7_r1", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -0.9929f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-3.0584f, (float)0.7238f, (float)2.4371f, (float)1.3463f, (float)-1.0624f, (float)1.7563f));
        PartDefinition Seg6_r1 = HookedInnards.m_171599_("Seg6_r1", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-1.9811f, (float)-0.1354f, (float)0.9875f, (float)2.5619f, (float)-0.523f, (float)0.2459f));
        PartDefinition Seg5_r1 = HookedInnards.m_171599_("Seg5_r1", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -0.5f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-1.8307f, (float)0.062f, (float)-1.059f, (float)2.9948f, (float)-0.0702f, (float)-0.0323f));
        PartDefinition Seg4_r1 = HookedInnards.m_171599_("Seg4_r1", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-1.6797f, (float)0.7949f, (float)-2.9137f, (float)-2.5029f, (float)-0.0702f, (float)-0.0323f));
        PartDefinition LyingInnards = Innards2.m_171599_("LyingInnards", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5016f, (float)-3.2709f, (float)-1.9307f));
        PartDefinition Seg_4_r2 = LyingInnards.m_171599_("Seg_4_r2", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-0.9801f, -0.9947f, -2.2964f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-2.7793f, (float)0.4447f, (float)9.6709f, (float)0.905f, (float)-1.2386f, (float)2.3447f));
        PartDefinition Seg_5_r2 = LyingInnards.m_171599_("Seg_5_r2", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-0.5934f, -0.4887f, -4.1735f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-2.6793f, (float)0.3447f, (float)9.6709f, (float)0.7518f, (float)-0.7288f, (float)2.148f));
        PartDefinition Seg_6_r1 = LyingInnards.m_171599_("Seg_6_r1", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-6.1084f, (float)0.3287f, (float)8.2006f, (float)0.0125f, (float)-0.1431f, (float)2.4887f));
        PartDefinition Seg_3_r2 = LyingInnards.m_171599_("Seg_3_r2", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-0.9962f, -1.2445f, -2.1286f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-0.9187f, (float)0.4077f, (float)9.4251f, (float)2.4675f, (float)-1.2925f, (float)0.839f));
        PartDefinition Seg_2_r2 = LyingInnards.m_171599_("Seg_2_r2", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-1.0631f, -0.8006f, -2.3564f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)0.9901f, (float)0.8019f, (float)8.6715f, (float)2.5044f, (float)-1.1263f, (float)0.6803f));
        PartDefinition Seg3_r2 = LyingInnards.m_171599_("Seg3_r2", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-0.6236f, -1.5019f, -2.5307f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)1.4235f, (float)-1.1442f, (float)4.8427f, (float)2.4573f, (float)-0.0911f, (float)0.3991f));
        PartDefinition Seg4_r2 = LyingInnards.m_171599_("Seg4_r2", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0589f, -0.3669f, -1.6928f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)1.6735f, (float)0.8558f, (float)3.8427f, (float)-2.5152f, (float)-0.0616f, (float)0.0467f));
        PartDefinition Seg2_r2 = LyingInnards.m_171599_("Seg2_r2", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.1758f, -0.8696f, -2.3369f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)1.0941f, (float)0.787f, (float)6.7679f, (float)3.0641f, (float)0.0403f, (float)0.4784f));
        PartDefinition Seg12_r1 = LyingInnards.m_171599_("Seg12_r1", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)2.4369f, (float)0.5042f, (float)0.8877f, (float)0.1374f, (float)1.357f, (float)-3.0113f));
        PartDefinition Seg11_r2 = LyingInnards.m_171599_("Seg11_r2", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-1.0f, -0.991f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)4.3655f, (float)0.5118f, (float)1.4173f, (float)3.0323f, (float)1.3012f, (float)-0.1094f));
        PartDefinition Seg10_r2 = LyingInnards.m_171599_("Seg10_r2", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)5.5228f, (float)0.4598f, (float)-0.2131f, (float)0.0356f, (float)0.6169f, (float)-3.125f));
        PartDefinition Seg9_r2 = LyingInnards.m_171599_("Seg9_r2", CubeListBuilder.m_171558_().m_171514_(0, 72).m_171488_(-0.25f, -1.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)5.7905f, (float)0.6077f, (float)-1.862f, (float)-0.0812f, (float)-0.2964f, (float)-3.046f));
        PartDefinition Seg8_r2 = LyingInnards.m_171599_("Seg8_r2", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -0.9929f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)2.8084f, (float)0.5738f, (float)-2.1871f, (float)-1.3463f, (float)-1.0624f, (float)-1.7563f));
        PartDefinition Seg7_r2 = LyingInnards.m_171599_("Seg7_r2", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)1.9811f, (float)-0.1354f, (float)-0.9875f, (float)-2.5619f, (float)-0.523f, (float)-0.2459f));
        PartDefinition Seg6_r2 = LyingInnards.m_171599_("Seg6_r2", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)1.8307f, (float)0.062f, (float)1.059f, (float)-2.9948f, (float)-0.0702f, (float)0.0323f));
        PartDefinition Seg5_r2 = LyingInnards.m_171599_("Seg5_r2", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)1.6797f, (float)0.7949f, (float)2.9137f, (float)2.5029f, (float)-0.0702f, (float)0.0323f));
        PartDefinition Heart = GutBox.m_171599_("Heart", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-2.0686f, 1.3444f, -1.2546f, 4.0f, 3.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.m_171423_((float)-3.6212f, (float)-9.1045f, (float)-3.6818f, (float)-0.0042f, (float)-0.6541f, (float)0.0072f));
        PartDefinition FunnyLump_r1 = Heart.m_171599_("FunnyLump_r1", CubeListBuilder.m_171558_().m_171514_(21, 21).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)1.1969f, (float)2.6233f, (float)0.2454f, (float)-0.829f, (float)-0.7418f, (float)0.0f));
        PartDefinition FunnyLump_r2 = Heart.m_171599_("FunnyLump_r2", CubeListBuilder.m_171558_().m_171514_(22, 20).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.m_171423_((float)-1.234f, (float)2.8733f, (float)0.2454f, (float)0.829f, (float)-0.7418f, (float)0.0f));
        PartDefinition FunnyLump_r3 = Heart.m_171599_("FunnyLump_r3", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.3f)), PartPose.m_171423_((float)-0.334f, (float)2.8733f, (float)-0.3546f, (float)-0.829f, (float)0.7418f, (float)0.0f));
        PartDefinition FunnyLump_r4 = Heart.m_171599_("FunnyLump_r4", CubeListBuilder.m_171558_().m_171514_(20, 21).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.3f)), PartPose.m_171423_((float)-0.034f, (float)3.1233f, (float)0.7454f, (float)-0.829f, (float)0.7418f, (float)0.0f));
        PartDefinition TopRight_r1 = Heart.m_171599_("TopRight_r1", CubeListBuilder.m_171558_().m_171514_(18, 18).m_171488_(-1.0f, -2.5f, -1.51f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.m_171423_((float)-0.8186f, (float)2.5944f, (float)0.2454f, (float)0.0f, (float)0.0f, (float)0.9163f));
        PartDefinition BottomLeft_r1 = Heart.m_171599_("BottomLeft_r1", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-2.0f, -1.5f, -1.49f, 3.0f, 4.0f, 3.0f, new CubeDeformation(-0.5f)), PartPose.m_171423_((float)0.6814f, (float)3.5944f, (float)0.2454f, (float)0.0f, (float)0.0f, (float)0.9163f));
        PartDefinition Left_r1 = Heart.m_171599_("Left_r1", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.3f)), PartPose.m_171423_((float)0.4314f, (float)3.4444f, (float)-0.0046f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition Right_r1 = Heart.m_171599_("Right_r1", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.m_171423_((float)-0.3186f, (float)3.0944f, (float)0.2454f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition Top = Base.m_171599_("Top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -12.0f, -8.0f, 16.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition ControlPanel = Top.m_171599_("ControlPanel", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(-6.5f, -3.0f, 3.0f, 13.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(18, 0).m_171488_(-6.5f, -2.0f, 1.0f, 13.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(18, 0).m_171488_(-6.5f, -3.0f, 2.0f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(17, 0).m_171488_(-6.5f, -1.0f, 0.0f, 13.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)-7.0f));
        PartDefinition Face = ControlPanel.m_171599_("Face", CubeListBuilder.m_171558_().m_171514_(13, 12).m_171488_(-6.5f, -0.5f, 0.0f, 14.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)0.0303f, (float)-0.5303f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Button2 = Face.m_171599_("Button", CubeListBuilder.m_171558_().m_171514_(35, 65).m_171488_(-1.0f, -0.75f, -2.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)3.0f));
        PartDefinition ButtonFace = Button2.m_171599_("ButtonFace", CubeListBuilder.m_171558_().m_171514_(76, 50).m_171488_(-0.5f, -1.5f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-0.5f));
        PartDefinition Display = Face.m_171599_("Display", CubeListBuilder.m_171558_().m_171514_(4, 12).m_171488_(-4.0f, -6.5f, -3.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.4f)).m_171514_(79, 12).m_171488_(-2.0f, -6.7f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.4f)).m_171514_(78, 77).m_171488_(-4.0f, -6.7f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.4f)).m_171514_(78, 70).m_171488_(-4.001f, -6.701f, -2.999f, 3.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(48, 51).m_171488_(-4.001f, -6.701f, -0.999f, 3.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.m_171419_((float)8.5f, (float)5.4697f, (float)3.0303f));
        PartDefinition Needle = Display.m_171599_("Needle", CubeListBuilder.m_171558_().m_171514_(9, 27).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.m_171419_((float)-2.5f, (float)-6.09f, (float)-2.35f));
        PartDefinition SmallButtons = Face.m_171599_("SmallButtons", CubeListBuilder.m_171558_().m_171514_(48, 8).m_171488_(-1.625f, -0.5f, 0.625f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(48, 8).m_171488_(-0.625f, -0.5f, 0.625f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(48, 8).m_171488_(0.375f, -0.5f, 0.625f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(0, 59).m_171488_(-1.625f, -0.5f, -0.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(0, 59).m_171488_(-0.625f, -0.5f, -0.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(0, 59).m_171488_(0.375f, -0.5f, -0.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(38, 61).m_171488_(-1.625f, -0.5f, -1.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(38, 61).m_171488_(-0.625f, -0.5f, -1.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).m_171514_(38, 61).m_171488_(0.375f, -0.5f, -1.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)-0.875f, (float)-0.4874f, (float)3.1553f));
        PartDefinition Lever = Face.m_171599_("Lever", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)5.4697f, (float)2.5303f));
        PartDefinition Lever_r1 = Lever.m_171599_("Lever_r1", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)-5.8f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition LeverBase = Lever.m_171599_("LeverBase", CubeListBuilder.m_171558_().m_171514_(30, 13).m_171488_(-2.0f, -14.5f, 6.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(30, 13).m_171488_(-4.0f, -14.5f, 6.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(30, 13).m_171488_(-3.0f, -14.5f, 6.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(30, 13).m_171488_(-3.0f, -14.5f, 9.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)8.0f, (float)-8.0f));
        PartDefinition Jar = Top.m_171599_("Jar", CubeListBuilder.m_171558_().m_171514_(6, 51).m_171488_(-3.9f, -4.6f, -2.1f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(6, 51).m_171488_(-3.9f, -4.6f, 3.9f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(50, 47).m_171488_(-3.9f, -5.6f, -2.1f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.1f)).m_171514_(42, 39).m_171488_(-0.4f, -6.6f, -1.6f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.01f)).m_171514_(11, 9).m_171488_(1.1f, -6.85f, -1.1f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.09f)), PartPose.m_171419_((float)-3.6f, (float)-10.9f, (float)3.6f));
        PartDefinition GlassWest_r1 = Jar.m_171599_("GlassWest_r1", CubeListBuilder.m_171558_().m_171514_(6, 51).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(6, 51).m_171488_(-3.0f, -2.0f, 3.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.9f, (float)-2.6f, (float)0.9f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition BrainSmall = Jar.m_171599_("BrainSmall", CubeListBuilder.m_171558_().m_171514_(1, 19).m_171488_(-2.8027f, -2.1412f, -1.436f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.2f)).m_171514_(1, 19).m_171488_(0.1973f, -2.1412f, -1.436f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.2f)).m_171514_(1, 1).m_171488_(-1.3027f, -2.1412f, -1.436f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5973f, (float)-1.2088f, (float)-0.164f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Formaldehyde = Jar.m_171599_("Formaldehyde", CubeListBuilder.m_171558_().m_171514_(48, 4).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)-0.9f, (float)-0.5f, (float)0.9f));
        PartDefinition JarToControlWires = Top.m_171599_("JarToControlWires", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Wire1 = JarToControlWires.m_171599_("Wire1", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(0.0f, -0.75f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(36, 59).m_171488_(-4.0f, -0.75f, 2.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(10, 18).m_171488_(-4.0f, -4.75f, 2.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-4.0f, -4.75f, 3.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)-2.0f));
        PartDefinition Wire2 = JarToControlWires.m_171599_("Wire2", CubeListBuilder.m_171558_().m_171514_(78, 72).m_171488_(-0.25f, -0.5f, -0.1f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.1f)).m_171514_(10, 0).m_171488_(-0.25f, -3.5f, 2.7f, 1.0f, 4.0f, 1.0f, new CubeDeformation(-0.1f)).m_171514_(0, 2).m_171488_(-0.25f, -3.5f, 3.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.1f)).m_171514_(48, 4).m_171488_(-2.05f, -3.5f, 4.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)-0.25f, (float)-14.25f, (float)-2.0f));
        PartDefinition FrankenstineBrain = Top.m_171599_("FrankenstineBrain", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.75f, (float)-15.75f, (float)-2.5f));
        PartDefinition MetalRod3Top_r1 = FrankenstineBrain.m_171599_("MetalRod3Top_r1", CubeListBuilder.m_171558_().m_171514_(77, 58).m_171488_(-1.0023f, -3.7672f, 6.0306f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.3f)).m_171514_(12, 30).m_171488_(-0.5023f, -3.2672f, 6.5306f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.15f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2597f, (float)0.0338f, (float)0.1265f));
        PartDefinition MetalRod2Top_r1 = FrankenstineBrain.m_171599_("MetalRod2Top_r1", CubeListBuilder.m_171558_().m_171514_(77, 58).m_171488_(-1.0023f, -1.7672f, -2.0306f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.4f)).m_171514_(12, 30).m_171488_(-0.5023f, -1.5172f, -1.5306f, 1.0f, 3.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)5.0f, (float)0.2597f, (float)-0.0338f, (float)0.1265f));
        PartDefinition MetalRod1Top_r1 = FrankenstineBrain.m_171599_("MetalRod1Top_r1", CubeListBuilder.m_171558_().m_171514_(77, 58).m_171488_(-1.0f, -3.75f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.2f)).m_171514_(12, 30).m_171488_(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)1.7f, (float)6.0f, (float)0.1745f, (float)0.0f, (float)-0.3491f));
        PartDefinition BrainLarge = FrankenstineBrain.m_171599_("BrainLarge", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.75f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.2f)).m_171514_(0, 18).m_171488_(0.75f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.2f)).m_171514_(0, 0).m_171488_(-1.0f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)2.5f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void animateHeart(boolean isActive, boolean hasHeart, ModelPart heart, float value) {
        if (hasHeart) {
            heart.f_104207_ = true;
            if (isActive) {
                heart.f_233553_ = 1.0f + Mth.m_14031_((float)(value / 4.0f)) / 6.0f;
                heart.f_233555_ = 1.0f + Mth.m_14031_((float)(value / 4.0f)) / 6.0f;
                heart.f_233554_ = 1.0f + Mth.m_14089_((float)(value / 4.0f)) / 6.0f;
            } else {
                heart.m_233569_();
            }
        } else {
            heart.f_104207_ = false;
        }
    }

    private void animateBrain(boolean isActive, boolean hasBrain, float value) {
        if (hasBrain) {
            this.Brain.f_104207_ = true;
            if (isActive) {
                this.Brain.m_171324_((String)"BrainLarge").f_233553_ = 1.0f + Mth.m_14031_((float)(value / 6.0f)) / 6.0f;
                this.Brain.m_171324_((String)"BrainLarge").f_233555_ = 1.0f + Mth.m_14031_((float)(value / 6.0f)) / 6.0f;
                this.Brain.m_171324_((String)"BrainLarge").f_233554_ = 1.0f + Mth.m_14031_((float)(value / 6.0f)) / 6.0f;
            } else {
                this.Brain.m_171324_("BrainLarge").m_233569_();
            }
        } else {
            this.Brain.f_104207_ = false;
        }
    }

    private void animateBlood(boolean isActive, boolean biomass, ModelPart blood, float value) {
        if (biomass) {
            blood.f_104207_ = true;
            if (isActive) {
                blood.f_233554_ = 1.0f + Mth.m_14031_((float)(value / 5.0f)) / 2.0f;
            } else {
                blood.m_233569_();
            }
        } else {
            blood.f_104207_ = false;
        }
    }

    private void animateInnards(boolean isActive, boolean innard, ModelPart innards, float value) {
        if (innard) {
            innards.f_104207_ = true;
            if (isActive) {
                innards.f_233553_ = 1.0f + Mth.m_14031_((float)(value / 7.0f)) / 10.0f;
                innards.f_233555_ = 1.0f + Mth.m_14031_((float)(value / 8.0f)) / 10.0f;
                innards.f_233554_ = 1.0f + Mth.m_14031_((float)(value / 6.0f)) / 10.0f;
            } else {
                innards.m_233569_();
            }
        } else {
            innards.f_104207_ = false;
        }
    }

    @Override
    public void setupAnim(T entity, float ageInTicks) {
        this.animateBrain(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).HasBrain(), ageInTicks);
        this.animateBlood(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).getBiomass() > 0, this.Blood, ageInTicks);
        this.animateHeart(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).HasHeart(), this.Heart, ageInTicks);
        this.animateInnards(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).getAmountOfInnards() > 0, this.InnardsTop, ageInTicks);
        this.animateInnards(((ZoaholicBlockEntity)entity).isActive(), ((ZoaholicBlockEntity)entity).getAmountOfInnards() > 1, this.InnardsDown, -ageInTicks);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Base.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

