/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.BombFunnelModel;
import com.Harbinger.Spore.Client.Models.FireDiskModel;
import com.Harbinger.Spore.Client.Models.MushroomExplosionTop;
import com.Harbinger.Spore.Sentities.Utility.NukeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class NuclearBombRenderer<T extends NukeEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation TOP_TEXTURE = new ResourceLocation("spore", "textures/entity/bomb/top.png");
    private static final ResourceLocation FUNNEL_TEXTURE = new ResourceLocation("spore", "textures/entity/bomb/funnel.png");
    private static final ResourceLocation RING_TEXTURE = new ResourceLocation("spore", "textures/entity/bomb/fire_disk.png");
    private final BombFunnelModel<T> funnelModel = new BombFunnelModel();
    private final FireDiskModel<T> fireDiskModel = new FireDiskModel();
    private final MushroomExplosionTop<T> mushroomExplosionTop = new MushroomExplosionTop();

    public NuclearBombRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(T t) {
        return null;
    }

    public void renderTop(T bomb, PoseStack stack, MultiBufferSource bufferSource) {
        stack.m_85836_();
        stack.m_85841_(0.95f, 1.05f, 0.95f);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)TOP_TEXTURE));
        this.mushroomExplosionTop.m_7695_(stack, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    public void renderRing(T bomb, float ticks, PoseStack stack, MultiBufferSource bufferSource) {
        stack.m_85836_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)RING_TEXTURE));
        this.fireDiskModel.m_7695_(stack, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.fireDiskModel.setupAnim(bomb, 0.0f, 0.0f, ticks, 0.0f, 0.0f);
        stack.m_85849_();
    }

    public void renderFire(T bomb, float ticks, PoseStack stack, MultiBufferSource bufferSource) {
        stack.m_85836_();
        float uOffset = ticks * 0.01f % 1.0f;
        float vOffset = ticks * 0.01f * 2.0f % 1.0f;
        RenderType renderType = SporeRenderTypes.energySwirlStatic(FUNNEL_TEXTURE, uOffset, vOffset);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(renderType);
        this.funnelModel.m_7695_(stack, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    public void renderTopFire(T bomb, float ticks, PoseStack stack, MultiBufferSource bufferSource) {
        stack.m_85836_();
        float uOffset = ticks * 0.01f % 1.0f;
        float vOffset = ticks * 0.01f * 2.0f % 1.0f;
        RenderType renderType = SporeRenderTypes.energySwirlStatic(FUNNEL_TEXTURE, -uOffset, -vOffset);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(renderType);
        this.mushroomExplosionTop.m_7695_(stack, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    public void render(T bomb, float entityYaw, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int value) {
        float ticks = (float)((NukeEntity)((Object)bomb)).f_19797_ + partialTick;
        stack.m_85836_();
        float scale = this.inflate(bomb);
        float yOffset = 1.5f * (1.0f / scale);
        stack.m_85837_(0.0, (double)yOffset, 0.0);
        stack.m_85845_(Vector3f.f_122227_.m_122240_(-180.0f));
        stack.m_85837_(0.0, -((double)((NukeEntity)((Object)bomb)).getInitRange() / 1.2), 0.0);
        stack.m_85841_(scale, scale, scale);
        this.renderTopFire(bomb, ticks, stack, bufferSource);
        this.renderFire(bomb, ticks, stack, bufferSource);
        this.renderTop(bomb, stack, bufferSource);
        this.renderRing(bomb, ticks, stack, bufferSource);
        stack.m_85849_();
        super.m_7392_(bomb, entityYaw, partialTick, stack, bufferSource, value);
    }

    public float inflate(T bomb) {
        return Math.max(((NukeEntity)((Object)bomb)).getInitRange(), 1.0f);
    }
}

