/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Special;

import com.Harbinger.Spore.Client.Layers.EyeLayer;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BaseInfectedRenderer<T extends Mob, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    private final EntityRenderDispatcher entityRenderer;

    public BaseInfectedRenderer(EntityRendererProvider.Context context, M model, float shadow) {
        super(context, model, shadow);
        this.m_115326_(new EyeLayer(this, this.eyeLayerTexture()));
        this.entityRenderer = context.m_174022_();
    }

    public abstract ResourceLocation eyeLayerTexture();

    protected boolean isShaking(T type) {
        if (type instanceof Infected) {
            Infected infected = (Infected)((Object)type);
            return infected.isFreazing();
        }
        if (type instanceof Calamity) {
            Calamity calamity = (Calamity)type;
            return calamity.isStunned();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7392_(T type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        Infected infected;
        if (type instanceof Infected && Objects.equals((infected = (Infected)((Object)type)).getOrigin(), "")) {
            super.m_7392_(type, value1, value2, stack, bufferSource, light);
            return;
        }
        if (type instanceof Infected) {
            infected = (Infected)((Object)type);
            Entity entity = Minecraft.m_91087_().f_91075_;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                MobEffectInstance instance = player.m_21124_((MobEffect)Seffects.MADNESS.get());
                Entity entityForm = this.getForm(infected);
                if (instance != null && instance.m_19564_() > 0 && player.m_20270_((Entity)infected) > 30.0f && entityForm instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entityForm;
                    this.renderIllusions(living, infected, value2, stack, bufferSource, light);
                    return;
                }
                super.m_7392_(type, value1, value2, stack, bufferSource, light);
                return;
            }
        }
        super.m_7392_(type, value1, value2, stack, bufferSource, light);
    }

    protected float getBob(Infected illusion, float p_115306_) {
        return (float)illusion.f_19797_ + p_115306_;
    }

    public Entity getForm(Infected infected) {
        ResourceLocation location = new ResourceLocation(infected.getOrigin());
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
        return entityType != null ? entityType.m_20615_(infected.f_19853_) : null;
    }

    public void renderIllusions(LivingEntity living, Infected infected, float value2, PoseStack stack, MultiBufferSource source, int light) {
        float f = Mth.m_14189_((float)value2, (float)infected.f_20884_, (float)infected.f_20883_);
        float f1 = Mth.m_14189_((float)value2, (float)infected.f_20886_, (float)infected.f_20885_);
        float f2 = f1 - f;
        float f6 = Mth.m_14179_((float)value2, (float)infected.f_19860_, (float)infected.m_146909_());
        float f7 = this.getBob(infected, value2);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (infected.m_6084_()) {
            f8 = Mth.m_14179_((float)value2, (float)infected.f_20923_, (float)infected.f_20924_);
            f5 = infected.f_20925_ - infected.f_20924_ * (1.0f - value2);
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        if (living != null) {
            stack.m_85836_();
            stack.m_85845_(Vector3f.f_122225_.m_122240_(-infected.f_20883_));
            stack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            stack.m_85837_(0.0, -1.5, 0.0);
            EntityRenderer entityRenderer = this.entityRenderer.m_114382_((Entity)living);
            if (entityRenderer instanceof MobRenderer) {
                MobRenderer mobRenderer = (MobRenderer)entityRenderer;
                EntityModel model = mobRenderer.m_7200_();
                ResourceLocation texture = mobRenderer.m_5478_((Entity)living);
                VertexConsumer consumer = source.m_6299_(RenderType.m_110452_((ResourceLocation)texture));
                model.m_6839_((Entity)living, f5, f8, value2);
                model.m_6973_((Entity)living, f5, f8, f7, f2, f6);
                model.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            stack.m_85849_();
        }
    }
}

